/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.SplashScreen;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.io.FileRead;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.util.StrUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import javax.swing.JApplet;

public class JAlice
extends JApplet {
    public static final String iVprog_version = "0.3.1";
    private static boolean parserError = false;
    private static final boolean ILM_DEBUG_LOAD = false;
    private static String lang = "";
    private static String country = "";
    private File aliceHomeDirectory = null;
    private File aliceUserDirectory = null;
    private SplashScreen splashScreen;
    private AuthoringTool authoringTool;
    private boolean mainHasFinished = false;
    private static boolean isApplet = false;
    private static JAlice staticInstance;

    public static boolean getParserError() {
        return parserError;
    }

    public static void setParserError(boolean bl) {
        parserError = bl;
    }

    public static JAlice getInstance() {
        if (staticInstance == null) {
            staticInstance = new JAlice();
        }
        return staticInstance;
    }

    public static AuthoringTool getAuthoringTool() {
        if (staticInstance == null) {
            staticInstance = new JAlice();
            System.err.println("Error: JAlice.java: getAuthoringTool(): instance was empty! " + JAlice.staticInstance.authoringTool);
        }
        return JAlice.staticInstance.authoringTool;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void main(String[] stringArray) {
        System.out.println(".: iVprog: version 0.3.1 :.");
        I18n.setConfig(stringArray);
        I18n.defineBundle(true);
        JAlice jAlice = JAlice.getInstance();
        isApplet = false;
        jAlice.principal();
        staticInstance = jAlice;
        File file = FileRead.getFileArg(stringArray);
        if (file != null) {
            int n = jAlice.authoringTool.loadWorld(file, true);
            if (n == 1) {
                System.out.println("File " + FileRead.fileName() + " successfully loaded.");
                jAlice.setAliceHomeDirectory(file);
                jAlice.setAliceUserDirectory(file);
                jAlice.authoringTool.setCurrentWorldLocation(file);
            } else {
                System.err.println("File " + FileRead.fileName() + " unsuccessfully loaded... " + n);
            }
        }
    }

    public void init() {
        String string = "";
        String string2 = "";
        System.out.println(" .: iVprog: version 0.3.1 :.");
        staticInstance = this;
        lang = this.getParameter("lang");
        country = this.getParameter("country");
        I18n.setLanguage(lang, country);
        isApplet = true;
        this.principal();
        string2 = this.getParameter("MA_PARAM_PropositionURL");
        string = this.getParameter("MA_PARAM_Proposition");
        boolean bl = true;
        if (string != null && string != "") {
            try {
                String string3 = "";
                parserError = false;
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    String string4 = StrUtilities.readFromURL(this, string);
                    if (string4 != null && !string4.trim().substring(0, 2).equals("%3")) {
                        string3 = URLEncoder.encode(string4);
                        string3 = string3.replaceAll("%0A", "");
                    } else {
                        string3 = string4;
                    }
                } else {
                    string3 = string;
                }
                this.authoringTool.loadAppletWorld(string3);
                ReferenceFrame.setReferenceFrame(this.authoringTool.getWorld());
                if (!parserError) {
                    bl = false;
                } else {
                    System.out.println("JAlice.java: applet: started content: " + parserError + " = has error? ");
                }
            }
            catch (Exception exception) {
                String string5 = "<>";
                int n = 0;
                if (string != null && string != "") {
                    n = string.length();
                    n = n > 30 ? 30 : n;
                    string5 = string.substring(0, n);
                }
                System.err.println("Error: JAlice.java: init(): " + string5 + ": " + exception.toString());
            }
        }
        if (bl) {
            System.out.println(" - try to clear the content..." + parserError);
            if (this.authoringTool != null) {
                this.authoringTool.newWorld();
            } else {
                System.err.println("JAlice.java: init(): Sorry, it was not possible to initiate a new program/algorithm...");
            }
        }
        try {
            this.setJMenuBar(this.authoringTool.getJAliceFrame().getJMenuBar());
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: init(): 1: " + this.authoringTool + ": " + exception.toString());
        }
        try {
            this.getContentPane().add(this.authoringTool.getJAliceFrame().getContentPane());
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: init(): 2: " + this.authoringTool + ": " + exception.toString());
        }
    }

    public String getAnswer() {
        String string = "";
        if (!this.authoringTool.getWorldHasBeenModified()) {
            return "-1";
        }
        try {
            string = AppletWorldStorer.getWorldXml(this.authoringTool.getWorld());
            int n = string != null && string != "" ? string.length() : 0;
            String string2 = n > 30 ? string.substring(0, 30) : string;
            System.out.println("JAlice.java: #getAnswer()=" + n + ": " + string2);
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: getAnswer(): couldn't get the student's answer: " + exception.toString());
        }
        return string;
    }

    public String getEvaluation() {
        return "-1";
    }

    private void principal() {
        try {
            this.splashScreen = this.initSplashScreen();
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 1: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            if (!this.isApplet()) {
                this.splashScreen.showSplash();
                try {
                    File file = new File(this.getAliceUserDirectory(), "aliceHasNotExited.txt");
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                    outputStreamWriter.write("iVProg has not exited propertly yet.");
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 2: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            this.authoringTool = AuthoringTool.getNewInstance();
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 3: " + exception.toString());
            exception.printStackTrace();
        }
        if (!this.isApplet()) {
            this.splashScreen.hideSplash();
        }
        this.mainHasFinished = true;
    }

    private SplashScreen initSplashScreen() {
        return new SplashScreen();
    }

    public boolean isMainFinished() {
        return this.mainHasFinished;
    }

    public void setAliceHomeDirectory(File file) {
        this.aliceHomeDirectory = file;
    }

    public File getAliceHomeDirectory() {
        if (this.aliceHomeDirectory == null) {
            if (System.getProperty("alice.home") != null) {
                this.setAliceHomeDirectory(new File(System.getProperty("alice.home")).getAbsoluteFile());
            } else {
                this.setAliceHomeDirectory(new File(System.getProperty("user.dir")).getAbsoluteFile());
            }
        }
        return this.aliceHomeDirectory;
    }

    public void setAliceUserDirectory(File file) {
        this.aliceUserDirectory = file;
    }

    public File getAliceUserDirectory() {
        if (this.aliceUserDirectory == null) {
            File file = null;
            if (System.getProperty("alice.userDir") != null) {
                file = new File(System.getProperty("alice.userDir")).getAbsoluteFile();
            }
            File file2 = new File(System.getProperty("user.home")).getAbsoluteFile();
            File file3 = this.getAliceHomeDirectory();
            File file4 = null;
            if (file != null) {
                file4 = file;
            } else if (file2.exists() && file2.canRead() && file2.canWrite()) {
                file4 = new File(file2, ".alice");
            } else if (file3 != null && file3.exists() && file3.canRead() && file3.canWrite()) {
                file4 = new File(file3, ".alice");
            }
            if (file4 != null) {
                if (file4.exists()) {
                    this.setAliceUserDirectory(file4);
                } else if (file4.mkdir()) {
                    this.setAliceUserDirectory(file4);
                }
            }
        }
        return this.aliceUserDirectory;
    }
}

