/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import java.util.ArrayList;
import java.util.List;

public class EditorManager {
    protected AuthoringTool authoringTool;
    protected List availableEditors = new ArrayList();
    protected List inUseEditors = new ArrayList();

    public EditorManager(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public Editor getEditorInstance(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.availableEditors.listIterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e.getClass() != clazz) continue;
            object.remove();
            this.inUseEditors.add(e);
            return (Editor)e;
        }
        object = EditorUtilities.getEditorFromClass(clazz);
        if (object != null) {
            this.authoringTool.addAuthoringToolStateListener((AuthoringToolStateListener)object);
            this.inUseEditors.add(object);
            object.setAuthoringTool(this.authoringTool);
        }
        return object;
    }

    public void releaseEditorInstance(Editor editor) {
        if (this.inUseEditors.contains(editor)) {
            this.inUseEditors.remove(editor);
            if (!this.availableEditors.contains(editor)) {
                this.availableEditors.add(editor);
            }
        }
    }
}

