/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.swing;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.ReturnValueTracker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class DialogManager {
    private static Stack s_stack = new Stack();

    private static JDialog createModalDialog(String string) {
        Component component;
        try {
            component = (Component)s_stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            component = new Frame("empty stack");
            component.setVisible(true);
        }
        JDialog jDialog = component instanceof Dialog ? new JDialog((Dialog)component, string, true) : new JDialog((Frame)component, string, true);
        jDialog.setDefaultCloseOperation(0);
        return jDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showModalDialog(JDialog jDialog, boolean bl) {
        if (jDialog.isModal()) {
            if (bl) {
                jDialog.setLocationRelativeTo(jDialog.getOwner());
            }
            s_stack.push(jDialog);
            try {
                jDialog.setVisible(true);
            }
            finally {
                s_stack.pop();
            }
        } else {
            System.err.println("Error: DialogManager.java: showModalDialog(...): RuntimeException");
            throw new RuntimeException("DialogManager only handles *modal* dialogs");
        }
    }

    private static void showModalDialog(JDialog jDialog) {
        DialogManager.showModalDialog(jDialog, true);
    }

    public static void initialize(Window window) {
        s_stack.clear();
        s_stack.push(window);
    }

    public static int showDialog(ContentPane contentPane) {
        JDialog jDialog = DialogManager.createModalDialog(contentPane.getTitle());
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)contentPane, "Center");
        jDialog.pack();
        class ContentPaneReturnValueTracker
        extends ReturnValueTracker {
            private ContentPane m_contentPane;
            private ActionListener m_okListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (m_contentPane.isReadyToDispose(0)) {
                        this.setReturnValue(0);
                        this.getDialog().dispose();
                    }
                }
            };
            private ActionListener m_cancelListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (m_contentPane.isReadyToDispose(2)) {
                        this.setReturnValue(2);
                        this.getDialog().dispose();
                    }
                }
            };

            public ContentPaneReturnValueTracker(JDialog jDialog, ContentPane contentPane) {
                super(jDialog, 2);
                this.m_contentPane = contentPane;
                this.m_contentPane.addOKActionListener(this.m_okListener);
                this.m_contentPane.addCancelActionListener(this.m_cancelListener);
            }

            protected void onWindowClosing(WindowEvent windowEvent) {
                if (this.m_contentPane.isReadyToDispose(2)) {
                    this.setReturnValue(2);
                    this.m_contentPane.handleDispose();
                }
            }

            public void removeListeners() {
                super.removeListeners();
                this.m_contentPane.removeOKActionListener(this.m_okListener);
                this.m_contentPane.removeCancelActionListener(this.m_cancelListener);
            }
        }
        ContentPaneReturnValueTracker contentPaneReturnValueTracker = new ContentPaneReturnValueTracker(jDialog, contentPane);
        contentPane.preDialogShow(jDialog);
        DialogManager.showModalDialog(jDialog, false);
        contentPane.postDialogShow(jDialog);
        contentPaneReturnValueTracker.removeListeners();
        return contentPaneReturnValueTracker.getReturnValue();
    }

    public static Color showDialog(JColorChooser jColorChooser, String string, Color color) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ColorTracker
        implements ActionListener {
            Color m_color = null;
            final /* synthetic */ JColorChooser val$colorChooser;

            ColorTracker(JColorChooser jColorChooser) {
                this.val$colorChooser = jColorChooser;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.m_color = this.val$colorChooser.getColor();
            }

            public Color getColor() {
                return this.m_color;
            }
        }
        ColorTracker colorTracker = new ColorTracker(jColorChooser);
        Component component = (Component)s_stack.peek();
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, colorTracker, null);
        DialogManager.showModalDialog(jDialog);
        return colorTracker.getColor();
    }

    public static int showDialog(JFileChooser jFileChooser, String string) {
        if (string != null) {
            jFileChooser.setApproveButtonText(string);
            jFileChooser.setDialogType(2);
        }
        String string2 = jFileChooser.getUI().getDialogTitle(jFileChooser);
        jFileChooser.getAccessibleContext().setAccessibleDescription(string2);
        JDialog jDialog = DialogManager.createModalDialog(string2);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        class FileChooserReturnValueTracker
        extends ReturnValueTracker {
            private JFileChooser m_fileChooser;
            private ActionListener m_actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ApproveSelection")) {
                        this.setReturnValue(0);
                    } else if (string.equals("CancelSelection")) {
                        this.setReturnValue(1);
                    }
                    this.getDialog().dispose();
                }
            };

            public FileChooserReturnValueTracker(JDialog jDialog, JFileChooser jFileChooser) {
                super(jDialog, 1);
                this.m_fileChooser = jFileChooser;
                this.m_fileChooser.addActionListener(this.m_actionListener);
            }

            protected void onWindowClosing(WindowEvent windowEvent) {
                this.setReturnValue(1);
                this.getDialog().dispose();
            }

            public void removeListeners() {
                super.removeListeners();
                this.m_fileChooser.removeActionListener(this.m_actionListener);
            }
        }
        FileChooserReturnValueTracker fileChooserReturnValueTracker = new FileChooserReturnValueTracker(jDialog, jFileChooser);
        jFileChooser.rescanCurrentDirectory();
        DialogManager.showModalDialog(jDialog);
        fileChooserReturnValueTracker.removeListeners();
        return fileChooserReturnValueTracker.getReturnValue();
    }

    public static int showOpenDialog(JFileChooser jFileChooser) {
        jFileChooser.setDialogType(0);
        return DialogManager.showDialog(jFileChooser, null);
    }

    public static int showSaveDialog(JFileChooser jFileChooser) {
        jFileChooser.setDialogType(1);
        return DialogManager.showDialog(jFileChooser, null);
    }

    private static String getUIManagerString(Object object) {
        if (object.equals("OptionPane.inputDialogTitle")) {
            return "Input";
        }
        if (object.equals("OptionPane.messageDialogTitle")) {
            return "Message";
        }
        if (object.equals("OptionPane.titleText")) {
            return "Select an Option";
        }
        return "";
    }

    public static String showInputDialog(Object object, String string, int n) {
        return (String)DialogManager.showInputDialog(object, string, n, null, null, null, false);
    }

    public static String showNumericDialog(Object object, String string, int n) {
        return (String)DialogManager.showInputDialog(object, string, n, null, null, null, true);
    }

    public static Object showInputDialog(Object object, String string, int n, Icon icon, Object[] objectArray, Object object2, boolean bl) {
        JOptionPane jOptionPane = new JOptionPane(object, n, 2, icon, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        if (bl) {
            DialogManager.addTextFieldListener(jOptionPane.getComponents());
        }
        Component component = (Component)s_stack.peek();
        jOptionPane.setComponentOrientation(component.getComponentOrientation());
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        DialogManager.showModalDialog(jDialog);
        Object object3 = jOptionPane.getInputValue();
        if (object3 == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return object3;
    }

    private static void addTextFieldListener(Component[] componentArray) {
        if (componentArray == null || componentArray.length < 1) {
            return;
        }
        for (Component component : componentArray) {
            if (component instanceof JPanel) {
                JPanel jPanel = (JPanel)component;
                DialogManager.addTextFieldListener(jPanel.getComponents());
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            component.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (!Character.isDigit(c) && c != '-' && c != '.' && c != '\b' && c != '\u007f') {
                        keyEvent.consume();
                    }
                }
            });
        }
    }

    public static void showMessageDialog(Object object) {
        DialogManager.showMessageDialog(object, DialogManager.getUIManagerString("OptionPane.messageDialogTitle"), 1);
    }

    public static void showMessageDialog(Object object, String string, int n) {
        DialogManager.showMessageDialog(object, string, n, null);
    }

    public static void showMessageDialog(Object object, String string, int n, Icon icon) {
        DialogManager.showOptionDialog(object, string, -1, n, icon, null, null);
    }

    public static int showConfirmDialog(Object object) {
        return DialogManager.showConfirmDialog(object, DialogManager.getUIManagerString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Object object, String string, int n) {
        return DialogManager.showConfirmDialog(object, string, n, 3);
    }

    public static int showConfirmDialog(Object object, String string, int n, int n2) {
        return DialogManager.showConfirmDialog(object, string, n, n2, null);
    }

    public static int showConfirmDialog(Object object, String string, int n, int n2, Icon icon) {
        return DialogManager.showOptionDialog(object, string, n, n2, icon, null, null);
    }

    public static int showOptionDialog(Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        jOptionPane.setInitialValue(object2);
        Component component = (Component)s_stack.peek();
        jOptionPane.setComponentOrientation(component.getComponentOrientation());
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        DialogManager.showModalDialog(jDialog);
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!objectArray[i].equals(object3)) continue;
            return i;
        }
        return -1;
    }

    public static void showTextDialog(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 25, 15, 25));
        JTextPane jTextPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        jPanel.add(jScrollPane);
        JDialog jDialog = new JDialog((Frame)AuthoringTool.getInstance().getJAliceFrame(), true);
        jDialog.setBounds(0, 0, 800, 500);
        jDialog.add(jPanel);
        DialogManager.showModalDialog(jDialog);
    }
}

