/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public abstract class WorldListener {
    private World m_world;
    private ChildrenListener m_childrenListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent childrenEvent) {
            WorldListener.this.handleChildrenChanging(childrenEvent);
        }

        public void childrenChanged(ChildrenEvent childrenEvent) {
            if (childrenEvent.getChangeType() == 1) {
                WorldListener.this.hookUp(childrenEvent.getChild());
            } else if (childrenEvent.getChangeType() == 3) {
                WorldListener.this.unhookUp(childrenEvent.getChild());
            }
            WorldListener.this.handleChildrenChanged(childrenEvent);
        }
    };
    private PropertyListener m_propertyListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent propertyEvent) {
            WorldListener.this.handlePropertyChanging(propertyEvent);
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            WorldListener.this.handlePropertyChanged(propertyEvent);
        }
    };
    private ObjectArrayPropertyListener m_objectArrayPropertyListener = new ObjectArrayPropertyListener(){

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            WorldListener.this.handleObjectArrayPropertyChanging(objectArrayPropertyEvent);
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            WorldListener.this.handleObjectArrayPropertyChanged(objectArrayPropertyEvent);
        }
    };

    protected abstract void handleChildrenChanging(ChildrenEvent var1);

    protected abstract void handleChildrenChanged(ChildrenEvent var1);

    protected abstract void handlePropertyChanging(PropertyEvent var1);

    protected abstract void handlePropertyChanged(PropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanging(ObjectArrayPropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanged(ObjectArrayPropertyEvent var1);

    protected abstract boolean isPropertyListeningRequired(Property var1);

    protected abstract boolean isObjectArrayPropertyListeningRequired(ObjectArrayProperty var1);

    public World getWorld() {
        return this.m_world;
    }

    public void setWorld(World world) {
        if (this.m_world != world) {
            if (this.m_world != null) {
                this.unhookUp(this.m_world);
            }
            this.m_world = world;
            if (this.m_world != null) {
                this.hookUp(this.m_world);
            }
        }
    }

    private boolean isChildrenListenerHookedUp(Element element) {
        ChildrenListener[] childrenListenerArray;
        for (ChildrenListener childrenListener : childrenListenerArray = element.getChildrenListeners()) {
            if (childrenListener != this.m_childrenListener) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyListenerHookedUp(Property property) {
        PropertyListener[] propertyListenerArray;
        for (PropertyListener propertyListener : propertyListenerArray = property.getPropertyListeners()) {
            if (propertyListener != this.m_propertyListener) continue;
            return true;
        }
        return false;
    }

    private boolean isObjectArrayPropertyListenerHookedUp(ObjectArrayProperty objectArrayProperty) {
        ObjectArrayPropertyListener[] objectArrayPropertyListenerArray;
        for (ObjectArrayPropertyListener objectArrayPropertyListener : objectArrayPropertyListenerArray = objectArrayProperty.getObjectArrayPropertyListeners()) {
            if (objectArrayPropertyListener != this.m_objectArrayPropertyListener) continue;
            return true;
        }
        return false;
    }

    private void unhookUp(Element element) {
        if (this.isChildrenListenerHookedUp(element)) {
            element.removeChildrenListener(this.m_childrenListener);
        }
        Property[] propertyArray = element.getProperties();
        Object[] objectArray = propertyArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Property property = objectArray[i];
            if (this.isPropertyListeningRequired(property) && this.isPropertyListenerHookedUp(property)) {
                property.removePropertyListener(this.m_propertyListener);
            }
            if (!(property instanceof ObjectArrayProperty) || !this.isObjectArrayPropertyListeningRequired((ObjectArrayProperty)(object = (ObjectArrayProperty)property)) || !this.isObjectArrayPropertyListenerHookedUp((ObjectArrayProperty)object)) continue;
            ((ObjectArrayProperty)object).removeObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
        }
        for (Object object : objectArray = element.getChildren()) {
            this.unhookUp((Element)object);
        }
    }

    private void hookUp(Element element) {
        if (!this.isChildrenListenerHookedUp(element)) {
            element.addChildrenListener(this.m_childrenListener);
        }
        Property[] propertyArray = element.getProperties();
        Object[] objectArray = propertyArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Property property = objectArray[i];
            if (this.isPropertyListeningRequired(property) && !this.isPropertyListenerHookedUp(property)) {
                property.addPropertyListener(this.m_propertyListener);
            }
            if (!(property instanceof ObjectArrayProperty) || !this.isObjectArrayPropertyListeningRequired((ObjectArrayProperty)(object = (ObjectArrayProperty)property)) || this.isObjectArrayPropertyListenerHookedUp((ObjectArrayProperty)object)) continue;
            ((ObjectArrayProperty)object).addObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
        }
        for (Object object : objectArray = element.getChildren()) {
            this.hookUp((Element)object);
        }
    }
}

