/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;

public class DoInOrder
extends CompositeResponse {
    private static Class[] s_supportedCoercionClasses = new Class[]{DoTogether.class};

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public class RuntimeDoInOrder
    extends CompositeResponse.RuntimeCompositeResponse {
        private int m_index = 0;
        private double m_timeRemaining;

        protected boolean preLoopTest(double d) {
            return true;
        }

        protected boolean postLoopTest(double d) {
            return false;
        }

        protected int getChildCount() {
            Response.RuntimeResponse[] runtimeResponseArray = this.getRuntimeResponses();
            return runtimeResponseArray.length;
        }

        protected double getChildTimeRemaining(int n, double d) {
            Response.RuntimeResponse[] runtimeResponseArray = this.getRuntimeResponses();
            return runtimeResponseArray[n].getTimeRemaining(d);
        }

        protected void childPrologueIfNecessary(int n, double d) {
            Response.RuntimeResponse[] runtimeResponseArray = this.getRuntimeResponses();
            if (!runtimeResponseArray[n].isActive()) {
                runtimeResponseArray[n].prologue(d);
            }
        }

        protected void childUpdate(int n, double d) {
            Response.RuntimeResponse[] runtimeResponseArray = this.getRuntimeResponses();
            runtimeResponseArray[n].update(d);
        }

        protected void childEpilogue(int n, double d) {
            Response.RuntimeResponse[] runtimeResponseArray = this.getRuntimeResponses();
            runtimeResponseArray[n].epilogue(d);
        }

        protected boolean isCullable() {
            return this.getChildCount() == 0;
        }

        public void prologue(double d) {
            super.prologue(d);
            this.m_index = -1;
        }

        public void update(double d) {
            super.update(d);
            if (this.isCullable()) {
                this.m_timeRemaining = 0.0;
            } else {
                double d2;
                this.m_timeRemaining = Double.POSITIVE_INFINITY;
                do {
                    if (this.m_index == -1) {
                        if (this.preLoopTest(d)) {
                            if (this.getChildCount() == 0) {
                                if (this.postLoopTest(d)) {
                                    this.m_index = -1;
                                    break;
                                }
                                this.m_timeRemaining = 0.0;
                                break;
                            }
                            this.m_index = 0;
                        } else {
                            this.m_timeRemaining = 0.0;
                            break;
                        }
                    }
                    this.childPrologueIfNecessary(this.m_index, d);
                    this.childUpdate(this.m_index, d);
                    d2 = this.getChildTimeRemaining(this.m_index, d);
                    if (d2 <= 0.0) {
                        this.childEpilogue(this.m_index, d);
                        ++this.m_index;
                    }
                    if (this.m_index != this.getChildCount()) continue;
                    if (this.postLoopTest(d)) {
                        this.m_index = -1;
                        continue;
                    }
                    this.m_timeRemaining = 0.0;
                    break;
                } while (d2 < 0.0);
            }
        }

        public double getTimeRemaining(double d) {
            return this.m_timeRemaining;
        }
    }
}

