/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.clock;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.World;

public class DefaultClock
implements Clock {
    private World m_world;
    private double m_time;
    private long m_whenPrev;
    private int m_pauseCount;

    public World getWorld() {
        return this.m_world;
    }

    public void setWorld(World world) {
        this.m_world = world;
    }

    public void start() {
        this.m_pauseCount = 0;
        this.m_whenPrev = System.currentTimeMillis();
        if (this.m_world != null) {
            this.m_world.start();
        }
    }

    public void stop() {
        this.m_pauseCount = 0;
        this.m_whenPrev = -1L;
        if (this.m_world != null) {
            this.m_world.stop();
        }
    }

    public void pause() {
        ++this.m_pauseCount;
    }

    public void resume() {
        --this.m_pauseCount;
        if (this.m_pauseCount == 0) {
            this.m_whenPrev = System.currentTimeMillis();
        }
    }

    private void updateTime() {
        long l = System.currentTimeMillis();
        long l2 = l - this.m_whenPrev;
        if (l2 > 0L) {
            double d = (double)l2 * 0.001;
            this.m_time += d;
        }
        this.m_whenPrev = l;
    }

    public double getTime() {
        return this.m_time;
    }

    public double getTimeElapsed() {
        return this.getTime();
    }

    public void schedule() {
        if (this.m_pauseCount == 0 && this.m_world != null) {
            this.updateTime();
            this.m_world.schedule();
        }
    }
}

