/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.question.PickQuestion;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseButtonClickBehavior
extends TriggerBehavior
implements MouseListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{MouseButtonIsPressedBehavior.class};
    public final IntegerProperty requiredModifierMask = new IntegerProperty(this, "requiredModifierMask", new Integer(0));
    public final IntegerProperty excludedModifierMask = new IntegerProperty(this, "excludedModifierMask", new Integer(0));
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    public final TransformableProperty onWhat = new TransformableProperty((Element)this, "onWhat", null);
    private RenderTarget[] m_renderTargets = null;
    private MouseEvent m_pressedEvent = null;
    public long m_clickTimeThreshold = 300L;
    public int m_clickDistanceThresholdSquared = 100;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureAnyNecessaryDetails() {
        if (this.details.size() == 2) {
            PickQuestion pickQuestion = new PickQuestion();
            pickQuestion.name.set("what");
            pickQuestion.setParent(this);
            this.details.add(pickQuestion);
        }
        for (int i = 0; i < this.details.size(); ++i) {
            Object object = this.details.get(i);
            if (!(object instanceof PickQuestion)) continue;
            ((PickQuestion)object).name.set("what");
        }
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable variable = new Variable();
        variable.name.set("x");
        variable.setParent(this);
        variable.valueClass.set(Number.class);
        this.details.add(variable);
        Variable variable2 = new Variable();
        variable2.name.set("y");
        variable2.setParent(this);
        variable2.valueClass.set(Number.class);
        this.details.add(variable2);
        this.manufactureAnyNecessaryDetails();
    }

    private boolean checkModifierMask(InputEvent inputEvent) {
        int n = inputEvent.getModifiers();
        Integer n2 = (Integer)this.requiredModifierMask.getValue();
        Integer n3 = (Integer)this.excludedModifierMask.getValue();
        int n4 = 0;
        if (n2 != null) {
            n4 = n2;
        }
        int n5 = 0;
        if (n3 != null) {
            n5 = n3;
        }
        return (n & n4) == n4 && (n & n5) == 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_pressedEvent = mouseEvent;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Transformable transformable;
        int n = mouseEvent.getX() - this.m_pressedEvent.getX();
        int n2 = mouseEvent.getY() - this.m_pressedEvent.getY();
        long l = mouseEvent.getWhen() - this.m_pressedEvent.getWhen();
        if (l >= this.m_clickTimeThreshold || n * n + n2 * n2 >= this.m_clickDistanceThresholdSquared || !this.isEnabled.booleanValue() || !this.checkModifierMask(mouseEvent) || (transformable = this.onWhat.getTransformableValue()) != null) {
            // empty if block
        }
    }

    protected void started(World world, double d) {
        super.started(world, d);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.addMouseListener(this);
        }
    }

    protected void stopped(World world, double d) {
        super.stopped(world, d);
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.removeMouseListener(this);
        }
        this.m_renderTargets = null;
    }
}

