/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.AbstractConditionalBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyIsPressedBehavior
extends AbstractConditionalBehavior
implements KeyListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{KeyClickBehavior.class};
    private int m_keyCode = -1;
    public final IntegerProperty keyCode = new IntegerProperty(this, "keyCode", null);
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    private RenderTarget[] m_renderTargets = null;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable variable = new Variable();
        variable.name.set("keyChar");
        variable.setParent(this);
        variable.valueClass.set(Character.class);
        this.details.add(variable);
    }

    private void updateDetails(KeyEvent keyEvent) {
        for (int i = 0; i < this.details.size(); ++i) {
            Variable variable = (Variable)this.details.get(i);
            if (!variable.name.getStringValue().equals("keyChar")) continue;
            variable.value.set(new Character(keyEvent.getKeyChar()));
        }
    }

    private boolean checkKeyCode(int n) {
        int n2 = this.keyCode.intValue(n);
        return n == n2;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (this.m_keyCode == -1 && this.checkKeyCode(n = keyEvent.getKeyCode())) {
            this.m_keyCode = n;
            this.updateDetails(keyEvent);
            this.set(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        if (this.m_keyCode != -1 && (n = keyEvent.getKeyCode()) == this.m_keyCode) {
            this.updateDetails(keyEvent);
            this.set(false);
            this.m_keyCode = -1;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void started(World world, double d) {
        super.started(world, d);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.addKeyListener(this);
        }
        this.m_keyCode = -1;
    }

    protected void stopped(World world, double d) {
        super.stopped(world, d);
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.removeKeyListener(this);
        }
        this.m_renderTargets = null;
    }
}

