/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.MouseLookingBehavior;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.property.DictionaryProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.VertexArrayProperty;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceResolver;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;
import edu.cmu.cs.stage3.alice.core.response.ForEach;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.FileSystemTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import edu.cmu.cs.stage3.io.ZipFileTreeStorer;
import edu.cmu.cs.stage3.io.ZipTreeLoader;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.VisitListener;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import edu.cmu.cs.stage3.xml.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Element {
    private static Hashtable s_classnameMap = new Hashtable();
    public static final char SEPARATOR = '.';
    private static final String XML_FILENAME = "elementData.xml";
    private static int s_loadProgress;
    public final StringProperty name = new StringProperty(this, "name", null);
    public final DictionaryProperty data = new DictionaryProperty(this, "data", null);
    private Element m_parent = null;
    public Vector m_children = new Vector();
    private Element[] m_childArray = null;
    public Vector m_childrenListeners = new Vector();
    private ChildrenListener[] m_childrenListenerArray = null;
    private Object m_xmlFileKeepKey = null;
    public static boolean s_isLoading;
    private Property[] m_propertyArray = null;
    private boolean m_isReleased = false;
    private static final char[] ILLEGAL_NAME_CHARACTERS;
    private static Hashtable s_classToElementCache;

    public void markKeepKeyDirty() {
        if (!s_isLoading) {
            this.m_xmlFileKeepKey = null;
        }
    }

    public Code compile(Object object, CompileType compileType) {
        return this.getWorld().compile(object, compileType);
    }

    public Object eval(Code code) {
        return this.getWorld().eval(code);
    }

    public void exec(Code code) {
        this.getWorld().exec(code);
    }

    private static boolean isPropertyField(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Property.class.isAssignableFrom(field.getType());
    }

    private static boolean isIllegal(char c) {
        for (char c2 : ILLEGAL_NAME_CHARACTERS) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    private static boolean is8Bit(char c) {
        char c2 = c;
        return (c2 & 0xFF) == c2;
    }

    public static boolean isPotentialNameValid(String string) {
        byte[] byArray;
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.trim().length() != string.length()) {
            return false;
        }
        for (byte by : byArray = string.getBytes()) {
            char c = (char)by;
            if (Element.is8Bit(c)) {
                if (!Element.isIllegal(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void checkForInvalidName(String string) {
        if (string != null) {
            int n;
            char[] cArray;
            String string2 = string.trim();
            if (string2.length() != string.length()) {
                throw new IllegalNameValueException(string, "We're sorry, but names in Alice may not have spaces at the beginning or end.");
            }
            if (string.length() == 0) {
                throw new IllegalNameValueException(string, "We're sorry, but names in Alice may not be empty.");
            }
            char[] objectArray = cArray = new char[]{'\t', '\n', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '.'};
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                char throwable = objectArray[n];
                if (string.indexOf(throwable) == -1) continue;
                throw new IllegalNameValueException(string, "We're sorry, but names in Alice may only contain letters and numbers.  The character \"" + throwable + "\" can not be used in a name.");
            }
            byte[] byArray = string.getBytes();
            for (n2 = 0; n2 < byArray.length; ++n2) {
                if (Element.is8Bit((char)byArray[n2])) continue;
                try {
                    n = string.charAt(n2);
                }
                catch (Throwable throwable) {
                    n = (char)byArray[n2];
                }
                throw new IllegalNameValueException(string, "We're sorry, but names in Alice may only contain letters and numbers.  The character \"" + (char)n + "\" can not be used in a name.");
            }
        }
    }

    private void checkForNameCollision(Element element, String string) {
        Element element2;
        if (element != null && string != null && (element2 = element.getChildNamedIgnoreCase(string)) != null && element2 != this && !string.equalsIgnoreCase("GeorgeForeman")) {
            throw new IllegalNameValueException(string, "Unfortunately, something else in this world is already named \"" + string + ",\" so you can't use that name here.");
        }
    }

    public void HACK_nameChanged() {
        Element[] elementArray;
        this.markKeepKeyDirty();
        for (Element element : elementArray = this.getChildren()) {
            element.HACK_nameChanged();
        }
    }

    protected void nameValueChanging(String string) {
        this.checkForInvalidName(string);
        this.checkForNameCollision(this.m_parent, string);
    }

    protected void nameValueChanged(String string) {
        PropertyReference[] propertyReferenceArray;
        for (PropertyReference propertyReference : propertyReferenceArray = this.getExternalPropertyReferences(HowMuch.INSTANCE_AND_ALL_DESCENDANTS)) {
            propertyReference.getProperty().getOwner().markKeepKeyDirty();
        }
    }

    public void propertyCreated(Property property) {
        this.markKeepKeyDirty();
    }

    protected void propertyChanging(Property property, Object object) {
        if (property == this.name) {
            this.nameValueChanging((String)object);
        }
    }

    protected void propertyChanged(Property property, Object object) {
        if (property == this.name) {
            this.nameValueChanged((String)object);
        }
    }

    public final void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isReleased()) {
            throw new RuntimeException("property change attempted on released element: " + propertyEvent.getProperty());
        }
        this.propertyChanging(propertyEvent.getProperty(), propertyEvent.getValue());
    }

    public final void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isReleased()) {
            throw new RuntimeException("property changed on released element" + propertyEvent.getProperty());
        }
        this.propertyChanged(propertyEvent.getProperty(), propertyEvent.getValue());
        if (propertyEvent.getProperty() == this.name) {
            this.getRoot().HACK_nameChanged();
        }
    }

    protected void internalRelease(int n) {
        Element[] elementArray;
        this.m_isReleased = true;
        for (Element element : elementArray = this.getChildren()) {
            element.internalRelease(n);
        }
    }

    public final void release() {
        if (!this.m_isReleased) {
            for (int i = 0; i < 3; ++i) {
                this.internalRelease(i);
            }
        }
    }

    public boolean isReleased() {
        return this.m_isReleased;
    }

    protected void finalize() throws Throwable {
        if (!this.isReleased()) {
            this.release();
        }
        super.finalize();
    }

    public Class[] getSupportedCoercionClasses() {
        return null;
    }

    public boolean isCoercionSupported() {
        Class[] classArray = this.getSupportedCoercionClasses();
        return classArray != null && classArray.length > 0;
    }

    public Element coerceTo(Class clazz) {
        Property property;
        Element element;
        Object object;
        Object object2;
        World world = this.getWorld();
        PropertyReference[] propertyReferenceArray = new PropertyReference[]{};
        String[] stringArray = new String[]{};
        if (world != null) {
            propertyReferenceArray = world.getPropertyReferencesTo(this, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, false);
            stringArray = new String[propertyReferenceArray.length];
        }
        for (int i = 0; i < propertyReferenceArray.length; ++i) {
            object2 = propertyReferenceArray[i];
            Element element2 = ((PropertyReference)object2).getReference();
            stringArray[i] = element2.getKey(world);
            if (object2 instanceof ObjectArrayPropertyReference) {
                object = (ObjectArrayPropertyReference)object2;
                ObjectArrayProperty objectArrayProperty = ((ObjectArrayPropertyReference)object).getObjectArrayProperty();
                objectArrayProperty.set(((ObjectArrayPropertyReference)object).getIndex(), (Object)null);
                continue;
            }
            object = ((PropertyReference)object2).getProperty();
            ((Property)object).set(null);
        }
        try {
            element = (Element)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionWrapper(illegalAccessException, clazz.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new ExceptionWrapper(instantiationException, clazz.toString());
        }
        object2 = this.getParent();
        if (object2 != null) {
            int n = ((Element)object2).getIndexOfChild(this);
            this.setParent(null);
            ((Element)object2).insertChildAt(element, n);
        }
        Element[] elementArray = this.getChildren();
        object = elementArray;
        int n = ((Element[])object).length;
        for (int i = 0; i < n; ++i) {
            Object object3 = object[i];
            ((Element)object3).setParent(element);
        }
        for (Object object4 : object = this.getProperties()) {
            property = element.getPropertyNamed(((Property)object4).getName());
            if (property == null) continue;
            property.set(((Property)object4).get());
        }
        for (int i = 0; i < propertyReferenceArray.length; ++i) {
            Object object4;
            PropertyReference propertyReference = propertyReferenceArray[i];
            String string = stringArray[i];
            object4 = world.getDescendantKeyed(string);
            property = propertyReference.getProperty();
            if (property.getOwner() == this) {
                property = element.getPropertyNamed(property.getName());
            }
            if (property == null) continue;
            if (propertyReference instanceof ObjectArrayPropertyReference) {
                ObjectArrayProperty objectArrayProperty = (ObjectArrayProperty)property;
                objectArrayProperty.set(((ObjectArrayPropertyReference)propertyReference).getIndex(), object4);
                continue;
            }
            property.set(object4);
        }
        return element;
    }

    public Property[] getProperties() {
        if (this.m_propertyArray == null) {
            Field[] fieldArray;
            Class<?> clazz = this.getClass();
            Vector<Property> vector = new Vector<Property>();
            for (Field field : fieldArray = clazz.getFields()) {
                if (!Element.isPropertyField(field)) continue;
                try {
                    Property property = (Property)field.get(this);
                    if (property == null || property.isDeprecated()) continue;
                    vector.addElement(property);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            this.m_propertyArray = new Property[vector.size()];
            vector.copyInto(this.m_propertyArray);
        }
        return this.m_propertyArray;
    }

    public Property getPropertyNamed(String string) {
        Property[] propertyArray;
        for (Property property : propertyArray = this.getProperties()) {
            if (!property.getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    public Element getParent() {
        return this.m_parent;
    }

    public void setParent(Element element) {
        if (element != this.m_parent) {
            if (this.m_parent != null) {
                this.m_parent.internalRemoveChild(this);
                this.m_parent = null;
            }
            if (element != null) {
                element.addChild(this);
            }
        }
    }

    private void checkAllPropertiesForBadReferences() {
        Property[] propertyArray;
        for (Property property : propertyArray = this.getProperties()) {
            property.checkForBadReferences(property.get());
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).checkAllPropertiesForBadReferences();
        }
    }

    protected void internalSetParent(Element element) {
        if (element != null) {
            this.checkForNameCollision(element, this.name.getStringValue());
            if (element == this) {
                throw new RuntimeException(this + " cannot be its own parent.");
            }
            if (element.isDescendantOf(this)) {
                throw new RuntimeException(this + " cannot have descendant " + element + " as its parent.");
            }
        }
        Element element2 = this.m_parent;
        this.m_parent = element;
        try {
            this.checkAllPropertiesForBadReferences();
        }
        catch (RuntimeException runtimeException) {
            this.m_parent = element2;
            throw runtimeException;
        }
    }

    public Element getRoot() {
        if (this.m_parent == null) {
            return this;
        }
        return this.m_parent.getRoot();
    }

    public World getWorld() {
        Element element = this.getRoot();
        if (element instanceof World) {
            return (World)element;
        }
        return null;
    }

    public Sandbox getSandbox() {
        if (this instanceof Sandbox) {
            if (this instanceof World) {
                return (World)this;
            }
            if (this.m_parent instanceof World) {
                return (Sandbox)this;
            }
        }
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.getSandbox();
    }

    public boolean isDescendantOf(Element element) {
        for (Element element2 = this.getParent(); element2 != null; element2 = element2.getParent()) {
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Element element) {
        if (element != null) {
            return element.isDescendantOf(this);
        }
        return false;
    }

    private void buildDetailedPath(StringBuffer stringBuffer) {
        if (this.m_parent != null) {
            this.m_parent.buildDetailedPath(stringBuffer);
        }
        stringBuffer.append("\t");
        stringBuffer.append(this.name.getStringValue());
        stringBuffer.append(" ");
        stringBuffer.append(this.getClass());
        stringBuffer.append("\n");
    }

    private String getInternalGetKeyExceptionDescription(Element element, Element element2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("Could not find ancestor: ");
        if (element != null) {
            stringBuffer2.append(element.name.getStringValue());
            stringBuffer2.append(", class: ");
            stringBuffer2.append(element.getClass());
        } else {
            stringBuffer2.append("null");
        }
        stringBuffer2.append("\nKey: ");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("\nDetails: ");
        element2.buildDetailedPath(stringBuffer2);
        return stringBuffer2.toString();
    }

    private void internalGetKey(Element element, Element element2, StringBuffer stringBuffer) {
        if (this.m_parent != element && this != element) {
            if (this.m_parent == null && element != null) {
                throw new RuntimeException(this.getInternalGetKeyExceptionDescription(element, element2, stringBuffer));
            }
            this.m_parent.internalGetKey(element, element2, stringBuffer);
        }
        if (this != element) {
            stringBuffer.append(this.getRepr());
        }
        if (this != element2) {
            stringBuffer.append('.');
        }
    }

    public String getKey(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        this.internalGetKey(element, this, stringBuffer);
        return new String(stringBuffer);
    }

    public String getKey() {
        return this.getKey(null);
    }

    public String getTrimmedKey() {
        Element element = this.getSandbox();
        if (element != null) {
            element = element.getParent();
        }
        return this.getKey(element);
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public Element getChildAt(int n) {
        if (n >= this.m_children.size()) {
            return null;
        }
        return (Element)this.m_children.elementAt(n);
    }

    public int getIndexOfChild(Element element) {
        return this.m_children.indexOf(element);
    }

    private Element internalGetChildNamed(String string, boolean bl) {
        if (string != null) {
            if (string.startsWith("__Unnamed") && string.endsWith("__")) {
                Element element = this.getChildAt(Integer.parseInt(string.substring(9, string.length() - 2)));
                if (element != null) {
                    if (element.name.get() == null) {
                        return element;
                    }
                    return null;
                }
                return null;
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                boolean bl2;
                Element element = this.getChildAt(i);
                if (!(string != null ? (bl2 = bl ? string.equalsIgnoreCase(element.name.getStringValue()) : string.equals(element.name.getStringValue())) : element.name.getStringValue() == null)) continue;
                return element;
            }
            return null;
        }
        return null;
    }

    public Element getChildNamed(String string) {
        return this.internalGetChildNamed(string, false);
    }

    public Element getChildNamedIgnoreCase(String string) {
        return this.internalGetChildNamed(string, true);
    }

    private Element internalGetDescendantKeyed(String string, int n, boolean bl) {
        if (string.equals("")) {
            return this;
        }
        int n2 = string.indexOf(46, n);
        if (n2 == -1) {
            String string2 = string.substring(n);
            return this.internalGetChildNamed(string2, bl);
        }
        String string3 = string.substring(n, n2);
        Element element = this.internalGetChildNamed(string3, bl);
        if (element != null) {
            return element.internalGetDescendantKeyed(string, n2 + 1, bl);
        }
        return null;
    }

    public Element getDescendantKeyed(String string) {
        return this.internalGetDescendantKeyed(string, 0, false);
    }

    public Element getDescendantKeyedIgnoreCase(String string) {
        return this.internalGetDescendantKeyed(string, 0, true);
    }

    public Element[] getChildren() {
        if (this.m_childArray == null) {
            this.m_childArray = new Element[this.m_children.size()];
            this.m_children.copyInto(this.m_childArray);
        }
        return this.m_childArray;
    }

    public Element[] getChildren(Class clazz) {
        Vector vector = new Vector();
        for (int i = 0; i < this.m_children.size(); ++i) {
            Object e = this.m_children.elementAt(i);
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            vector.addElement(e);
        }
        Object[] objectArray = new Element[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected int internalGetElementCount(Class clazz, HowMuch howMuch, int n) {
        if (clazz.isAssignableFrom(this.getClass())) {
            ++n;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            n = this.getChildAt(i).internalGetElementCount(clazz, howMuch, n);
        }
        return n;
    }

    public int getElementCount(Class clazz, HowMuch howMuch) {
        return this.internalGetElementCount(clazz, howMuch, 0);
    }

    public int getElementCount(Class clazz) {
        return this.getElementCount(clazz, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public int getElementCount() {
        return this.getElementCount(Element.class);
    }

    public void internalSearch(Criterion criterion, HowMuch howMuch, Vector vector) {
        if (criterion.accept(this)) {
            vector.addElement(this);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).internalSearch(criterion, howMuch, vector);
        }
    }

    public Element[] search(Criterion criterion, HowMuch howMuch) {
        Vector vector = new Vector();
        this.internalSearch(criterion, howMuch, vector);
        Object[] objectArray = new Element[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Element[] search(Criterion criterion) {
        return this.search(criterion, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public Element[] getDescendants(Class clazz, HowMuch howMuch) {
        Element[] elementArray = this.search(new InstanceOfCriterion(clazz), howMuch);
        if (clazz == Element.class) {
            return elementArray;
        }
        Object object = Array.newInstance(clazz, elementArray.length);
        System.arraycopy(elementArray, 0, object, 0, elementArray.length);
        return (Element[])object;
    }

    public Element[] getDescendants(Class clazz) {
        return this.getDescendants(clazz, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public Element[] getDescendants() {
        return this.getDescendants(Element.class);
    }

    public void setPropertyNamed(String string, Object object, HowMuch howMuch) {
        Property property = this.getPropertyNamed(string);
        if (property != null) {
            property.set(object, howMuch);
        } else {
            for (int i = 0; i < this.m_children.size(); ++i) {
                Element element = this.getChildAt(i);
                element.setPropertyNamed(string, object, howMuch);
            }
        }
    }

    private void onChildrenChanging(ChildrenEvent childrenEvent) {
        Enumeration enumeration = this.m_childrenListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enumeration.nextElement();
            childrenListener.childrenChanging(childrenEvent);
        }
    }

    private void onChildrenChange(ChildrenEvent childrenEvent) {
        this.m_childArray = null;
        this.markKeepKeyDirty();
        Enumeration enumeration = this.m_childrenListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enumeration.nextElement();
            childrenListener.childrenChanged(childrenEvent);
        }
    }

    private boolean internalRemoveChild(Element element) {
        int n = this.m_children.indexOf(element);
        if (n != -1) {
            ChildrenEvent childrenEvent = new ChildrenEvent(this, element, 3, n, -1);
            this.onChildrenChanging(childrenEvent);
            this.m_children.removeElementAt(n);
            this.onChildrenChange(childrenEvent);
            return true;
        }
        return false;
    }

    public void insertChildAt(Element element, int n) {
        if (element.getParent() == this) {
            int n2 = this.m_children.indexOf(element);
            if (n != n2) {
                ChildrenEvent childrenEvent = new ChildrenEvent(this, element, 2, n2, n);
                this.onChildrenChanging(childrenEvent);
                this.m_children.removeElementAt(n2);
                if (n == -1) {
                    n = this.m_children.size();
                }
                this.m_children.insertElementAt(element, n);
                this.onChildrenChange(childrenEvent);
            }
        } else {
            if (n == -1) {
                n = this.m_children.size();
            }
            if (this.m_children.contains(element)) {
                throw new RuntimeException(element + " is already a child of " + this);
            }
            element.internalSetParent(this);
            ChildrenEvent childrenEvent = new ChildrenEvent(this, element, 1, -1, n);
            this.onChildrenChanging(childrenEvent);
            this.m_children.insertElementAt(element, n);
            this.onChildrenChange(childrenEvent);
        }
    }

    public void addChild(Element element) {
        this.insertChildAt(element, -1);
    }

    public void removeChild(Element element) {
        if (this.internalRemoveChild(element)) {
            element.internalSetParent(null);
        }
    }

    public void addChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.addElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public void removeChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.removeElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public ChildrenListener[] getChildrenListeners() {
        if (this.m_childrenListenerArray == null) {
            this.m_childrenListenerArray = new ChildrenListener[this.m_childrenListeners.size()];
            this.m_childrenListeners.copyInto(this.m_childrenListenerArray);
        }
        return this.m_childrenListenerArray;
    }

    public void visit(VisitListener visitListener, HowMuch howMuch) {
        visitListener.visited(this);
        if (howMuch.getDescend()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Element element = this.getChildAt(i);
                if (howMuch.getRespectDescendant()) continue;
                element.visit(visitListener, howMuch);
            }
        }
    }

    public boolean isReferenceInternalTo(Element element) {
        return this == element || this.isDescendantOf(element);
    }

    public boolean isReferenceExternalFrom(Element element) {
        return !this.isReferenceInternalTo(element);
    }

    protected void internalGetExternalPropertyReferences(Element element, HowMuch howMuch, Vector vector) {
        Property[] propertyArray;
        for (Property property : propertyArray = this.getProperties()) {
            Object object;
            if (property instanceof ObjectArrayProperty) {
                object = (ObjectArrayProperty)property;
                int n = 0;
                for (int i = 0; i < ((ObjectArrayProperty)object).size(); ++i) {
                    Object object2 = ((ObjectArrayProperty)object).get(i);
                    if (!(object2 instanceof Element) || !((Element)object2).isReferenceExternalFrom(element)) continue;
                    vector.addElement(new ObjectArrayPropertyReference((ObjectArrayProperty)object, null, i, n++));
                }
                continue;
            }
            object = property.get();
            if (!(object instanceof Element) || !((Element)object).isReferenceExternalFrom(element)) continue;
            vector.addElement(new PropertyReference(property, null));
        }
        if (howMuch.getDescend()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Element element2 = this.getChildAt(i);
                if (howMuch.getRespectDescendant()) continue;
                element2.internalGetExternalPropertyReferences(element, howMuch, vector);
            }
        }
    }

    public PropertyReference[] getExternalPropertyReferences(HowMuch howMuch) {
        Vector vector = new Vector();
        this.internalGetExternalPropertyReferences(this, howMuch, vector);
        Object[] objectArray = new PropertyReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PropertyReference[] getExternalPropertyReferences() {
        return this.getExternalPropertyReferences(HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    protected void internalGetPropertyReferencesTo(Element element, HowMuch howMuch, boolean bl, boolean bl2, Vector vector) {
        if (bl2 && (this == element || this.isDescendantOf(element))) {
            return;
        }
        if (this != element.getParent() || !bl) {
            Property[] propertyArray = this.getProperties();
            for (Property property : propertyArray) {
                Object object;
                if (property instanceof ObjectArrayProperty) {
                    object = (ObjectArrayProperty)property;
                    int n = 0;
                    for (int i = 0; i < ((ObjectArrayProperty)object).size(); ++i) {
                        Object object2 = ((ObjectArrayProperty)object).get(i);
                        if (!(object2 instanceof Element) || !((Element)object2).isReferenceInternalTo(element)) continue;
                        vector.addElement(new ObjectArrayPropertyReference((ObjectArrayProperty)object, null, i, n++));
                    }
                    continue;
                }
                object = property.get();
                if (!(object instanceof Element) || !((Element)object).isReferenceInternalTo(element)) continue;
                vector.addElement(new PropertyReference(property, null));
            }
        }
        if (howMuch.getDescend()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Element element2 = this.getChildAt(i);
                if (howMuch.getRespectDescendant()) continue;
                element2.internalGetPropertyReferencesTo(element, howMuch, bl, bl2, vector);
            }
        }
    }

    public PropertyReference[] getPropertyReferencesTo(Element element, HowMuch howMuch, boolean bl, boolean bl2) {
        Vector vector = new Vector();
        this.internalGetPropertyReferencesTo(element, howMuch, bl, bl2, vector);
        Object[] objectArray = new PropertyReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PropertyReference[] getPropertyReferencesTo(Element element, HowMuch howMuch, boolean bl) {
        return this.getPropertyReferencesTo(element, howMuch, bl, true);
    }

    public PropertyReference[] getPropertyReferencesTo(Element element, HowMuch howMuch) {
        return this.getPropertyReferencesTo(element, howMuch, true);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element element, HowMuch howMuch, boolean bl, boolean bl2) {
        return element.getPropertyReferencesTo(this, howMuch, bl, bl2);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element element, HowMuch howMuch, boolean bl) {
        return this.getPropertyReferencesToMe(element, howMuch, bl, true);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element element, HowMuch howMuch) {
        return this.getPropertyReferencesToMe(element, howMuch, true);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element element) {
        return this.getPropertyReferencesToMe(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public PropertyReference[] getPropertyReferencesToMe() {
        return this.getPropertyReferencesToMe(this.getRoot());
    }

    public void removeFromParentsProperties() {
        Element element = this.getParent();
        if (element != null) {
            PropertyReference[] propertyReferenceArray;
            for (PropertyReference propertyReference : propertyReferenceArray = element.getPropertyReferencesTo(this, HowMuch.INSTANCE, false, true)) {
                if (propertyReference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference objectArrayPropertyReference = (ObjectArrayPropertyReference)propertyReference;
                    objectArrayPropertyReference.getObjectArrayProperty().remove(objectArrayPropertyReference.getIndex() - objectArrayPropertyReference.getPrecedingTotal());
                    continue;
                }
                propertyReference.getProperty().set(null);
            }
        }
    }

    public void removeFromParent() {
        Element element = this.getRoot();
        PropertyReference[] propertyReferenceArray = element.getPropertyReferencesTo(this, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
        if (propertyReferenceArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ExternalReferenceException:\n");
            for (PropertyReference propertyReference : propertyReferenceArray) {
                stringBuffer.append(propertyReference);
                stringBuffer.append("\n");
            }
            throw new RuntimeException(stringBuffer.toString());
        }
        this.removeFromParentsProperties();
        this.setParent(null);
    }

    public boolean isAssignableToOneOf(Class[] classArray) {
        if (classArray != null) {
            Class<?> clazz = this.getClass();
            for (Class clazz2 : classArray) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    private CopyFactory createCopyFactory(Class[] classArray, HowMuch howMuch, Element element) {
        return new CopyFactory(this, element, classArray, howMuch);
    }

    public CopyFactory createCopyFactory(Class[] classArray, HowMuch howMuch) {
        return this.createCopyFactory(classArray, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, this);
    }

    public CopyFactory createCopyFactory(Class[] classArray) {
        return this.createCopyFactory(classArray, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public Element HACK_createCopy(String string, Element element, int n, Class[] classArray, Element element2) {
        CopyFactory copyFactory = this.createCopyFactory(classArray);
        try {
            Element element3 = copyFactory.manufactureCopy(this.getRoot(), null, null, element2);
            element3.name.set(string);
            if (element != null) {
                element.insertChildAt(element3, n);
            }
            return element3;
        }
        catch (UnresolvablePropertyReferencesException unresolvablePropertyReferencesException) {
            unresolvablePropertyReferencesException.printStackTrace();
            throw new ExceptionWrapper(unresolvablePropertyReferencesException, "UnresolvablePropertyReferencesException");
        }
    }

    public Element createCopyNamed(String string, Class[] classArray) {
        CopyFactory copyFactory = this.createCopyFactory(classArray);
        try {
            Element element = copyFactory.manufactureCopy(this.getRoot());
            element.name.set(string);
            return element;
        }
        catch (UnresolvablePropertyReferencesException unresolvablePropertyReferencesException) {
            unresolvablePropertyReferencesException.printStackTrace();
            throw new ExceptionWrapper(unresolvablePropertyReferencesException, "UnresolvablePropertyReferencesException");
        }
    }

    public Element createCopyNamed(String string) {
        return this.createCopyNamed(string, null);
    }

    protected void internalCopyOver(Element element, boolean bl, Dictionary dictionary) {
        Object object;
        Object object2;
        Element[] elementArray = this.getChildren();
        Object[] objectArray = elementArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Element element2 = objectArray[i];
            Object object3 = element2.name.getStringValue();
            object2 = null;
            if (object3 != null && !((String)object3).equals("__ita__")) {
                object2 = element.getChildNamedIgnoreCase((String)object3);
            }
            if (object2 != null) {
                element2.internalCopyOver((Element)object2, false, dictionary);
                continue;
            }
            object = element2.createCopyFactory(null, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, this);
            dictionary.put(object, element);
        }
        for (Object object3 : objectArray = this.getProperties()) {
            if (bl && (((String)(object2 = ((Property)object3).getName())).equals("name") || ((String)object2).equals("vehicle") || ((String)object2).equals("localTransformation")) || object3 instanceof ObjectArrayProperty && !(object3 instanceof VertexArrayProperty) || (object2 = ((Property)object3).get()) instanceof Element || (object = element.getPropertyNamed(((Property)object3).getName())) == null) continue;
            ((Property)object).set(object2);
        }
    }

    protected void loadCompleted() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).loadCompleted();
        }
    }

    private static Element load(DocumentBuilder documentBuilder, DirectoryTreeLoader directoryTreeLoader, Vector vector, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        String string = directoryTreeLoader.getCurrentDirectory();
        try {
            InputStream inputStream = directoryTreeLoader.readFile(XML_FILENAME);
            Document document = documentBuilder.parse(inputStream);
            org.w3c.dom.Element element = document.getDocumentElement();
            element.normalize();
            String string2 = element.getAttribute("class");
            String string3 = element.getAttribute("name");
            try {
                Object object;
                Object object2;
                Class<?> clazz = Class.forName(string2);
                Element element2 = (Element)clazz.newInstance();
                try {
                    element2.m_xmlFileKeepKey = directoryTreeLoader.getKeepKey(XML_FILENAME);
                }
                catch (KeepFileNotSupportedException keepFileNotSupportedException) {
                    element2.m_xmlFileKeepKey = null;
                }
                if (string3.length() > 0) {
                    element2.name.set(string3);
                }
                NodeList nodeList = element.getElementsByTagName("property");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    org.w3c.dom.Element element3 = (org.w3c.dom.Element)nodeList.item(i);
                    object2 = element3.getAttribute("name").trim();
                    object = element2.getPropertyNamed((String)object2);
                    if (object == null) continue;
                    ((Property)object).decode(element3, vector);
                }
                ++s_loadProgress;
                if (progressObserver != null) {
                    progressObserver.progressUpdate(s_loadProgress, element2.name.getStringValue());
                }
                NodeList nodeList2 = element.getElementsByTagName("child");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    object2 = (org.w3c.dom.Element)nodeList2.item(i);
                    object = object2.getAttribute("filename").trim();
                    directoryTreeLoader.setCurrentDirectory((String)object);
                    Element element4 = Element.load(documentBuilder, directoryTreeLoader, vector, progressObserver);
                    String string4 = element4.name.getStringValue();
                    if (string4 != null && element2.getChildNamed(string4) != null) {
                        element4 = null;
                        System.err.println(element2 + " already has child named " + string4 + ".  skipping.");
                    }
                    if (element4 != null) {
                        element2.addChild(element4);
                    }
                    directoryTreeLoader.setCurrentDirectory(string);
                }
                return element2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ExceptionWrapper(classNotFoundException, "ClassNotFoundException: " + string2);
            }
            catch (InstantiationException instantiationException) {
                throw new ExceptionWrapper(instantiationException, "InstantiationException: " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExceptionWrapper(illegalAccessException, "IllegalAccessException: " + string2);
            }
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException, "org.xml.sax.SAXException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element load(DirectoryTreeLoader directoryTreeLoader, Element element, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        Element element2;
        Vector vector = new Vector();
        Vector<PropertyReference> vector2 = new Vector<PropertyReference>();
        try {
            Object object;
            s_isLoading = true;
            int n = -1;
            try {
                object = new BufferedReader(new InputStreamReader(new BufferedInputStream(directoryTreeLoader.readFile("elementCountHint.txt"))));
                n = Integer.parseInt(((BufferedReader)object).readLine());
                directoryTreeLoader.closeCurrentFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            s_loadProgress = 0;
            if (progressObserver != null) {
                progressObserver.progressBegin(n);
            }
            try {
                object = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                element2 = Element.load(documentBuilder, directoryTreeLoader, vector, progressObserver);
                DefaultReferenceResolver defaultReferenceResolver = new DefaultReferenceResolver(element2, element);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    PropertyReference propertyReference = (PropertyReference)enumeration.nextElement();
                    try {
                        propertyReference.resolve(defaultReferenceResolver);
                    }
                    catch (UnresolvableReferenceException unresolvableReferenceException) {
                        vector2.add(propertyReference);
                    }
                    catch (Throwable throwable) {
                        System.err.println(propertyReference);
                        throwable.printStackTrace();
                    }
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ExceptionWrapper(parserConfigurationException, "loader: " + directoryTreeLoader + "; externalRoot: " + element);
            }
        }
        finally {
            if (progressObserver != null) {
                progressObserver.progressEnd();
            }
            s_isLoading = false;
        }
        if (vector2.size() == 0) {
            element2.loadCompleted();
            return element2;
        }
        Object[] objectArray = new PropertyReference[vector2.size()];
        vector2.copyInto(objectArray);
        throw new UnresolvablePropertyReferencesException((PropertyReference[])objectArray, element2, "loader: " + directoryTreeLoader + "; externalRoot: " + element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element load(File file, Element element, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        Object object;
        DirectoryTreeLoader directoryTreeLoader = null;
        if (file.isDirectory()) {
            directoryTreeLoader = new FileSystemTreeLoader();
        } else {
            object = file.getAbsolutePath();
            if (((String)object).endsWith(".a2w") || ((String)object).endsWith(".a2c") || ((String)object).endsWith(".zip")) {
                directoryTreeLoader = new ZipFileTreeLoader();
            } else {
                throw new IllegalArgumentException(file + " must be a directory or end in \".a2w\", \".a2c\", or \".zip\".");
            }
        }
        directoryTreeLoader.open(file);
        object = null;
        try {
            object = Element.load(directoryTreeLoader, element, progressObserver);
        }
        finally {
            directoryTreeLoader.close();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element load(URL uRL, Element element, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        ZipTreeLoader zipTreeLoader = new ZipTreeLoader();
        zipTreeLoader.open(uRL);
        Element element2 = null;
        try {
            element2 = Element.load(zipTreeLoader, element, progressObserver);
        }
        finally {
            zipTreeLoader.close();
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element load(InputStream inputStream, Element element, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        ZipTreeLoader zipTreeLoader = new ZipTreeLoader();
        zipTreeLoader.open(inputStream);
        Element element2 = null;
        try {
            element2 = Element.load(zipTreeLoader, element, progressObserver);
        }
        finally {
            zipTreeLoader.close();
        }
        return element2;
    }

    private void writeXMLDocument(Document document, DirectoryTreeStorer directoryTreeStorer, String string) throws IOException {
        OutputStream outputStream = directoryTreeStorer.createFile(string, true);
        Encoder.write(document, outputStream);
        directoryTreeStorer.closeCurrentFile();
    }

    protected int internalStore(DocumentBuilder documentBuilder, DirectoryTreeStorer directoryTreeStorer, ProgressObserver progressObserver, HowMuch howMuch, ReferenceGenerator referenceGenerator, int n) throws IOException, ProgressCancelException {
        Object object;
        Object object2;
        ++n;
        if (progressObserver != null) {
            progressObserver.progressUpdate(n, this.getKey());
        }
        try {
            object2 = directoryTreeStorer.getKeepKey(XML_FILENAME);
        }
        catch (KeepFileNotSupportedException keepFileNotSupportedException) {
            object2 = null;
        }
        if (this.m_xmlFileKeepKey == null || !this.m_xmlFileKeepKey.equals(object2)) {
            Property[] propertyArray;
            object = documentBuilder.newDocument();
            Property[] propertyArray2 = object.createElement("element");
            propertyArray2.setAttribute("class", this.getClass().getName());
            object.appendChild((Node)propertyArray2);
            for (int i = 0; i < this.getChildCount(); ++i) {
                Property[] propertyArray3 = object.createElement("child");
                propertyArray3.setAttribute("filename", this.getChildAt(i).getRepr(i));
                propertyArray2.appendChild((Node)propertyArray3);
            }
            for (Property property : propertyArray = this.getProperties()) {
                Object object3;
                String string = property.getName();
                if (string.equals("name")) {
                    object3 = this.name.getStringValue();
                    if (object3 == null) continue;
                    propertyArray2.setAttribute("name", (String)object3);
                    continue;
                }
                object3 = object.createElement("property");
                object3.setAttribute("name", property.getName());
                property.encode((Document)object, (org.w3c.dom.Element)object3, directoryTreeStorer, referenceGenerator);
                propertyArray2.appendChild((Node)object3);
            }
            object.getDocumentElement().normalize();
            this.writeXMLDocument((Document)object, directoryTreeStorer, XML_FILENAME);
            try {
                this.m_xmlFileKeepKey = directoryTreeStorer.getKeepKey(XML_FILENAME);
            }
            catch (KeepFileNotSupportedException keepFileNotSupportedException) {
                this.m_xmlFileKeepKey = null;
            }
        } else {
            try {
                directoryTreeStorer.keepFile(XML_FILENAME);
                object = this.getProperties();
                for (Property property : object) {
                    if (property.get() == null) continue;
                    property.keepAnyAssociatedFiles(directoryTreeStorer);
                }
            }
            catch (KeepFileNotSupportedException keepFileNotSupportedException) {
                keepFileNotSupportedException.printStackTrace();
            }
            catch (KeepFileDoesNotExistException keepFileDoesNotExistException) {
                keepFileDoesNotExistException.printStackTrace();
            }
        }
        object = directoryTreeStorer.getCurrentDirectory();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element = this.getChildAt(i);
            String string = element.getRepr(i);
            directoryTreeStorer.createDirectory(string);
            directoryTreeStorer.setCurrentDirectory(string);
            n = element.internalStore(documentBuilder, directoryTreeStorer, progressObserver, howMuch, referenceGenerator, n);
            directoryTreeStorer.setCurrentDirectory((String)object);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DirectoryTreeStorer directoryTreeStorer, ProgressObserver progressObserver, Dictionary dictionary, HowMuch howMuch, ReferenceGenerator referenceGenerator) throws IOException, ProgressCancelException {
        Object object;
        Object object2;
        int n = this.getElementCount(Element.class, howMuch);
        if (progressObserver != null) {
            progressObserver.progressBegin(n);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(directoryTreeStorer.createFile("elementCountHint.txt", true))));
        bufferedWriter.write(Integer.toString(n));
        bufferedWriter.newLine();
        bufferedWriter.flush();
        directoryTreeStorer.closeCurrentFile();
        if (dictionary != null && dictionary.size() > 0) {
            object2 = dictionary.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                byte[] byArray = (byte[])dictionary.get(object);
                OutputStream outputStream = directoryTreeStorer.createFile((String)object, false);
                outputStream.write(byArray);
                outputStream.flush();
                directoryTreeStorer.closeCurrentFile();
            }
        }
        try {
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            int n2 = this.internalStore((DocumentBuilder)object, directoryTreeStorer, progressObserver, howMuch, referenceGenerator, 0);
            if (n != n2) {
                // empty if block
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        finally {
            if (progressObserver != null) {
                progressObserver.progressEnd();
            }
        }
    }

    public void store(DirectoryTreeStorer directoryTreeStorer, ProgressObserver progressObserver, Dictionary dictionary, HowMuch howMuch) throws IOException, ProgressCancelException {
        this.store(directoryTreeStorer, progressObserver, dictionary, howMuch, new DefaultReferenceGenerator(this));
    }

    public void store(DirectoryTreeStorer directoryTreeStorer, ProgressObserver progressObserver, Dictionary dictionary) throws IOException, ProgressCancelException {
        this.store(directoryTreeStorer, progressObserver, dictionary, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public void store(DirectoryTreeStorer directoryTreeStorer, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(directoryTreeStorer, progressObserver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, ProgressObserver progressObserver, Dictionary dictionary) throws IOException, ProgressCancelException {
        ZipFileTreeStorer zipFileTreeStorer = new ZipFileTreeStorer();
        zipFileTreeStorer.open(file);
        try {
            this.store(zipFileTreeStorer, progressObserver, dictionary);
        }
        finally {
            zipFileTreeStorer.close();
        }
    }

    public void store(File file, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(file, progressObserver, null);
    }

    public void store(String string, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(new File(string), progressObserver);
    }

    private String getUnnamedRepr(int n) {
        return "__Unnamed" + n + "__";
    }

    public String getRepr(int n) {
        String string = this.name.getStringValue();
        if (string == null || string.length() == 0) {
            string = this.getUnnamedRepr(n);
        }
        return string;
    }

    public String getRepr() {
        String string = (String)this.name.get();
        if (string == null) {
            int n = this.m_parent != null ? this.m_parent.getIndexOfChild(this) : 0;
            string = this.getUnnamedRepr(n);
        }
        return string;
    }

    protected void started(World world, double d) {
        Element[] elementArray;
        for (Element element : elementArray = this.getChildren()) {
            element.started(world, d);
        }
    }

    protected void stopped(World world, double d) {
        Element[] elementArray;
        for (Element element : elementArray = this.getChildren()) {
            element.stopped(world, d);
        }
    }

    public static Class getValueClassForPropertyNamed(Class clazz, String string) {
        Element element = (Element)s_classToElementCache.get(clazz);
        if (element == null) {
            try {
                element = (Element)clazz.newInstance();
                s_classToElementCache.put(clazz, element);
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        Property property = element.getPropertyNamed(string);
        return property.getValueClass();
    }

    protected void internalAddExpressionIfAssignableTo(Expression expression, Class clazz, Vector vector) {
        if (expression != null && clazz.isAssignableFrom(expression.getValueClass())) {
            vector.addElement(expression);
        }
    }

    protected void internalFindAccessibleExpressions(Class clazz, Vector vector) {
        if (this.m_parent != null) {
            this.m_parent.internalFindAccessibleExpressions(clazz, vector);
        }
    }

    public Expression[] findAccessibleExpressions(Class clazz) {
        Vector vector = new Vector();
        this.internalFindAccessibleExpressions(clazz, vector);
        Object[] objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getKey() + "]";
    }

    static {
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ConditionalLoopSequentialResponse", WhileLoopInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ConditionalSequentialResponse", IfElseInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.CountLoopSequentialResponse", LoopNInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ForEachInListSequentialResponse", ForEach.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ParallelResponse", DoTogether.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.SequentialForEachInListSequentialResponse", ForEachInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.SequentialResponse", DoInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.bb2.navigation.MouseNavigationBehavior", MouseLookingBehavior.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.MetaResponse", CallToUserDefinedResponse.class);
        s_loadProgress = 0;
        s_isLoading = false;
        ILLEGAL_NAME_CHARACTERS = new char[]{'\t', '\n', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '.'};
        s_classToElementCache = new Hashtable();
    }
}

