/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class Behavior
extends Element {
    public final BooleanProperty isEnabled = new BooleanProperty(this, "isEnabled", Boolean.TRUE);
    public final ElementArrayProperty details = new ElementArrayProperty((Element)this, "details", null, Expression[].class);
    private double m_prevT;
    private boolean m_isActive = false;
    private RuntimeStack m_stack = new RuntimeStack();
    private Hashtable m_detailNameMap = new Hashtable();
    private Hashtable m_forkMap = new Hashtable();

    public void openFork(Object object, int n) {
        Fork fork = new Fork(n);
        this.m_forkMap.put(object, fork);
        this.m_stack.push(fork);
    }

    public void setForkIndex(Object object, int n) {
        Fork fork = (Fork)this.m_forkMap.get(object);
        fork.setIndex(n);
    }

    public void closeFork(Object object) {
        if (this.m_isActive) {
            this.m_stack.pop();
            this.m_forkMap.remove(object);
        }
    }

    public Stack getCurrentStack() {
        return this.m_stack.getCurrentStack();
    }

    public void manufactureAnyNecessaryDetails() {
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    protected void propertyChanged(Property property, Object object) {
        if (property == this.isEnabled) {
            if (this.m_isActive) {
                if (object == Boolean.TRUE) {
                    this.enabled();
                } else {
                    this.disabled();
                }
            }
        } else {
            super.propertyChanged(property, object);
        }
    }

    public void manufactureDetails() {
    }

    public void preSchedule(double d) {
    }

    public void postSchedule(double d) {
    }

    protected abstract void internalSchedule(double var1, double var3);

    public abstract void stopAllRuntimeResponses(double var1);

    public void schedule(double d) {
        double d2;
        if (this.isEnabled.booleanValue() && (d2 = d - this.m_prevT) > 0.0) {
            this.internalSchedule(d, d2);
            this.m_prevT = d;
        }
    }

    private Variable createRuntimeVariable(Variable variable) {
        Variable variable2 = new Variable();
        variable2.name.set(variable.name.getStringValue());
        Class clazz = variable.getValueClass();
        variable2.valueClass.set(clazz);
        Object object = variable.getValue();
        variable2.value.set(object);
        return variable2;
    }

    public Variable stackLookup(Variable variable) {
        Variable variable2 = this.m_stack.top().lookup(variable);
        return variable2;
    }

    public Variable stackLookup(String string) {
        return this.m_stack.top().lookup(string);
    }

    public Expression detailLookup(String string) {
        return (Expression)this.m_detailNameMap.get(string);
    }

    public void pushEach(Variable variable, Variable variable2) {
        Context context = new Context();
        context.m_isCeiling = false;
        context.m_variableMap.put(variable, variable2);
        context.m_nameMap.put(variable.name.getStringValue(), variable2);
        this.m_stack.push(context);
    }

    public void pushStack(Variable[] variableArray, Variable[] variableArray2, Variable[] variableArray3, Variable[] variableArray4, Variable[] variableArray5, boolean bl) {
        Object object;
        Context context = new Context();
        context.m_isCeiling = bl;
        block0: for (Variable variable : variableArray3) {
            object = variable.name.getStringValue();
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable2 = variableArray[i];
                if (((String)object).equals(variable2.name.getStringValue())) {
                    Variable variable3 = this.createRuntimeVariable(variable2);
                    context.m_nameMap.put(object, variable3);
                    context.m_variableMap.put(variable, variable3);
                    continue block0;
                }
                if (i != variableArray.length - 1) continue;
                throw new RuntimeException("missing required parameter: " + (String)object);
            }
        }
        for (Variable variable : variableArray5) {
            object = this.createRuntimeVariable(variable);
            context.m_nameMap.put(variable.name.getStringValue(), object);
            context.m_variableMap.put(variable, object);
        }
        this.m_stack.push(context);
    }

    public void popStack() {
        if (this.m_isActive) {
            this.m_stack.top();
            this.m_stack.pop();
        }
    }

    protected void internalFindAccessibleExpressions(Class clazz, Vector vector) {
        for (int i = 0; i < this.details.size(); ++i) {
            this.internalAddExpressionIfAssignableTo((Expression)this.details.get(i), clazz, vector);
        }
        super.internalFindAccessibleExpressions(clazz, vector);
    }

    protected void started(World world, double d) {
        super.started(world, d);
        this.m_prevT = d;
        this.m_stack.clear();
        this.m_detailNameMap.clear();
        this.m_forkMap.clear();
        for (int i = 0; i < this.details.size(); ++i) {
            Expression expression = (Expression)this.details.get(i);
            this.m_detailNameMap.put(expression.name.getStringValue(), expression);
        }
        this.m_isActive = true;
    }

    protected void stopped(World world, double d) {
        super.stopped(world, d);
        this.m_isActive = false;
        this.stopAllRuntimeResponses(d);
        this.m_stack.clear();
        this.m_detailNameMap.clear();
        this.m_forkMap.clear();
    }

    private class Context
    extends Single {
        private Dictionary m_variableMap;
        private Dictionary m_nameMap;
        private boolean m_isCeiling;

        private Context() {
            this.m_variableMap = new Hashtable();
            this.m_nameMap = new Hashtable();
            this.m_isCeiling = true;
        }

        public Variable lookup(Variable variable) {
            Variable variable2 = (Variable)this.m_variableMap.get(variable);
            if (variable2 != null) {
                return variable2;
            }
            if (this.m_isCeiling) {
                return variable;
            }
            return this.getPrev().lookup(variable);
        }

        public Variable lookup(String string) {
            Variable variable = (Variable)this.m_nameMap.get(string);
            if (variable != null) {
                return variable;
            }
            if (this.m_isCeiling) {
                return null;
            }
            return this.getPrev().lookup(string);
        }
    }

    private class Single
    extends Item {
        private Item m_next;

        private Single() {
        }

        public Item getNext() {
            return this.m_next;
        }

        public void setNext(Item item) {
            this.m_next = item;
        }
    }

    private class Fork
    extends Item {
        private Item[] m_nexts;
        private int m_index;

        public Fork(int n) {
            this.m_nexts = new Item[n];
            this.m_index = -1;
        }

        public Item getNext() {
            if (this.m_index < 0 || this.m_index >= this.m_nexts.length) {
                throw new ArrayIndexOutOfBoundsException(this.m_index + " not in range [0," + this.m_nexts.length + ")");
            }
            return this.m_nexts[this.m_index];
        }

        public void setNext(Item item) {
            this.m_nexts[this.m_index] = item;
        }

        public void setIndex(int n) {
            this.m_index = n;
        }
    }

    private abstract class Item {
        private Item m_prev;

        private Item() {
        }

        public Item getPrev() {
            return this.m_prev;
        }

        protected void setPrev(Item item) {
            this.m_prev = item;
        }

        public abstract Item getNext();

        public abstract void setNext(Item var1);

        public Variable lookup(Variable variable) {
            if (this.m_prev == null) {
                return variable;
            }
            return this.m_prev.lookup(variable);
        }

        public Variable lookup(String string) {
            if (this.m_prev == null) {
                return null;
            }
            return this.m_prev.lookup(string);
        }
    }

    private class RuntimeStack {
        private Item m_front;

        private RuntimeStack() {
            this.m_front = new Single();
        }

        public void clear() {
            this.m_front.setNext(null);
        }

        public void push(Item item) {
            Item item2 = this.top();
            item2.setNext(item);
            item.setPrev(item2);
        }

        public void pop() {
            Item item = this.top();
            item.getPrev().setNext(null);
            item.setPrev(null);
        }

        public Item top() {
            Item item = this.m_front;
            Item item2;
            while ((item2 = item.getNext()) != null) {
                item = item2;
            }
            return item;
        }

        public Stack getCurrentStack() {
            Item item;
            Stack<Item> stack = new Stack<Item>();
            Item item2 = this.m_front;
            while ((item = item2.getNext()) != null) {
                item2 = item;
                stack.push(item2);
            }
            return stack;
        }
    }
}

