/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.TextFieldEditablePropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class NumberPropertyViewController
extends TextFieldEditablePropertyViewController {
    protected JLabel numberLabel = new JLabel();

    public void set(Property property, boolean bl, boolean bl2, boolean bl3, PopupItemFactory popupItemFactory) {
        super.set(property, bl, bl2, true, bl3, popupItemFactory);
        this.allowEasyEditWithClick = false;
        this.refreshGUI();
    }

    protected void setValueFromString(String string) {
        Double d = AuthoringToolResources.parseDouble(string);
        if (d != null) {
            ((Runnable)this.factory.createItem(d)).run();
            String string2 = "edu.cmu.cs.stage3.alice.authoringtool.userRepr." + this.property.getName();
            this.property.getOwner().data.put(string2, string);
        } else {
            AuthoringTool.getInstance().showErrorDialog("I don't understand this number: " + string, null, false);
        }
    }

    protected Component getNativeComponent() {
        return this.numberLabel;
    }

    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getX() >= 0 && mouseEvent.getX() < mouseEvent.getComponent().getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < mouseEvent.getComponent().getHeight() && NumberPropertyViewController.this.isEnabled()) {
                    NumberPropertyViewController.this.popupButton.doClick();
                }
            }
        };
    }

    protected Class getNativeClass() {
        return Number.class;
    }

    protected void updateNativeComponent() {
        this.numberLabel.setText(AuthoringToolResources.getReprForValue(this.property.get(), this.property, this.property.getOwner().data));
    }

    protected void refreshGUI() {
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }
}

