/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.CollectionEditorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CollectionPropertyViewController
extends JButton
implements GUIElement,
Releasable {
    protected Property property;
    protected boolean omitPropertyName;
    protected PropertyListener propertyListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            CollectionPropertyViewController.this.refreshGUI();
        }
    };

    public CollectionPropertyViewController() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CollectionPropertyViewController.this.property != null) {
                    CollectionEditorPanel collectionEditorPanel = GUIFactory.getCollectionEditorPanel();
                    collectionEditorPanel.setCollection((Collection)CollectionPropertyViewController.this.property.getValue());
                    DialogManager.showMessageDialog(collectionEditorPanel, "Collection Editor", -1);
                }
            }
        });
    }

    public void set(Property property, boolean bl) {
        this.clean();
        this.property = property;
        this.omitPropertyName = bl;
        this.setBackground(AuthoringToolResources.getColor("propertyViewControllerBackground"));
        this.setMargin(new Insets(0, 4, 0, 4));
        this.startListening();
        this.refreshGUI();
    }

    public Property getProperty() {
        return this.property;
    }

    public void goToSleep() {
        this.stopListening();
    }

    public void wakeUp() {
        this.startListening();
    }

    public void clean() {
        this.stopListening();
    }

    public void die() {
        this.stopListening();
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void startListening() {
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
            if (this.property.getValue() != null) {
                ((Collection)this.property.getValue()).values.addPropertyListener(this.propertyListener);
            }
        }
    }

    public void stopListening() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
            if (this.property.getValue() != null) {
                ((Collection)this.property.getValue()).values.removePropertyListener(this.propertyListener);
            }
        }
    }

    protected void refreshGUI() {
        Object object = this.property.get();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.omitPropertyName) {
            stringBuffer.append(AuthoringToolResources.getReprForValue(this.property) + " = ");
        }
        if (object instanceof Expression) {
            stringBuffer.append(AuthoringToolResources.getNameInContext((Element)object, this.property.getOwner()));
        } else if (object == null) {
            stringBuffer.append("<None>");
        } else if (object instanceof Collection) {
            Object[] objectArray = ((Collection)object).values.getArrayValue();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(AuthoringToolResources.getReprForValue(objectArray[i]));
                    if (i >= objectArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            } else {
                stringBuffer.append("<None>");
            }
        } else {
            throw new RuntimeException("Bad value: " + object);
        }
        this.setText(stringBuffer.toString());
        this.revalidate();
        this.repaint();
    }
}

