/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach;
import edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;

public class ElementPrototype {
    protected Class elementClass;
    protected StringObjectPair[] knownPropertyValues;
    protected String[] desiredProperties;

    public ElementPrototype(Class clazz, StringObjectPair[] stringObjectPairArray, String[] stringArray) {
        if (!Element.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The elementClass given is not actually a subclass of Element.");
        }
        Element element = null;
        try {
            element = (Element)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to create a new element of type: " + clazz.getName());
        }
        if (!CallToUserDefinedResponse.class.isAssignableFrom(clazz) && !CallToUserDefinedQuestion.class.isAssignableFrom(clazz)) {
            Object object;
            if (stringObjectPairArray != null) {
                for (StringObjectPair object2 : stringObjectPairArray) {
                    object = object2.getString();
                    Object object3 = object2.getObject();
                    Property property = element.getPropertyNamed((String)object);
                    if (property == null) {
                        throw new IllegalArgumentException("property named " + (String)object + " does not exist in " + clazz.getName());
                    }
                    if (object3 == null) continue;
                    if (object3 instanceof Expression) {
                        property.getValueClass();
                        if (property.getValueClass().isAssignableFrom(object3.getClass()) || property.getValueClass().isAssignableFrom(((Expression)object3).getValueClass())) continue;
                        throw new IllegalArgumentException("property named " + (String)object + " in class " + clazz.getName() + " does not accept expressions of type " + ((Expression)object3).getValueClass().getName());
                    }
                    if (property.getValueClass().isAssignableFrom(object3.getClass())) continue;
                    throw new IllegalArgumentException("property named " + (String)object + " in class " + clazz.getName() + " does not accept values of type " + object3.getClass().getName() + "; bad value: " + object3);
                }
            } else {
                stringObjectPairArray = new StringObjectPair[]{};
            }
            if (stringArray != null) {
                for (String string : stringArray) {
                    object = element.getPropertyNamed(string);
                    if (object != null) continue;
                    throw new IllegalArgumentException("property named " + (String)string + " does not exist in " + clazz.getName());
                }
            } else {
                stringArray = new String[]{};
            }
        }
        this.elementClass = clazz;
        this.knownPropertyValues = stringObjectPairArray;
        this.desiredProperties = stringArray;
    }

    public Element createNewElement() {
        try {
            Object object;
            Element element = (Element)this.elementClass.newInstance();
            if (this.knownPropertyValues != null) {
                for (StringObjectPair stringObjectPair : this.knownPropertyValues) {
                    Element element2;
                    String string = stringObjectPair.getString();
                    Object object2 = stringObjectPair.getObject();
                    Property property = element.getPropertyNamed(string);
                    property.set(object2);
                    if (object2 instanceof PropertyValue) {
                        element2 = (PropertyValue)object2;
                        element2.removeFromParent();
                        property.getOwner().addChild(element2);
                    } else if (object2 instanceof Question) {
                        element2 = (Question)object2;
                        element2.removeFromParent();
                        property.getOwner().addChild(element2);
                        ((Question)element2).data.put("associatedProperty", property.getName());
                    }
                    if (!(object2 instanceof Element) || (element2 = (Element)object2).getParent() != null || element2 instanceof World) continue;
                    property.getOwner().addChild(element2);
                    element2.data.put("associatedProperty", property.getName());
                }
            }
            if (edu.cmu.cs.stage3.alice.core.response.ForEach.class.isAssignableFrom(this.elementClass)) {
                object = null;
                if (ForEachInOrder.class.isAssignableFrom(this.elementClass)) {
                    object = (ForEachInOrder)element;
                }
                Variable variable = new Variable();
                variable.name.set("item");
                variable.valueClass.set(Object.class);
                if (object != null) {
                    ((Element)object).addChild(variable);
                    ((edu.cmu.cs.stage3.alice.core.response.ForEach)object).each.set(variable);
                }
            } else if (ForEach.class.isAssignableFrom(this.elementClass)) {
                object = (ForEach)element;
                Variable variable = new Variable();
                variable.name.set("item");
                variable.valueClass.set(Object.class);
                ((Element)object).addChild(variable);
                ((ForEach)object).each.set(variable);
            } else if (LoopNInOrder.class.isAssignableFrom(this.elementClass)) {
                object = (LoopNInOrder)element;
                Variable variable = new Variable();
                variable.name.set("index");
                variable.valueClass.set(Number.class);
                ((Element)object).addChild(variable);
                ((LoopNInOrder)object).index.set(variable);
            } else if (LoopN.class.isAssignableFrom(this.elementClass)) {
                object = (LoopN)element;
                Variable variable = new Variable();
                variable.name.set("index");
                variable.valueClass.set(Number.class);
                ((Element)object).addChild(variable);
                ((LoopN)object).index.set(variable);
            }
            return element;
        }
        catch (Exception exception) {
            AuthoringTool.getInstance().showErrorDialog("Error creating new element.", exception);
            return null;
        }
    }

    public ElementPrototype createCopy(StringObjectPair stringObjectPair) {
        return this.createCopy(new StringObjectPair[]{stringObjectPair});
    }

    public ElementPrototype createCopy(StringObjectPair[] stringObjectPairArray) {
        Vector<StringObjectPair> vector = new Vector<StringObjectPair>(Arrays.asList(this.knownPropertyValues));
        Vector<String> vector2 = new Vector<String>(Arrays.asList(this.desiredProperties));
        if (stringObjectPairArray != null) {
            for (StringObjectPair stringObjectPair : stringObjectPairArray) {
                if (vector2.contains(stringObjectPair.getString())) {
                    vector2.remove(stringObjectPair.getString());
                }
                boolean bl = false;
                ListIterator<StringObjectPair> listIterator = vector.listIterator();
                while (listIterator.hasNext()) {
                    StringObjectPair stringObjectPair2 = listIterator.next();
                    if (!stringObjectPair2.getString().equals(stringObjectPair.getString())) continue;
                    listIterator.set(stringObjectPair);
                    bl = true;
                }
                if (bl) continue;
                vector.add(stringObjectPair);
            }
        }
        return this.createInstance(this.elementClass, vector.toArray(new StringObjectPair[0]), vector2.toArray(new String[0]));
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public StringObjectPair[] getKnownPropertyValues() {
        return this.knownPropertyValues;
    }

    public String[] getDesiredProperties() {
        return this.desiredProperties;
    }

    protected ElementPrototype createInstance(Class clazz, StringObjectPair[] stringObjectPairArray, String[] stringArray) {
        return new ElementPrototype(clazz, stringObjectPairArray, stringArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + "[ ");
        stringBuffer.append("elementClass = " + this.elementClass.getName() + ", ");
        stringBuffer.append("knownPropertyValues = [ ");
        if (this.knownPropertyValues != null) {
            for (StringObjectPair object : this.knownPropertyValues) {
                stringBuffer.append("StringObjectPair( ");
                stringBuffer.append(object.getString() + ", ");
                stringBuffer.append(object.getObject().toString() + ", ");
                stringBuffer.append("), ");
            }
        } else {
            stringBuffer.append("<null>");
        }
        stringBuffer.append(" ], ");
        stringBuffer.append("desiredProperties = [ ");
        if (this.desiredProperties != null) {
            for (String string : this.desiredProperties) {
                stringBuffer.append((String)string + ", ");
            }
        } else {
            stringBuffer.append("<null>");
        }
        stringBuffer.append(" ], ]");
        return stringBuffer.toString();
    }
}

