/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.DeleteContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ElementPopupUtilities {
    protected static Class[] elementPopupRunnableParams = new Class[]{Element.class};

    public static void createAndShowElementPopupMenu(Element element, Vector vector, Component component, int n, int n2) {
        JPopupMenu jPopupMenu = ElementPopupUtilities.makeElementPopupMenu(element, vector);
        jPopupMenu.show(component, n, n2);
        PopupMenuUtilities.ensurePopupIsOnScreen(jPopupMenu);
    }

    @Deprecated
    public static JPopupMenu makeElementPopup(Element element, Vector vector) {
        return ElementPopupUtilities.makeElementPopupMenu(element, vector);
    }

    public static JPopupMenu makeElementPopupMenu(Element element, Vector vector) {
        if (element != null && vector != null) {
            Object[] objectArray = new Object[]{element};
            ElementPopupUtilities.substituteRunnables(objectArray, vector);
            return PopupMenuUtilities.makePopupMenu(vector);
        }
        return null;
    }

    public static void substituteRunnables(Object[] objectArray, Vector vector) {
        ListIterator<StringObjectPair> listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            StringObjectPair stringObjectPair;
            Object object;
            Object e = listIterator.next();
            if (e instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)e)) {
                try {
                    object = (ElementPopupRunnable)((Class)e).getConstructor(elementPopupRunnableParams).newInstance(objectArray);
                    stringObjectPair = new StringObjectPair(((ElementPopupRunnable)object).getDefaultLabel(), object);
                    listIterator.set(stringObjectPair);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", instantiationException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", invocationTargetException);
                }
                continue;
            }
            if (e instanceof ElementPopupRunnable) {
                object = (ElementPopupRunnable)e;
                stringObjectPair = new StringObjectPair(((ElementPopupRunnable)object).getDefaultLabel(), object);
                listIterator.set(stringObjectPair);
                continue;
            }
            if (!(e instanceof StringObjectPair)) continue;
            object = (StringObjectPair)e;
            if (((StringObjectPair)object).getObject() instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)((StringObjectPair)object).getObject())) {
                try {
                    stringObjectPair = new StringObjectPair(((StringObjectPair)object).getString(), ((Class)((StringObjectPair)object).getObject()).getConstructor(elementPopupRunnableParams).newInstance(objectArray));
                    listIterator.set(stringObjectPair);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", instantiationException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    AuthoringTool.getInstance().showErrorDialog("Error building popup.", invocationTargetException);
                }
                continue;
            }
            if (!(((StringObjectPair)object).getObject() instanceof Vector)) continue;
            ElementPopupUtilities.substituteRunnables(objectArray, (Vector)((StringObjectPair)object).getObject());
        }
    }

    public static Vector makeCoerceToStructure(final Element element) {
        if (element != null && element.isCoercionSupported()) {
            Vector<StringObjectPair> vector = new Vector<StringObjectPair>();
            Vector<StringObjectPair> vector2 = new Vector<StringObjectPair>();
            Class[] classArray = element.getSupportedCoercionClasses();
            if (classArray != null) {
                for (final Class clazz : classArray) {
                    String string = AuthoringToolResources.getReprForValue(clazz);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            AuthoringTool.getInstance().getUndoRedoStack().startCompound();
                            element.coerceTo(clazz);
                            AuthoringTool.getInstance().getUndoRedoStack().stopCompound();
                        }
                    };
                    vector2.add(new StringObjectPair(string, runnable));
                }
                if (vector2.size() > 0) {
                    vector.add(new StringObjectPair("change to", vector2));
                    return vector;
                }
                return null;
            }
        }
        return null;
    }

    public static Vector getDefaultStructure(Element element) {
        return ElementPopupUtilities.getDefaultStructure(element, true, null, null, null);
    }

    public static Vector getDefaultStructure(Element element, boolean bl, AuthoringTool authoringTool, JTree jTree, TreePath treePath) {
        if (element instanceof Response) {
            return ElementPopupUtilities.getDefaultResponseStructure((Response)element);
        }
        if (element instanceof Question) {
            return ElementPopupUtilities.getDefaultQuestionStructure((Question)element);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            return ElementPopupUtilities.getDefaultCharacterStructure(element, bl, authoringTool, jTree, treePath);
        }
        if (element instanceof World) {
            return ElementPopupUtilities.getDefaultWorldStructure((World)element);
        }
        return ElementPopupUtilities.getDefaultElementStructure(element, jTree, treePath);
    }

    public static Vector getDefaultCharacterStructure(Element element, boolean bl, AuthoringTool authoringTool, JTree jTree, TreePath treePath) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new StringObjectPair(AuthoringToolResources.getReprForValue(element), null));
        vector.add(new StringObjectPair("separator", JSeparator.class));
        if (bl) {
            vector.add(new StringObjectPair("methods", PopupMenuUtilities.makeDefaultOneShotStructure(element)));
        }
        if (jTree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jTree, treePath);
            vector.add(renameRunnable);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            vector.add(DeleteRunnable.class);
            vector.add(SaveCharacterRunnable.class);
        } else {
            vector.add(DeleteRunnable.class);
        }
        return vector;
    }

    public static Vector getDefaultWorldStructure(World world) {
        Vector vector = new Vector();
        return vector;
    }

    public static Vector getDefaultResponseStructure(Response response) {
        Vector<Class<ToggleCommentingRunnable>> vector = new Vector<Class<ToggleCommentingRunnable>>();
        vector.add(MakeCopyRunnable.class);
        vector.add(DeleteRunnable.class);
        vector.add(ToggleCommentingRunnable.class);
        Vector vector2 = ElementPopupUtilities.makeCoerceToStructure(response);
        if (vector2 != null) {
            vector.addAll(vector2);
        }
        return vector;
    }

    public static Vector getDefaultQuestionStructure(Question question) {
        Vector<Class> vector = new Vector<Class>();
        vector.add(MakeCopyRunnable.class);
        vector.add(DeleteRunnable.class);
        Vector vector2 = ElementPopupUtilities.makeCoerceToStructure(question);
        if (vector2 != null) {
            vector.addAll(vector2);
        }
        return vector;
    }

    public static Vector getDefaultElementStructure(Element element, JTree jTree, TreePath treePath) {
        Vector<Object> vector = new Vector<Object>();
        if (jTree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jTree, treePath);
            vector.add(renameRunnable);
        }
        vector.add(DeleteRunnable.class);
        return vector;
    }

    public static class SortGroupAlphabeticallyRunnable
    extends ElementPopupRunnable {
        protected Comparator sorter = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Element && object2 instanceof Element) {
                    String string = ((Element)object).name.getStringValue();
                    String string2 = ((Element)object2).name.getStringValue();
                    return string.compareTo(string2);
                }
                return 0;
            }
        };

        public SortGroupAlphabeticallyRunnable(Element element) {
            super(element);
        }

        public String getDefaultLabel() {
            return "sort alphabetically";
        }

        public void run() {
        }
    }

    public static class SetElementScopeRunnable
    extends ElementPopupRunnable {
        private AuthoringTool authoringTool;

        public SetElementScopeRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "switch to this element's scope";
        }

        public void run() {
            this.authoringTool.setElementScope(this.element);
        }
    }

    public static class ToggleCommentingRunnable
    extends ElementPopupRunnable {
        public ToggleCommentingRunnable(Element element) {
            super(element);
            if (!(element instanceof Code)) {
                throw new IllegalArgumentException("ToggleCommentRunnable only accepts Responses or User-Defined Questions; found: " + element);
            }
        }

        public String getDefaultLabel() {
            return "disable";
        }

        public void run() {
        }
    }

    public static class SaveCharacterRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public SaveCharacterRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "save object...";
        }

        public void run() {
        }
    }

    public static class MakeCopyRunnable
    extends ElementPopupRunnable {
        public MakeCopyRunnable(Element element) {
            super(element);
        }

        public String getDefaultLabel() {
            return "make copy";
        }

        public void run() {
            AuthoringTool.getInstance().getUndoRedoStack().startCompound();
            String string = AuthoringToolResources.getNameForNewChild(this.element.name.getStringValue(), this.element.getParent());
            if (this.element.getParent() instanceof CompositeResponse) {
                int n = ((CompositeResponse)this.element.getParent()).componentResponses.indexOf(this.element);
                Element element = this.element.HACK_createCopy(string, this.element.getParent(), n + 1, null, null);
                ((CompositeResponse)this.element.getParent()).componentResponses.add(n + 1, element);
            } else if (this.element.getParent() instanceof Composite) {
                int n = ((Composite)this.element.getParent()).components.indexOf(this.element);
                Element element = this.element.HACK_createCopy(string, this.element.getParent(), n + 1, null, null);
                ((Composite)this.element.getParent()).components.add(n + 1, element);
            } else {
                Element element = this.element.createCopyNamed(string);
                AuthoringToolResources.addElementToAppropriateProperty(element, element.getParent());
            }
            AuthoringTool.getInstance().getUndoRedoStack().stopCompound();
        }
    }

    public static class RenameRunnable
    extends ElementPopupRunnable {
        private JTree jtree;
        private TreePath treePath;

        public RenameRunnable(Element element, JTree jTree, TreePath treePath) {
            super(element);
            this.jtree = jTree;
            this.treePath = treePath;
        }

        public String getDefaultLabel() {
            return "rename";
        }

        public void run() {
            this.jtree.startEditingAtPath(this.treePath);
        }
    }

    public static class DeleteRunnable
    extends ElementPopupRunnable {
        public static final Criterion namedHeadCriterion = new Criterion(){

            public boolean accept(Object object) {
                return object instanceof Transformable && "head".equalsIgnoreCase(((Transformable)object).name.getStringValue());
            }
        };
        protected AuthoringTool authoringTool;

        public DeleteRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "delete";
        }

        public void run() {
            Object object;
            Object object2;
            PropertyReference[] propertyReferenceArray = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (propertyReferenceArray.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(propertyReferenceArray);
                propertyReferenceArray = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (propertyReferenceArray.length > 0) {
                object2 = propertyReferenceArray;
                int n = ((PropertyReference[])object2).length;
                for (int i = 0; i < n; ++i) {
                    PropertyReference propertyReference = object2[i];
                    Element element = propertyReference.getReference();
                    Property property = propertyReference.getProperty();
                    object = property.getOwner();
                    if (!propertyReference.getProperty().isAlsoKnownAs(Model.class, "geometry") || !(object instanceof Model)) continue;
                    element.setParent((Element)object);
                }
                propertyReferenceArray = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (propertyReferenceArray.length > 0) {
                DeleteContentPane.showDeleteDialog(this, this.authoringTool);
            } else {
                AuthoringTool.getInstance().getUndoRedoStack().startCompound();
                if (!(this.element instanceof Transformable) || this.element instanceof Model) {
                    // empty if block
                }
                if ((object2 = this.element.getParent()) != null) {
                    Property[] propertyArray;
                    for (Property property : propertyArray = ((Element)object2).getProperties()) {
                        if (property.get() == this.element) {
                            property.set(AuthoringToolResources.getDefaultValueForClass(property.getValueClass()));
                            continue;
                        }
                        if (!(property instanceof ObjectArrayProperty)) continue;
                        object = (ObjectArrayProperty)property;
                        int n = 0;
                        while (n < ((ObjectArrayProperty)object).size()) {
                            if (((ObjectArrayProperty)object).get(n) == this.element) {
                                ((ObjectArrayProperty)object).remove(n);
                                continue;
                            }
                            ++n;
                        }
                    }
                    ((Element)object2).removeChild(this.element);
                }
                AuthoringTool.getInstance().getUndoRedoStack().stopCompound();
            }
        }
    }

    public static abstract class ElementPopupRunnable
    implements Runnable {
        protected Element element;

        protected ElementPopupRunnable(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        public abstract String getDefaultLabel();
    }
}

