/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.QuestionEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.ResponseEditor;
import java.lang.reflect.Method;

public final class EditorUtilities {
    private static Class[] allEditors = new Class[]{ResponseEditor.class, QuestionEditor.class};

    public static Editor getEditorFromClass(Class clazz) {
        try {
            return (Editor)clazz.newInstance();
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Error creating new editor of type " + clazz, throwable);
            return null;
        }
    }

    public static Method getSetMethodFromClass(Class clazz) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] classArray;
            if (!method.getName().equals("setObject") || (classArray = method.getParameterTypes()).length != 1 || !Object.class.isAssignableFrom(classArray[0])) continue;
            return method;
        }
        return null;
    }

    public static Class getObjectParameter(Class clazz) {
        Method method = EditorUtilities.getSetMethodFromClass(clazz);
        if (method != null) {
            return method.getParameterTypes()[0];
        }
        return null;
    }

    public static Class getBestEditor(Class clazz) {
        Class clazz2 = null;
        int n = Integer.MAX_VALUE;
        for (Class clazz3 : allEditors) {
            int n2;
            Class<?>[] classArray;
            Method method = EditorUtilities.getSetMethodFromClass(clazz3);
            if (method == null || (classArray = method.getParameterTypes()).length != 1 || (n2 = EditorUtilities.getObjectClassDepth(classArray[0], clazz)) >= n || n2 < 0) continue;
            n = n2;
            clazz2 = clazz3;
        }
        return clazz2;
    }

    public static void editObject(Editor editor, Object object) {
        Method method = EditorUtilities.getSetMethodFromClass(editor.getClass());
        try {
            method.invoke((Object)editor, object);
        }
        catch (Exception exception) {
            AuthoringTool.getInstance().showErrorDialog("Error editing object: " + object, exception);
        }
    }

    private static int getObjectClassDepth(Class clazz, Class clazz2) {
        if (!clazz.isAssignableFrom(clazz2)) {
            return -1;
        }
        int n = 0;
        for (Class clazz3 = clazz2; clazz3 != clazz && clazz.isAssignableFrom(clazz3); clazz3 = clazz3.getSuperclass()) {
            ++n;
        }
        return n;
    }
}

