/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class EditObjectButton
extends JButton
implements GUIElement,
Releasable {
    protected AuthoringTool authoringTool;
    protected Object object;
    protected JComponent animationSource;

    public EditObjectButton() {
        this.setBackground(new Color(240, 240, 255));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.setText("edit");
        int n = 12;
        this.setFont(new Font("SansSerif", 1, n));
        this.setFocusPainted(false);
        this.setBorder(new BorderUIResource.CompoundBorderUIResource(new CustomButtonBorder(), new BasicBorders.MarginBorder()));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditObjectButton.this.authoringTool != null) {
                    if (EditObjectButton.this.object != null) {
                        if (EditObjectButton.this.animationSource != null) {
                            EditObjectButton.this.authoringTool.editObject(EditObjectButton.this.object, EditObjectButton.this.animationSource);
                        } else {
                            EditObjectButton.this.authoringTool.editObject(EditObjectButton.this.object);
                        }
                    } else {
                        AuthoringTool.getInstance().showErrorDialog("object unexpectedly null in EditObjectButton", null);
                    }
                } else {
                    AuthoringTool.getInstance().showErrorDialog("authoringTool unexpectedly null in EditObjectButton", null);
                }
            }
        });
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setAnimationSource(JComponent jComponent) {
        this.animationSource = jComponent;
    }

    public void goToSleep() {
    }

    public void wakeUp() {
    }

    public void clean() {
        this.object = null;
        this.animationSource = null;
    }

    public void die() {
        this.clean();
        this.authoringTool = null;
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    class CustomBevelBorder
    extends BevelBorder {
        public CustomBevelBorder(int n) {
            super(n);
        }

        public Color getHighlightInnerColor(Component component) {
            return component.getBackground();
        }

        public Color getShadowInnerColor(Component component) {
            return component.getBackground();
        }
    }

    class CustomButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Insets insets = new Insets(1, 3, 1, 3);
        protected Border line = BorderFactory.createLineBorder(Color.darkGray, 1);
        protected Border spacer = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        protected Border raisedBevel = new CustomBevelBorder(0);
        protected Border loweredBevel = new CustomBevelBorder(1);
        protected Border raisedBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(this.line, this.raisedBevel), this.spacer);
        protected Border loweredBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(this.line, this.loweredBevel), this.spacer);

        CustomButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    this.loweredBorder.paintBorder(jButton, graphics, n, n2, n3, n4);
                } else {
                    this.raisedBorder.paintBorder(jButton, graphics, n, n2, n3, n4);
                }
            } else {
                this.raisedBorder.paintBorder(jButton, graphics, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }
    }
}

