/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CommonMathQuestionsTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.PropertyReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.QuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.DragWindow;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIEffects;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.awt.AWTUtilities;
import edu.cmu.cs.stage3.awt.SemitransparentWindow;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DnDGroupingPanel
extends GroupingPanel {
    protected Transferable transferable;
    protected DnDGrip grip = new DnDGrip();
    protected DragSource dragSource = new DragSource();
    protected Point hotSpot = new Point(0, 0);
    protected DragSourceListener dndManagerListener = DnDManager.getInternalListener();
    protected DragWindow dragWindow;
    protected SemitransparentWindow dragWindow2;
    protected Point dragOffset;
    protected int arcWidth = 12;
    protected int arcHeight = 10;
    protected GroupingPanelDragGestureListener dragGestureListener = new GroupingPanelDragGestureListener();
    protected LinkedList dragGestureRecognizers = new LinkedList();
    protected boolean dragEnabled = true;
    protected boolean drawFaded = false;
    protected Composite defaultComposite = AlphaComposite.SrcOver;
    protected AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    protected boolean isSystemDefined = false;

    public DnDGroupingPanel() {
        this.setLayout(new BorderLayout(2, 2));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.add((Component)this.grip, "West");
        this.addDragSourceComponent(this.grip);
        this.addDragSourceComponent(this);
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    public void setTransferable(Transferable transferable) {
        this.transferable = transferable;
        if (transferable != null) {
            this.isSystemDefined = AuthoringToolResources.safeIsDataFlavorSupported(transferable, PropertyReferenceTransferable.propertyReferenceFlavor) ? true : (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ResponsePrototypeReferenceTransferable.responsePrototypeReferenceFlavor) && !AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor) ? true : (AuthoringToolResources.safeIsDataFlavorSupported(transferable, QuestionPrototypeReferenceTransferable.questionPrototypeReferenceFlavor) && !AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) ? true : AuthoringToolResources.safeIsDataFlavorSupported(transferable, CommonMathQuestionsTransferable.commonMathQuestionsFlavor)));
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public void addDragSourceComponent(Component component) {
        for (DragGestureRecognizer dragGestureRecognizer : this.dragGestureRecognizers) {
            if (dragGestureRecognizer.getComponent() != component) continue;
            return;
        }
        if (this.dragSource != null) {
            this.dragGestureRecognizers.add(this.dragSource.createDefaultDragGestureRecognizer(component, 0x40000003, this.dragGestureListener));
        } else {
            AuthoringTool.getInstance().showErrorDialog("dragSource is null", null);
        }
    }

    public void removeDragSourceComponent(Component component) {
        ListIterator listIterator = this.dragGestureRecognizers.listIterator();
        while (listIterator.hasNext()) {
            DragGestureRecognizer dragGestureRecognizer = (DragGestureRecognizer)listIterator.next();
            if (dragGestureRecognizer.getComponent() != component) continue;
            dragGestureRecognizer.removeDragGestureListener(this.dragGestureListener);
            dragGestureRecognizer.setComponent(null);
            listIterator.remove();
            break;
        }
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public void reset() {
        this.add((Component)this.grip, "West");
        this.addDragSourceComponent(this.grip);
        this.addDragSourceComponent(this);
    }

    public void release() {
        super.release();
        ListIterator listIterator = this.dragGestureRecognizers.listIterator();
        while (listIterator.hasNext()) {
            DragGestureRecognizer dragGestureRecognizer = (DragGestureRecognizer)listIterator.next();
            if (this.dragGestureListener != null) {
                dragGestureRecognizer.removeDragGestureListener(this.dragGestureListener);
                listIterator.remove();
            }
            dragGestureRecognizer.setComponent(null);
        }
    }

    public Image getImage() {
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        return bufferedImage;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Object object = null;
        if (graphics instanceof Graphics2D) {
            object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, rectangle.width, rectangle.height, this.arcWidth, this.arcHeight);
        graphics.setColor(Color.lightGray);
        graphics.drawRoundRect(0, 0, rectangle.width - 1, rectangle.height - 1, this.arcWidth, this.arcHeight);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, object));
        }
    }

    public void paintForeground(Graphics graphics) {
        super.paintForeground(graphics);
        if (this.isSystemDefined) {
            // empty if block
        }
    }

    public class DnDGrip
    extends JComponent {
        protected Color highlightColor = MetalLookAndFeel.getControlHighlight();
        protected Color shadowColor = MetalLookAndFeel.getControlDarkShadow();

        public DnDGrip() {
            this.setMinimumSize(new Dimension(6, 0));
            this.setMaximumSize(new Dimension(6, Integer.MAX_VALUE));
            this.setPreferredSize(new Dimension(6, 0));
        }

        protected void printComponent(Graphics graphics) {
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Dimension dimension = this.getSize();
            graphics.setColor(this.highlightColor);
            for (n2 = 0; n2 < dimension.width; n2 += 4) {
                for (n = 0; n < dimension.height; n += 4) {
                    graphics.drawLine(n2, n, n2, n);
                    graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
                }
            }
            graphics.setColor(this.shadowColor);
            for (n2 = 0; n2 < dimension.width; n2 += 4) {
                for (n = 0; n < dimension.height; n += 4) {
                    graphics.drawLine(n2 + 1, n + 1, n2 + 1, n + 1);
                    graphics.drawLine(n2 + 3, n + 3, n2 + 3, n + 3);
                }
            }
        }
    }

    public class GroupingPanelDragGestureListener
    implements DragGestureListener {
        protected DragSourceListener dragSourceListener = new DragSourceListener();

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (DnDGroupingPanel.this.transferable != null) {
                DnDManager.fireDragGestureRecognized(dragGestureEvent);
                try {
                    if (DnDGroupingPanel.this.dragEnabled) {
                        dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, DnDGroupingPanel.this.transferable, DnDManager.getInternalListener());
                        DnDManager.fireDragStarted(DnDGroupingPanel.this.transferable, DnDGroupingPanel.this);
                        DnDGroupingPanel.this.drawFaded = true;
                        DnDGroupingPanel.this.repaint();
                    }
                }
                catch (Throwable throwable) {
                    AuthoringTool.getInstance().showErrorDialog("Error initiating drag of tile.", throwable);
                }
            }
        }

        private boolean updateImages(boolean bl) {
            Image image = DnDGroupingPanel.this.getImage();
            boolean bl2 = false;
            if (AuthoringToolResources.safeIsDataFlavorSupported(DnDGroupingPanel.this.transferable, ElementReferenceTransferable.responseReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(DnDGroupingPanel.this.transferable, AuthoringToolResources.getReferenceFlavorForClass(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class))) {
                int n = image.getWidth(GUIEffects.sizeObserver);
                int n2 = image.getHeight(GUIEffects.sizeObserver);
                if (n > 64 || n2 > 64) {
                    double d = 1.0;
                    Rectangle rectangle = new Rectangle(0, 0, 64, 64);
                    if (n > 128 && n2 > 128) {
                        d = 0.5;
                    } else if (n2 < 32) {
                        rectangle = new Rectangle(0, 0, 128, n2);
                    } else if (n > 128 || n2 > 128) {
                        d = Math.min(1.0, 64.0 / (double)Math.min(n, n2));
                    } else {
                        rectangle = new Rectangle(0, 0, n, n2);
                    }
                    image = GUIEffects.getImageScaledAndCropped(image, d, rectangle);
                    bl2 = true;
                }
            }
            image = bl ? GUIEffects.getImageWithColoredBorder(image, AuthoringToolResources.getColor("dndHighlight2")) : GUIEffects.getImageWithColoredBorder(image, AuthoringToolResources.getColor("dndHighlight3"));
            if (DnDGroupingPanel.this.dragWindow != null) {
                DnDGroupingPanel.this.dragWindow.setImage(image);
            }
            return bl2;
        }

        protected class DragSourceListener
        implements DnDManagerListener {
            protected DragSourceListener() {
            }

            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
                GroupingPanelDragGestureListener.this.updateImages(true);
            }

            public void dragExit(DragSourceEvent dragSourceEvent) {
                GroupingPanelDragGestureListener.this.updateImages(false);
            }

            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            }

            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            }

            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            }

            public void dragStarted() {
            }
        }

        protected class DragListener
        extends MouseAdapter
        implements MouseMotionListener {
            protected DragListener() {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DnDGroupingPanel.this.drawFaded = false;
                DnDGroupingPanel.this.repaint();
                DnDGroupingPanel.this.dragWindow.setVisible(false);
                AWTUtilities.removeMouseListener(this);
                AWTUtilities.removeMouseMotionListener(this);
                DnDManager.removeListener(GroupingPanelDragGestureListener.this.dragSourceListener);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                point.x -= DnDGroupingPanel.this.dragOffset.x;
                point.y -= DnDGroupingPanel.this.dragOffset.y;
                if (DnDGroupingPanel.this.dragWindow2 != null) {
                    DnDGroupingPanel.this.dragWindow2.show();
                    DnDGroupingPanel.this.dragWindow2.setLocationOnScreen(point.x, point.y);
                    AWTUtilities.pumpMessageQueue();
                } else if (DnDGroupingPanel.this.dragWindow != null) {
                    DnDGroupingPanel.this.dragWindow.setVisible(true);
                    DnDGroupingPanel.this.dragWindow.setLocation(point);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        }
    }
}

