/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AliceWorldFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceTabbedPaneUI;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartUpContentPane
extends ContentPane {
    public static final int DO_NOT_CHANGE_TAB_ID = -1;
    public static final int OPEN_TAB_ID = 1;
    private static final String OPEN_STRING = "Open a world";
    private final int WIDTH = 480;
    private final int HEIGHT = 470;
    private static final Color SELECTED_COLOR = new Color(10, 10, 100);
    private static final Color SELECTED_TEXT_COLOR = new Color(255, 255, 255);
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0);
    private AliceWorldFilter aliceFilter;
    private javax.swing.filechooser.FileFilter worldFilter;
    private StartUpIcon currentlySelected;
    private ImageIcon headerImage;
    private ImageIcon basicIcon;
    private ImageIcon directoryIcon;
    private ImageIcon upDirectoryIcon;
    private JTabbedPane mainTabPane = new JTabbedPane();
    private JButton openButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton refreshButton = new JButton();
    private JCheckBox stopShowingCheckBox = new JCheckBox();
    private JLabel headerLabel = new JLabel();
    private JFileChooser fileChooser = new JFileChooser(){

        public void setSelectedFile(File file) {
            super.setSelectedFile(file);
            StartUpContentPane.this.handleFileSelectionChange(file);
        }
    };
    private JPanel buttonPanel = new JPanel();
    protected int currentTab = 1;

    public StartUpContentPane(AuthoringTool authoringTool) {
        this.headerImage = new ImageIcon(JAlice.class.getResource("images/startUpDialog/StartupScreen.png"));
        this.basicIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/aliceIcon.png"));
        this.directoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/directoryIcon.png"));
        this.upDirectoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/upDirectoryIcon.png"));
        this.worldFilter = authoringTool.getWorldFileFilter();
        this.aliceFilter = new AliceWorldFilter(this.worldFilter);
        this.jbInit();
        this.guiInit();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }
        });
    }

    public void preDialogShow(JDialog jDialog) {
        super.preDialogShow(jDialog);
        this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
    }

    private void handleFileSelectionChange(File file) {
        this.openButton.setEnabled(file != null && file.exists() && !file.isDirectory());
    }

    public String getTitle() {
        return "Welcome to Alice!";
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.openButton.addActionListener(actionListener);
    }

    public void removeOKActionListener(ActionListener actionListener) {
        this.openButton.removeActionListener(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        this.cancelButton.removeActionListener(actionListener);
    }

    public boolean isSaveNeeded() {
        if (this.currentlySelected != null) {
            return this.currentlySelected.needToSave;
        }
        return true;
    }

    public File getFile() {
        if (this.getTabID() == 1) {
            return this.fileChooser.getSelectedFile();
        }
        if (this.currentlySelected != null) {
            return new File(this.currentlySelected.file);
        }
        return null;
    }

    private int getIDForTab(Component component) {
        if (component == this.fileChooser) {
            return 1;
        }
        return 0;
    }

    private Component getTabForID(int n) {
        return this.fileChooser;
    }

    private int getTabID() {
        return this.getIDForTab(this.mainTabPane.getSelectedComponent());
    }

    public void setTabID(int n) {
        if (n == 1) {
            this.fileChooser.rescanCurrentDirectory();
        }
        if (n != -1) {
            this.currentTab = n;
            this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
        }
    }

    private String makeNameFromFilename(String string) {
        String string2 = string.substring(0, string.length() - 4);
        int n = string2.lastIndexOf(File.separator);
        if (n >= 0 && n < string2.length()) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    private String makeDirectoryNameFromFilename(String string) {
        int n;
        String string2 = new String(string);
        if (string.endsWith(File.separator)) {
            string = string.substring(string.length());
        }
        if ((n = string.lastIndexOf(File.separator)) >= 0 && n < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private Vector buildVectorFromDirectory(File file, FileFilter fileFilter) {
        Vector<StringObjectPair> vector = null;
        if (file != null && file.isDirectory()) {
            File[] fileArray;
            vector = new Vector<StringObjectPair>();
            for (File file2 : fileArray = file.listFiles(fileFilter)) {
                String string = "";
                string = file2.isDirectory() ? this.makeDirectoryNameFromFilename(file2.getName()) : this.makeNameFromFilename(file2.getName());
                StringObjectPair stringObjectPair = new StringObjectPair(string, file2.getAbsolutePath());
                vector.add(stringObjectPair);
            }
        }
        return vector;
    }

    private ImageIcon getIconFromFile(File file) {
        String string = file.getAbsolutePath();
        ImageIcon imageIcon = null;
        try {
            Node node;
            Object object;
            DocumentBuilder documentBuilder;
            Object object2;
            NodeList nodeList;
            if (string.endsWith(".stl") && (nodeList = (object2 = (documentBuilder = ((DocumentBuilderFactory)(object = DocumentBuilderFactory.newInstance())).newDocumentBuilder()).parse(file)).getElementsByTagName("stencilStack")) != null && nodeList.getLength() > 0 && (node = nodeList.item(0)) instanceof Element) {
                String string2 = ((Element)node).getAttribute("world");
                file = new File(string2);
            }
            if ((object2 = ((ZipFile)(object = new ZipFile(file))).getEntry("thumbnail.png")) != null) {
                ((ZipFile)object).getInputStream((ZipEntry)object2);
            }
            ((ZipFile)object).close();
        }
        catch (Exception exception) {
            return null;
        }
        return imageIcon;
    }

    protected Component getTopContainer(Component component) {
        return null;
    }

    protected String getBaseDirString(Component component) {
        return "";
    }

    private int buildPanel(JPanel jPanel, Vector vector, boolean bl, File file, int n) {
        Serializable serializable;
        int n2 = 0;
        if (file != null || vector != null) {
            jPanel.removeAll();
        }
        if (file != null) {
            String string = "Back";
            serializable = new StartUpIcon(string, this.upDirectoryIcon, file.getAbsolutePath(), false, 3, this.getTopContainer(jPanel));
            jPanel.add((Component)serializable);
            ++n2;
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                serializable = (StringObjectPair)vector.get(i);
                String string = ((StringObjectPair)serializable).getString();
                String string2 = (String)((StringObjectPair)serializable).getObject();
                File file2 = new File(string2);
                ImageIcon imageIcon = this.basicIcon;
                if (!file2.exists() || !file2.canRead()) continue;
                string2 = file2.getAbsolutePath();
                if (file2.isDirectory()) {
                    StartUpIcon startUpIcon = new StartUpIcon(string, this.directoryIcon, string2, false, 3, this.getTopContainer(jPanel));
                    jPanel.add(startUpIcon);
                    ++n2;
                    continue;
                }
                boolean bl2 = true;
                if (file2.exists() && file2.canRead()) {
                    imageIcon = this.getIconFromFile(file2);
                    if (imageIcon == null) {
                        imageIcon = this.basicIcon;
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                StartUpIcon startUpIcon = new StartUpIcon(string, imageIcon, string2, bl, n, this.getTopContainer(jPanel));
                jPanel.add(startUpIcon);
                ++n2;
            }
        }
        jPanel.revalidate();
        return n2;
    }

    private void initializeFileChooser() {
        this.mainTabPane.remove(this.fileChooser);
        File file = this.fileChooser.getCurrentDirectory();
        this.fileChooser = new JFileChooser(){

            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
                StartUpContentPane.this.handleFileSelectionChange(file);
            }
        };
        for (int i = 0; i < this.fileChooser.getComponentCount(); ++i) {
            this.setButtonBackgroundColors(this.fileChooser.getComponent(i), this.fileChooser.getBackground());
        }
        if (file.exists()) {
            this.fileChooser.setCurrentDirectory(file);
        }
        this.fileChooser.setFileFilter(this.worldFilter);
        this.fileChooser.setBackground(Color.white);
        this.fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartUpContentPane.this.fileChooser_actionPerformed(actionEvent);
            }
        });
        this.fileChooser.setFileSelectionMode(0);
        this.mainTabPane.add((Component)this.fileChooser, OPEN_STRING);
    }

    private void guiInit() {
        this.setPreferredSize(new Dimension(480, 470));
        this.headerLabel.setIcon(this.headerImage);
        this.mainTabPane.setUI(new AliceTabbedPaneUI());
        this.mainTabPane.setOpaque(false);
        this.initializeFileChooser();
    }

    private void setButtonBackgroundColors(Component component, Color color) {
        if (!(component instanceof Button)) {
            component.setBackground(color);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.setButtonBackgroundColors(container.getComponent(i), color);
            }
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        Box.createGlue();
        Box.createGlue();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.mainTabPane.setMinimumSize(new Dimension(480, 310));
        this.mainTabPane.setPreferredSize(new Dimension(480, 310));
        this.mainTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                StartUpContentPane.this.mainTabPane_stateChanged(changeEvent);
            }
        });
        this.buttonPanel.setOpaque(false);
        this.openButton.setMaximumSize(new Dimension(95, 27));
        this.openButton.setMinimumSize(new Dimension(95, 27));
        this.openButton.setPreferredSize(new Dimension(95, 27));
        this.openButton.setText("Open");
        this.cancelButton.setMaximumSize(new Dimension(95, 27));
        this.cancelButton.setMinimumSize(new Dimension(95, 27));
        this.cancelButton.setPreferredSize(new Dimension(95, 27));
        this.cancelButton.setText("Cancel");
        this.refreshButton.setMaximumSize(new Dimension(90, 22));
        this.refreshButton.setMinimumSize(new Dimension(90, 22));
        this.refreshButton.setPreferredSize(new Dimension(90, 22));
        this.refreshButton.setOpaque(false);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartUpContentPane.this.refreshButton_actionPerformed(actionEvent);
            }
        });
        this.stopShowingCheckBox.setOpaque(false);
        this.stopShowingCheckBox.setText("Show this dialog at start");
        this.stopShowingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.openButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mainTabPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainTabPane.add((Component)this.fileChooser, OPEN_STRING);
        this.add((Component)this.stopShowingCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setFileChooserButtons() {
        this.add((Component)this.refreshButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 2, 1, 1), 0, 0));
        this.remove(this.buttonPanel);
    }

    private void setRegularButtons() {
        this.remove(this.refreshButton);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void mainTabPane_stateChanged(ChangeEvent changeEvent) {
        if (this.currentlySelected != null) {
            this.currentlySelected.deSelect();
            this.currentlySelected = null;
        }
        if (this.mainTabPane.getSelectedComponent() == this.fileChooser) {
            this.setFileChooserButtons();
            this.handleFileSelectionChange(this.fileChooser.getSelectedFile());
        } else {
            this.setRegularButtons();
            this.openButton.setEnabled(false);
        }
    }

    private void fileChooser_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ApproveSelection")) {
            this.openButton.setEnabled(true);
            this.openButton.doClick();
        } else if (string.equals("CancelSelection")) {
            this.cancelButton.doClick();
        }
    }

    private void refreshButton_actionPerformed(ActionEvent actionEvent) {
        this.initializeFileChooser();
        this.setTabID(1);
    }

    protected class StartUpIcon
    extends JLabel
    implements MouseListener {
        protected static final int STANDARD = 1;
        protected static final int DIRECTORY = 3;
        protected boolean isSelected;
        protected String file;
        protected boolean needToSave;
        protected int type;
        protected Component owner;

        public StartUpIcon(String string, ImageIcon imageIcon, String string2, boolean bl, int n, Component component) {
            super(string, imageIcon, 0);
            this.isSelected = false;
            this.needToSave = false;
            this.file = string2;
            this.needToSave = bl;
            this.type = n;
            this.owner = component;
            this.setBackground(BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            Dimension dimension = new Dimension(imageIcon.getIconWidth() + 4, imageIcon.getIconHeight() + 24);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            if (n == 3) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.setOpaque(false);
            this.addMouseListener(this);
        }

        protected JPanel getContainer(Component component) {
            return null;
        }

        protected JLabel getJLabel(Component component) {
            return null;
        }

        protected String getRootPath(Component component) {
            return null;
        }

        protected String getRelativePath(String string, String string2) {
            return string.substring(string2.length());
        }

        protected void changeDirectory(String string) {
            File file = new File(string);
            File file2 = file.getParentFile();
            JLabel jLabel = this.getJLabel(this.owner);
            String string2 = StartUpContentPane.this.getBaseDirString(this.owner);
            if (this.owner instanceof JScrollPane) {
                ((JScrollPane)this.owner).getVerticalScrollBar().setValue(0);
            }
            StartUpContentPane.this.buildPanel(this.getContainer(this.owner), StartUpContentPane.this.buildVectorFromDirectory(file, StartUpContentPane.this.aliceFilter), this.needToSave, file2, 1);
            jLabel.setText(string2 + this.getRelativePath(file.getAbsolutePath(), this.getRootPath(this.owner)));
        }

        public void deSelect() {
            if (this.isSelected) {
                StartUpContentPane.this.currentlySelected = null;
                this.isSelected = false;
                this.setBackground(BACKGROUND_COLOR);
                this.setOpaque(false);
                this.repaint();
                this.setForeground((Color)UIManager.get("Label.foreground"));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.type == 3) {
                this.changeDirectory(this.file);
            } else {
                if (!this.isSelected) {
                    this.isSelected = true;
                    if (StartUpContentPane.this.currentlySelected != null) {
                        StartUpContentPane.this.currentlySelected.deSelect();
                    }
                    if (!StartUpContentPane.this.openButton.isEnabled()) {
                        StartUpContentPane.this.openButton.setEnabled(true);
                    }
                    this.setBackground(SELECTED_COLOR);
                    this.setOpaque(true);
                    this.setForeground(SELECTED_TEXT_COLOR);
                    StartUpContentPane.this.currentlySelected = this;
                    StartUpContentPane.this.currentlySelected.repaint();
                }
                if (mouseEvent.getClickCount() == 2) {
                    StartUpContentPane.this.openButton.doClick();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }
}

