/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OutputComponent
extends JPanel {
    protected JScrollPane scrollPane;
    protected StyledStreamTextPane textPane;
    protected StyleStream stdOutStream;
    protected StyleStream stdErrStream;

    public OutputComponent() {
        this.guiInit();
        this.miscInit();
    }

    private void guiInit() {
        this.setLayout(new BorderLayout());
        this.textPane = new StyledStreamTextPane();
        this.scrollPane = new JScrollPane(this.textPane, 22, 30);
        this.add((Component)this.scrollPane, "Center");
    }

    private void miscInit() {
        this.stdOutStream = this.textPane.getNewStyleStream(this.textPane.stdOutStyle);
        this.stdErrStream = this.textPane.getNewStyleStream(this.textPane.stdErrStyle);
        this.scrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){
            private int max = 0;
            private JScrollBar scrollBar;
            {
                this.scrollBar = OutputComponent.this.scrollPane.getVerticalScrollBar();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                final int n = ((BoundedRangeModel)changeEvent.getSource()).getMaximum();
                if (n != this.max) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            scrollBar.setValue(n);
                            max = n;
                        }
                    });
                }
            }
        });
    }

    public StyledStreamTextPane getTextPane() {
        return this.textPane;
    }

    public StyleStream getStdOutStream() {
        return this.stdOutStream;
    }

    public StyleStream getStdErrStream() {
        return this.stdErrStream;
    }

    public void clear() {
        this.textPane.setText("");
    }
}

