/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.datatransfer;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class ElementReferenceTransferable
implements Transferable {
    public static final DataFlavor elementReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Element.class);
    public static final DataFlavor expressionReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Expression.class);
    public static final DataFlavor questionReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Question.class);
    public static final DataFlavor responseReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Response.class);
    public static final DataFlavor callToUserDefinedQuestionReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class);
    public static final DataFlavor callToUserDefinedResponseReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class);
    public static final DataFlavor behaviorReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Behavior.class);
    public static final DataFlavor transformableReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Transformable.class);
    public static final DataFlavor variableReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Variable.class);
    public static final DataFlavor worldReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(World.class);
    protected DataFlavor[] flavors;
    protected Element element;

    public ElementReferenceTransferable(Element element) {
        this.element = element;
        HashSet hashSet = new HashSet();
        if (element != null) {
            AuthoringToolResources.findAssignables(element.getClass(), hashSet, true);
        } else {
            AuthoringToolResources.findAssignables(Element.class, hashSet, true);
        }
        this.flavors = new DataFlavor[hashSet.size() + 1];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.flavors[n++] = AuthoringToolResources.getReferenceFlavorForClass((Class)iterator.next());
        }
        this.flavors[n++] = DataFlavor.stringFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.element.toString();
        }
        if (dataFlavor.getRepresentationClass().isAssignableFrom(this.element.getClass())) {
            return this.element;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public ElementReferenceTransferable createCopy() {
        if (this.element != null) {
            Element element = this.element.createCopyNamed(this.element.name.getStringValue());
            return new ElementReferenceTransferable(element);
        }
        return null;
    }
}

