/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.Actions;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.DragFromComponent;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.StatusBar;
import edu.cmu.cs.stage3.alice.authoringtool.TabbedEditorComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.InvisibleSplitPaneUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.TrashComponent;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class JAliceFrame
extends JFrame {
    protected AuthoringTool authoringTool;
    DragFromComponent dragFromComponent;
    TabbedEditorComponent tabbedEditorComponent;
    TrashComponent trashComponent;
    protected ComponentImageFactory componentImageFactory = new ComponentImageFactory();
    StatusBar statusBar;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem newWorldItem = new JMenuItem();
    JMenuItem openWorldItem = new JMenuItem();
    JMenuItem saveWorldItem = new JMenuItem();
    JMenuItem saveWorldAsItem = new JMenuItem();
    JMenuItem exitItem = new JMenuItem();
    JMenu helpMenu = new JMenu();
    JMenu exerciseMenu = new JMenu();
    JMenuItem aboutItem = new JMenuItem();
    JMenuItem viewXmlItem = new JMenuItem();
    JMenuItem viewHtmlItem = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel toolBarPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel buttonPanel = new JPanel();
    JButton playButton = new JButton();
    JPanel trashPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JButton undoButton = new JButton();
    JButton redoButton = new JButton();
    JPanel authoringPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JSplitPane leftRightSplitPane = new JSplitPane();
    JPanel leftPanel = new JPanel();
    JPanel rightPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel dragFromPanel = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel editorPanel = new JPanel();
    BorderLayout borderLayout10 = new BorderLayout();
    BorderLayout borderLayout11 = new BorderLayout();
    Component glue;
    Border border2;
    Border border3;

    public JAliceFrame(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.jbInit();
        this.guiInit();
        this.setIconImage(AuthoringToolResources.getAliceSystemIconImage());
    }

    public void HACK_goToRedAlert() {
        this.getContentPane().setBackground(new Color(192, 0, 0));
    }

    public void HACK_standDownFromRedAlert() {
    }

    private void guiInit() {
        this.setDefaultCloseOperation(0);
        this.dragFromComponent = new DragFromComponent(this.authoringTool);
        this.tabbedEditorComponent = new TabbedEditorComponent(this.authoringTool);
        this.trashComponent = new TrashComponent(this.authoringTool);
        this.statusBar = new StatusBar(this.authoringTool);
        this.dragFromPanel.add((Component)this.dragFromComponent, "Center");
        this.editorPanel.add((Component)this.tabbedEditorComponent, "Center");
        this.trashPanel.add((Component)this.trashComponent, "South");
        int n = 800;
        int n2 = 700;
        this.setBounds(0, 0, n, n2);
        this.leftRightSplitPane.setDividerLocation(230);
        this.leftRightSplitPane.setResizeWeight(0.0);
        this.leftRightSplitPane.setUI(new InvisibleSplitPaneUI());
        this.leftRightSplitPane.setBorder(null);
        this.dragFromPanel.setMinimumSize(new Dimension(0, 0));
        this.editorPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.authoringTool.addElementSelectionListener(this.dragFromComponent);
        this.getContentPane().add((Component)this.componentImageFactory, "West");
    }

    public void actionInit(Actions actions) {
        this.newWorldItem.setAction(actions.newWorldAction);
        this.openWorldItem.setAction(actions.openWorldAction);
        this.saveWorldItem.setAction(actions.saveWorldAction);
        this.saveWorldAsItem.setAction(actions.saveWorldAsAction);
        this.exitItem.setAction(actions.quitAction);
        this.aboutItem.setAction(actions.aboutAction);
        this.viewXmlItem.setAction(actions.viewXmlAction);
        this.viewHtmlItem.setAction(actions.viewHtmlAction);
        this.playButton.setAction(actions.playAction);
        this.undoButton.setAction(actions.undoAction);
        this.redoButton.setAction(actions.redoAction);
    }

    public void setWorld(World world) {
        this.tabbedEditorComponent.setWorld(world);
    }

    public void setGuiMode(int n) {
        int n2 = this.leftRightSplitPane.getDividerLocation();
        this.rightPanel.removeAll();
        this.leftRightSplitPane.setDividerLocation(n2);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        this.mainPanel.registerKeyboardAction(actionListener, string, keyStroke, n);
    }

    public TabbedEditorComponent getTabbedEditorComponent() {
        return this.tabbedEditorComponent;
    }

    private void jbInit() {
        this.glue = Box.createGlue();
        this.border2 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.border3 = BorderFactory.createEmptyBorder(2, 10, 10, 10);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText(I18n.getString("mainMenu_File"));
        this.newWorldItem.setText(I18n.getString("mainMenu_New"));
        this.openWorldItem.setText(I18n.getString("mainMenu_Open"));
        this.saveWorldItem.setText(I18n.getString("mainMenu_Save"));
        this.saveWorldAsItem.setText(I18n.getString("mainMenu_SaveAs"));
        this.exitItem.setText(I18n.getString("mainMenu_Exit"));
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText(I18n.getString("mainMenu_Help"));
        this.exerciseMenu.setText(I18n.getString("mainMenu_Exercise"));
        this.aboutItem.setText(I18n.getString("mainMenu_About"));
        this.viewXmlItem.setText(I18n.getString("mainMenu_ViewEncode"));
        this.viewHtmlItem.setText(I18n.getString("mainMenu_ViewHtml"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.toolBarPanel.setLayout(this.gridBagLayout1);
        this.playButton.setText(I18n.getString("mainMenu_Play"));
        this.trashPanel.setAlignmentY(0.0f);
        this.trashPanel.setOpaque(false);
        this.trashPanel.setLayout(this.borderLayout11);
        this.mainPanel.setLayout(this.borderLayout2);
        this.buttonPanel.setLayout(this.gridBagLayout4);
        this.undoButton.setText(I18n.getString("mainMenu_Undo"));
        this.redoButton.setText(I18n.getString("mainMenu_Redo"));
        this.authoringPanel.setLayout(this.borderLayout3);
        this.leftPanel.setLayout(this.borderLayout5);
        this.rightPanel.setLayout(this.borderLayout6);
        this.dragFromPanel.setLayout(this.borderLayout8);
        this.editorPanel.setLayout(this.borderLayout10);
        this.leftRightSplitPane.setDoubleBuffered(true);
        this.leftRightSplitPane.setOpaque(false);
        this.setJMenuBar(this.menuBar);
        this.dragFromPanel.setOpaque(false);
        this.editorPanel.setOpaque(false);
        this.toolBarPanel.setBorder(this.border3);
        this.toolBarPanel.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        this.mainPanel.setBorder(this.border2);
        this.mainPanel.setOpaque(false);
        this.authoringPanel.setOpaque(false);
        this.leftPanel.setOpaque(false);
        this.rightPanel.setOpaque(false);
        if (!JAlice.getInstance().isApplet()) {
            this.menuBar.add(this.fileMenu);
        }
        this.menuBar.add(this.exerciseMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.add(this.newWorldItem);
        this.fileMenu.add(this.openWorldItem);
        this.fileMenu.add(this.saveWorldItem);
        this.fileMenu.add(this.saveWorldAsItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.helpMenu.add(this.aboutItem);
        this.exerciseMenu.add(this.viewXmlItem);
        this.exerciseMenu.add(this.viewHtmlItem);
        this.getContentPane().add((Component)this.toolBarPanel, "North");
        this.toolBarPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.playButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.undoButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 16, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.redoButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.toolBarPanel.add((Component)this.trashPanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 16, 3, new Insets(0, 14, 0, 0), 0, 0));
        this.toolBarPanel.add(this.glue, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.authoringPanel, "Center");
        this.authoringPanel.add((Component)this.leftRightSplitPane, "Center");
        this.leftRightSplitPane.add((Component)this.dragFromPanel, "left");
        this.leftRightSplitPane.add((Component)this.editorPanel, "right");
    }

    protected class ComponentImageFactory
    extends JPanel {
        public ComponentImageFactory() {
            this.setPreferredSize(new Dimension(0, 0));
        }

        public BufferedImage manufactureImage(JComponent jComponent) {
            boolean bl = jComponent.isShowing();
            Container container = jComponent.getParent();
            if (!bl) {
                if (container != null) {
                    container.remove(jComponent);
                }
                this.add(jComponent);
            }
            this.doLayout();
            Dimension dimension = jComponent.getPreferredSize();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            jComponent.paintAll(graphics2D);
            if (!bl) {
                this.remove(jComponent);
                if (container != null) {
                    container.add(jComponent);
                }
            }
            return bufferedImage;
        }
    }
}

