/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.Actions;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.DragFromComponent;
import edu.cmu.cs.stage3.alice.authoringtool.EditorManager;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AboutContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.ErrorContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.LoadElementProgressPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewVariableContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.RenderContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.SaveErrorContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.SimulationExceptionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.StartUpContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.StoreElementProgressPane;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.ElementSelectionListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.UndoRedoListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultScheduler;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExtensionFileFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotScheduler;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotSimpleBehavior;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.RectangleAnimator;
import edu.cmu.cs.stage3.alice.authoringtool.util.TrashComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.AppletWorldLoader;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.SimulationException;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.WorldStartBehavior;
import edu.cmu.cs.stage3.alice.core.clock.DefaultClock;
import edu.cmu.cs.stage3.alice.core.property.ResponseProperty;
import edu.cmu.cs.stage3.alice.core.property.UserDefinedResponseProperty;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.awt.AWTUtilities;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.FileSystemTreeLoader;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.scheduler.AbstractScheduler;
import edu.cmu.cs.stage3.scheduler.SchedulerThread;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class AuthoringTool
implements ClipboardOwner {
    public static final String WORLD_EXTENSION = "a2w";
    private World world;
    private JAliceFrame jAliceFrame;
    private EditorManager editorManager;
    private DefaultScheduler scheduler;
    private OneShotScheduler oneShotScheduler;
    private Runnable worldScheduleRunnable;
    private DefaultClock worldClock;
    private MainUndoRedoStack undoRedoStack;
    private Actions actions;
    private OutputComponent stdOutOutputComponent;
    private OutputComponent stdErrOutputComponent;
    private WatcherPanel watcherPanel;
    private JFileChooser saveWorldFileChooser;
    private LoadElementProgressPane worldLoadProgressPane;
    private StoreElementProgressPane worldStoreProgressPane;
    private AboutContentPane aboutContentPane;
    private StartUpContentPane startUpContentPane;
    private NewVariableContentPane newVariableContentPane;
    private RenderContentPane renderContentPane;
    private JPanel renderPanel;
    private FileFilter worldFileFilter;
    private File currentWorldLocation;
    private boolean worldHasBeenModified = false;
    private long lastSaveTime;
    private WindowListener jAliceFrameWindowListener;
    private boolean saveTabsEnabled = false;
    private RectangleAnimator rectangleAnimator;
    private Element selectedElement;
    private HashSet selectionListeners = new HashSet();
    private HashSet stateListeners = new HashSet();
    private static AuthoringTool instance;
    protected HashMap componentMap = new HashMap();
    protected HashSet classesToStopOn = new HashSet();
    protected Timer updateTimer;

    public static AuthoringTool getInstance() {
        if (instance == null) {
            instance = new AuthoringTool();
        }
        return instance;
    }

    private AuthoringTool() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            UIManager.put("Label.font", new Font("SansSerif", 1, 12));
            UIManager.put("Label.foreground", AuthoringToolResources.getColor("mainFontColor"));
            UIManager.put("TabbedPane.selected", new Color(255, 255, 255, 0));
            UIManager.put("TabbedPane.tabInsets", new Insets(1, 4, 1, 3));
            try {
                if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows")) {
                    UIManager.put("FileChooserUI", "com.sun.java.swing.plaf.windows.WindowsFileChooserUI");
                }
            }
            catch (Exception exception) {
                System.err.println("Error: AuthoringTool.java: trying to get OS name: " + exception.toString());
            }
        }
        catch (Exception exception) {
            System.err.println("Error: AuthoringTool.java: configuring Look and Feel: " + exception.toString());
            this.showErrorDialog("Error configuring Look and Feel.", exception);
        }
        instance = this;
        this.filterInit();
        try {
            int n = 12;
            UIManager.put("Label.font", new Font("SansSerif", 1, n));
            UIManager.put("Button.font", new Font("SansSerif", 1, n));
            UIManager.put("Checkbox.font", new Font("SansSerif", 1, n));
            UIManager.put("ColorChooser.font", new Font("SansSerif", 1, n));
            UIManager.put("ComboBox.font", new Font("SansSerif", 1, n));
            UIManager.put("EditorPane.font", new Font("SansSerif", 1, n));
            UIManager.put("Menu.font", new Font("SansSerif", 1, n));
            UIManager.put("List.font", new Font("SansSerif", 1, n));
            UIManager.put("MenuBar.font", new Font("SansSerif", 1, n));
            UIManager.put("MenuItem.font", new Font("SansSerif", 1, n));
            UIManager.put("OptionPane.font", new Font("SansSerif", 1, n));
            UIManager.put("Panel.font", new Font("SansSerif", 1, n));
            UIManager.put("PasswordField.font", new Font("SansSerif", 1, n));
            UIManager.put("PopupMenu.font", new Font("SansSerif", 1, n));
            UIManager.put("ProgressBar.font", new Font("SansSerif", 1, n));
            UIManager.put("RadioButton.font", new Font("SansSerif", 1, n));
            UIManager.put("ScrollPane.font", new Font("SansSerif", 1, n));
            UIManager.put("Table.font", new Font("SansSerif", 1, n));
            UIManager.put("TableHeader.font", new Font("SansSerif", 1, n));
            UIManager.put("Text.font", new Font("SansSerif", 1, n));
            UIManager.put("TextArea.font", new Font("SansSerif", 1, n));
            UIManager.put("TextField.font", new Font("SansSerif", 1, n));
            UIManager.put("TextPane.font", new Font("SansSerif", 1, n));
            UIManager.put("TitledBorder.font", new Font("SansSerif", 1, n));
            UIManager.put("ToggleButton.font", new Font("SansSerif", 1, n));
            UIManager.put("ToolBar.font", new Font("SansSerif", 1, n));
            UIManager.put("ToolTip.font", new Font("SansSerif", 1, n));
            UIManager.put("Tree.font", new Font("SansSerif", 1, n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainInit();
        this.dialogInit();
        this.undoRedoInit();
        this.miscInit();
        this.worldInit();
        this.stencilInit();
        AbstractScheduler abstractScheduler = new AbstractScheduler(){

            protected void handleCaughtThowable(Runnable runnable, Throwable throwable) {
                this.markEachFrameRunnableForRemoval(runnable);
                AuthoringTool.this.showErrorDialog(runnable.toString(), throwable);
            }
        };
        abstractScheduler.addEachFrameRunnable(this.scheduler);
        abstractScheduler.addEachFrameRunnable(this.oneShotScheduler);
        try {
            SchedulerThread schedulerThread = new SchedulerThread(abstractScheduler);
            schedulerThread.start();
        }
        catch (Exception exception) {
            System.err.println("Error: AuthoringTool.java: constructor: schedulerThread: " + exception.toString());
            exception.printStackTrace();
        }
        if (!JAlice.getInstance().isApplet()) {
            this.jAliceFrame.setVisible(true);
        }
    }

    private void filterInit() {
        this.worldFileFilter = new ExtensionFileFilter(WORLD_EXTENSION, WORLD_EXTENSION.toUpperCase() + " (Alice World Files)");
    }

    private void mainInit() {
        try {
            this.editorManager = new EditorManager(this);
            this.scheduler = new DefaultScheduler();
            this.undoRedoStack = new MainUndoRedoStack(this);
            this.oneShotScheduler = new OneShotScheduler();
            this.jAliceFrame = new JAliceFrame(this);
            this.actions = new Actions(this, this.jAliceFrame);
            this.jAliceFrame.actionInit(this.actions);
            DialogManager.initialize(this.jAliceFrame);
            this.stdOutOutputComponent = new OutputComponent();
            this.stdErrOutputComponent = new OutputComponent();
            this.watcherPanel = new WatcherPanel();
        }
        catch (Exception exception) {
            System.err.println("Error: AuthoringTool.java: mainInit(): " + exception.toString());
        }
    }

    private void dialogInit() {
        if (!JAlice.getInstance().isApplet()) {
            this.fileInit();
        }
        this.worldLoadProgressPane = new LoadElementProgressPane("Loading program/algorithm...", "Loading: ");
        this.worldStoreProgressPane = new StoreElementProgressPane("Saving program/algorithm...", "Saving: ");
        this.renderContentPane = new RenderContentPane(this);
        this.renderPanel = new JPanel();
        this.aboutContentPane = new AboutContentPane();
        this.renderPanel.setLayout(new BorderLayout());
        this.newVariableContentPane = new NewVariableContentPane();
    }

    private void fileInit() {
        this.saveWorldFileChooser = new JFileChooser(){

            public void approveSelection() {
                File file = this.getSelectedFile();
                if (AuthoringTool.this.currentWorldLocation == null || AuthoringTool.this.currentWorldLocation.equals(file) || !file.exists()) {
                    if (AuthoringTool.this.shouldAllowOverwrite(file)) {
                        super.approveSelection();
                    } else {
                        DialogManager.showMessageDialog("That is protected Alice file and you can not overwrite it. Please choose another file.");
                    }
                } else if (file.exists()) {
                    if (AuthoringTool.this.shouldAllowOverwrite(file)) {
                        int n = DialogManager.showConfirmDialog("You are about to save over an existing file. Are you sure you want to?", "Save Over Warning", 0);
                        if (n == 0) {
                            super.approveSelection();
                        }
                    } else {
                        DialogManager.showMessageDialog("That is protected Alice file and you can not overwrite it. Please choose another file.");
                    }
                }
            }
        };
        this.saveWorldFileChooser.setApproveButtonText("Save As");
        this.saveWorldFileChooser.setDialogTitle("Save As...");
        this.saveWorldFileChooser.setFileSelectionMode(0);
        this.saveWorldFileChooser.setDialogType(1);
        this.saveWorldFileChooser.setFileFilter(this.worldFileFilter);
        this.saveWorldFileChooser.setPreferredSize(new Dimension(500, 300));
        this.startUpContentPane = new StartUpContentPane(this);
    }

    private void undoRedoInit() {
        this.addAuthoringToolStateListener(this.undoRedoStack);
        this.undoRedoStack.addUndoRedoListener(new UndoRedoListener(){

            public void onChange() {
                int n = AuthoringTool.this.undoRedoStack.getCurrentUndoableRedoableIndex();
                if (n == -1) {
                    ((AuthoringTool)AuthoringTool.this).actions.undoAction.setEnabled(false);
                } else {
                    ((AuthoringTool)AuthoringTool.this).actions.undoAction.setEnabled(true);
                }
                if (n == AuthoringTool.this.undoRedoStack.size() - 1) {
                    ((AuthoringTool)AuthoringTool.this).actions.redoAction.setEnabled(false);
                } else {
                    ((AuthoringTool)AuthoringTool.this).actions.redoAction.setEnabled(true);
                }
                AuthoringTool.this.worldHasBeenModified = n != AuthoringTool.this.undoRedoStack.getUnmodifiedIndex();
                AuthoringTool.this.updateTitle();
            }
        });
    }

    private void miscInit() {
        this.scheduler.addEachFrameRunnable(this.oneShotScheduler);
        this.jAliceFrameWindowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AuthoringTool.this.quit();
            }
        };
        this.jAliceFrame.addWindowListener(this.jAliceFrameWindowListener);
        this.worldClock = new DefaultClock();
        this.worldScheduleRunnable = new Runnable(){

            public void run() {
                try {
                    AuthoringTool.this.worldClock.schedule();
                }
                catch (Throwable throwable) {
                    System.err.println("Error: AuthoringTool.java: miscInit(): " + throwable.toString());
                    AuthoringTool.this.stopWorldAndShowDialog(throwable);
                }
            }
        };
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        timer.start();
        this.lastSaveTime = System.currentTimeMillis();
        Timer timer2 = new Timer(60000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                long l;
                long l2;
                long l3;
                Window[] windowArray;
                boolean bl = false;
                for (Window window : windowArray = AuthoringTool.this.jAliceFrame.getOwnedWindows()) {
                    if (!window.isShowing()) continue;
                    bl = true;
                    break;
                }
                boolean bl2 = false;
                if (!AuthoringTool.this.worldHasBeenModified) {
                    bl2 = true;
                }
                if (!bl && !bl2 && (l3 = (l2 = System.currentTimeMillis()) - AuthoringTool.this.lastSaveTime) > (l = (long)(n = 15) * 60000L)) {
                    int n2 = DialogManager.showOptionDialog("You have not saved in more than" + n + " minutes.\nIt is recommended that you save early and often to avoid losing work.", "Save?", 0, 2, null, new Object[]{"Save right now", "Remind me later"}, "Save right now");
                    if (n2 == 0) {
                        AuthoringTool.this.getActions().saveWorldAction.actionPerformed(null);
                    }
                    AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
                }
            }
        });
        timer2.start();
        this.addAuthoringToolStateListener(new AuthoringToolStateAdapter(){

            public void worldLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
                AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
            }

            public void worldSaved(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
                AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
            }
        });
        if (AWTUtilities.mouseListenersAreSupported() || AWTUtilities.mouseMotionListenersAreSupported()) {
            this.scheduler.addEachFrameRunnable(new Runnable(){

                public void run() {
                    AWTUtilities.fireMouseAndMouseMotionListenersIfNecessary();
                }
            });
        }
        this.rectangleAnimator = new RectangleAnimator(this);
        this.watcherPanel.setMinimumSize(new Dimension(0, 0));
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    private void worldInit() {
        this.leaveWorld(false);
        this.world = new World();
        this.world.name.set("main");
        UserDefinedResponse userDefinedResponse = new UserDefinedResponse();
        userDefinedResponse.name.set("play");
        this.world.responses.add(userDefinedResponse);
        this.world.addChild(userDefinedResponse);
        this.world.m_children.add(userDefinedResponse);
        CallToUserDefinedResponse callToUserDefinedResponse = new CallToUserDefinedResponse();
        UserDefinedResponseProperty userDefinedResponseProperty = new UserDefinedResponseProperty((Element)callToUserDefinedResponse, "userDefinedResponse", userDefinedResponse);
        callToUserDefinedResponse.setUserDefinedResponse(userDefinedResponseProperty);
        WorldStartBehavior worldStartBehavior = new WorldStartBehavior();
        worldStartBehavior.addChild(callToUserDefinedResponse);
        worldStartBehavior.m_children.add(callToUserDefinedResponse);
        ResponseProperty responseProperty = new ResponseProperty((Element)worldStartBehavior, "triggerResponse", callToUserDefinedResponse);
        worldStartBehavior.setTriggerResponse(responseProperty);
        worldStartBehavior.name.set("behavior0");
        worldStartBehavior.isEnabled.set(true);
        this.world.addChild(worldStartBehavior);
        this.world.behaviors.add(worldStartBehavior);
        this.worldClock.setWorld(this.world);
        this.world.setClock(this.worldClock);
        this.jAliceFrame.setWorld(this.world);
        Element[] elementArray = this.world.getDescendants(RenderTarget.class);
        if (elementArray.length > 0) {
            this.renderPanel.removeAll();
            this.renderPanel.revalidate();
            this.renderPanel.repaint();
        }
        this.setSelectedElement(this.world);
        this.loadTabs();
        if (!this.world.responses.isEmpty()) {
            this.editObject(this.world.responses.get(0), true);
        }
        this.undoRedoStack.setUnmodified();
        this.fireWorldLoaded(this.world);
    }

    public JAliceFrame getJAliceFrame() {
        return this.jAliceFrame;
    }

    public DefaultScheduler getScheduler() {
        return this.scheduler;
    }

    public OneShotScheduler getOneShotScheduler() {
        return this.oneShotScheduler;
    }

    public MainUndoRedoStack getUndoRedoStack() {
        return this.undoRedoStack;
    }

    public Actions getActions() {
        return this.actions;
    }

    public Object getContext() {
        return null;
    }

    public void setContext(Object object) {
    }

    public OutputComponent getStdOutOutputComponent() {
        return this.stdOutOutputComponent;
    }

    public OutputComponent getStdErrOutputComponent() {
        return this.stdErrOutputComponent;
    }

    public WatcherPanel getWatcherPanel() {
        return this.watcherPanel;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public void setSelectedElement(Element element) {
        if (element == null) {
            element = this.getWorld();
        }
        if (this.selectedElement != element) {
            this.selectedElement = element;
            this.fireElementSelected(element);
        }
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public void addElementSelectionListener(ElementSelectionListener elementSelectionListener) {
        this.selectionListeners.add(elementSelectionListener);
    }

    protected void fireElementSelected(Element element) {
        Iterator iterator = this.selectionListeners.iterator();
        while (iterator.hasNext()) {
            ((ElementSelectionListener)iterator.next()).elementSelected(element);
        }
    }

    public void addAuthoringToolStateListener(AuthoringToolStateListener authoringToolStateListener) {
        this.stateListeners.add(authoringToolStateListener);
    }

    protected void fireStateChanging(int n, int n2) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, this.world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.stateChanging(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to an authoring tool state change.", throwable);
            }
        }
    }

    protected void fireWorldLoading(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldLoading(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world load.", throwable);
            }
        }
    }

    protected void fireWorldUnLoading(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldUnLoading(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world unload.", throwable);
            }
        }
    }

    protected void fireWorldStarting(int n, int n2, World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldStarting(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world starting.", throwable);
            }
        }
    }

    protected void fireWorldStopping(int n, int n2, World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldStopping(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world stopping.", throwable);
            }
        }
    }

    protected void fireWorldSaving(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldSaving(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world saving.", throwable);
            }
        }
    }

    protected void fireStateChanged(int n, int n2) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, this.world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.stateChanged(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to authoring tool state changed.", throwable);
            }
        }
    }

    protected void fireWorldLoaded(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldLoaded(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world loaded.", throwable);
            }
        }
    }

    protected void fireWorldUnLoaded(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldUnLoaded(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world unloaded.", throwable);
            }
        }
    }

    protected void fireWorldStarted(int n, int n2, World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldStarted(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world started.", throwable);
            }
        }
    }

    protected void fireWorldStopped(int n, int n2, World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(n, n2, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldStopped(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world stopped.", throwable);
            }
        }
    }

    protected void fireWorldSaved(World world) {
        AuthoringToolStateChangedEvent authoringToolStateChangedEvent = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener authoringToolStateListener : this.stateListeners) {
            try {
                authoringToolStateListener.worldSaved(authoringToolStateChangedEvent);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error in listener responding to world saved.", throwable);
            }
        }
    }

    public void editObject(Object object) {
        this.editObject(object, true);
    }

    public void editObject(Object object, boolean bl) {
        Class clazz = null;
        if (object != null) {
            clazz = EditorUtilities.getBestEditor(object.getClass());
        }
        this.editObject(object, clazz, bl);
    }

    public void editObject(Object object, Class clazz, boolean bl) {
        this.jAliceFrame.getTabbedEditorComponent().editObject(object, clazz, bl);
        this.saveTabs();
    }

    public void editObject(Object object, JComponent jComponent) {
        if (!this.isObjectBeingEdited(object)) {
            this.animateEditOpen(jComponent);
        }
        this.editObject(object);
    }

    protected void animateEditOpen(JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, jComponent);
        rectangle.setLocation(point);
        Rectangle rectangle2 = this.jAliceFrame.getTabbedEditorComponent().getBounds();
        Point point2 = rectangle2.getLocation();
        SwingUtilities.convertPointToScreen(point2, this.jAliceFrame.getTabbedEditorComponent());
        rectangle2.setLocation(point2);
        Color color = jComponent.getBackground();
        this.rectangleAnimator.animate(rectangle, rectangle2, color);
    }

    public Object getObjectBeingEdited() {
        return this.jAliceFrame.getTabbedEditorComponent().getObjectBeingEdited();
    }

    public Object[] getObjectsBeingEdited() {
        return this.jAliceFrame.getTabbedEditorComponent().getObjectsBeingEdited();
    }

    public boolean isObjectBeingEdited(Object object) {
        return this.jAliceFrame.getTabbedEditorComponent().isObjectBeingEdited(object);
    }

    private int showStartUpDialog(int n) {
        int n2 = this.askForSaveIfNecessary();
        if (n2 != 3) {
            this.startUpContentPane.setTabID(n);
            if (DialogManager.showDialog(this.startUpContentPane) == 0) {
                File file = this.startUpContentPane.getFile();
                this.loadWorld(file, false);
            }
            return 1;
        }
        return n2;
    }

    public int newWorld() {
        int n = this.askForSaveIfNecessary();
        if (n != 3) {
            this.worldInit();
            return 1;
        }
        return n;
    }

    public int openWorld() {
        return this.showStartUpDialog(1);
    }

    public int saveWorld() {
        if (this.currentWorldLocation != null && this.shouldAllowOverwrite(this.currentWorldLocation) && this.currentWorldLocation.canWrite()) {
            try {
                return this.saveWorldToFile(this.currentWorldLocation);
            }
            catch (IOException iOException) {
                AuthoringTool.getInstance().showErrorDialog("Unable to save world: " + this.currentWorldLocation.getAbsolutePath(), iOException);
                return 2;
            }
        }
        return this.saveWorldAs();
    }

    public int saveWorldAs() {
        int n = DialogManager.showSaveDialog(this.saveWorldFileChooser);
        if (n == 0) {
            File file = this.saveWorldFileChooser.getSelectedFile();
            if (!file.getName().endsWith(".a2w")) {
                file = new File(file.getParent(), file.getName() + "." + WORLD_EXTENSION);
            }
            try {
                return this.saveWorldToFile(file);
            }
            catch (IOException iOException) {
                AuthoringTool.getInstance().showErrorDialog("Unable to save world: " + file, iOException);
                file.delete();
                return 2;
            }
        }
        if (n == 0) {
            return 3;
        }
        return 2;
    }

    private void finalCleanUp() {
    }

    public int quit() {
        try {
            int n;
            int n2 = this.leaveWorld(true);
            if (n2 == 1) {
                this.finalCleanUp();
                System.exit(0);
                return 1;
            }
            if (n2 == 3) {
                return 3;
            }
            if (n2 == 2 && (n = DialogManager.showConfirmDialog("iVProg failed to correctly save and/or close the current world.  Would you still like to quit?")) == 0) {
                this.finalCleanUp();
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            try {
                int n = DialogManager.showConfirmDialog("Error encountered while attempting to close Alice.  Would you like to force the close?");
                if (n == 0) {
                    this.finalCleanUp();
                    System.exit(1);
                }
            }
            catch (Throwable throwable2) {
                this.finalCleanUp();
                System.exit(1);
            }
        }
        return 2;
    }

    public int askForSaveIfNecessary() {
        if (this.worldHasBeenModified) {
            if (JAlice.getInstance() == null || JAlice.getInstance().isApplet()) {
                return 3;
            }
            if (this.currentWorldLocation == null || !this.shouldAllowOverwrite(this.currentWorldLocation)) {
                String string = I18n.getString("msgSaveProgram");
                int n = DialogManager.showConfirmDialog(string, I18n.getString("msgSaveIt"), 1);
                if (n == 0) {
                    int n2 = this.saveWorldAs();
                    if (n2 == 3) {
                        return this.askForSaveIfNecessary();
                    }
                    if (n2 == 2) {
                        return 2;
                    }
                } else {
                    if (n == 1) {
                        return 1;
                    }
                    if (n == 2) {
                        return 3;
                    }
                    if (n == -1) {
                        return 3;
                    }
                }
            } else {
                String string = I18n.getString("msgModifiedSave");
                int n = DialogManager.showConfirmDialog(string, I18n.getString("msgSaveIt"), 1);
                if (n == 0) {
                    int n3 = this.saveWorld();
                    if (n3 == 3) {
                        return 3;
                    }
                    if (n3 == 2) {
                        return 2;
                    }
                } else {
                    if (n == 1) {
                        return 1;
                    }
                    if (n == 2) {
                        return 3;
                    }
                    if (n == -1) {
                        return 3;
                    }
                }
            }
            this.worldHasBeenModified = false;
            this.undoRedoStack.setUnmodified();
        }
        return 1;
    }

    public int leaveWorld(boolean bl) {
        try {
            if (bl) {
                int n = this.askForSaveIfNecessary();
                if (n == 3) {
                    return 3;
                }
                if (n == 2) {
                    return 2;
                }
            }
            this.fireWorldUnLoading(this.world);
            this.saveTabsEnabled = false;
            this.undoRedoStack.clear();
            this.jAliceFrame.setWorld(null);
            this.setCurrentWorldLocation(null);
            this.editObject(null);
            if (this.world != null) {
                this.world.release();
                this.fireWorldUnLoaded(this.world);
            }
            this.world = null;
            return 1;
        }
        catch (Exception exception) {
            AuthoringTool.getInstance().showErrorDialog("Error encountered while leaving current program/algorithm.", exception);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveWorldToFile(File file) throws IOException {
        int n;
        if (file.exists() && !file.canWrite()) {
            DialogManager.showMessageDialog("Cannot save program/algorithm. " + file.getAbsolutePath() + " is read-only.", "Cannot Save", 0);
            return 2;
        }
        if (file.exists()) {
            this.worldStoreProgressPane.setIsCancelEnabled(false);
        } else {
            this.worldStoreProgressPane.setIsCancelEnabled(true);
        }
        this.fireWorldSaving(this.world);
        boolean bl = this.getUndoRedoStack().getIsListening();
        this.undoRedoStack.setIsListening(false);
        try {
            this.saveTabsEnabled = true;
            this.saveTabs();
            Hashtable hashtable = new Hashtable();
            this.worldStoreProgressPane.setElement(this.world);
            this.worldStoreProgressPane.setFile(file);
            this.worldStoreProgressPane.setFilnameToByteArrayMap(hashtable);
            n = DialogManager.showDialog(this.worldStoreProgressPane);
            if (n == 0) {
                if (this.worldStoreProgressPane.wasSuccessful()) {
                    this.jAliceFrame.HACK_standDownFromRedAlert();
                    this.worldHasBeenModified = false;
                    this.undoRedoStack.setUnmodified();
                    this.setCurrentWorldLocation(file);
                    this.fireWorldSaved(this.world);
                    int n2 = 1;
                    return n2;
                }
                int n3 = 2;
                return n3;
            }
            file.delete();
            int n4 = 3;
            return n4;
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Unable to store program/algorithm to file: " + file, throwable);
            n = 2;
            return n;
        }
        finally {
            this.undoRedoStack.setIsListening(bl);
        }
    }

    public int loadWorld(File file, boolean bl) {
        int n;
        if (file.isFile()) {
            n = this.loadWorld(new ZipFileTreeLoader(), file, bl);
        } else if (file.isDirectory()) {
            n = this.loadWorld(new FileSystemTreeLoader(), file, bl);
        } else {
            AuthoringTool.getInstance().showErrorDialog("not a file or directory: " + file, null);
            n = 2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadWorld(DirectoryTreeLoader directoryTreeLoader, Object object, boolean bl) {
        if (bl) {
            int n;
            int n2 = this.askForSaveIfNecessary();
            if (n2 == 3) {
                return 3;
            }
            if (n2 == 2 && (n = DialogManager.showConfirmDialog("iVProg failed to correctly save the current program/algorithm.  Would you still like to load a new program?")) != 0) {
                return 3;
            }
        }
        this.fireWorldLoading(null);
        World world = null;
        try {
            directoryTreeLoader.open(object);
            try {
                this.worldLoadProgressPane.setLoader(directoryTreeLoader);
                this.worldLoadProgressPane.setExternalRoot(null);
                DialogManager.showDialog(this.worldLoadProgressPane);
                world = (World)this.worldLoadProgressPane.getLoadedElement();
            }
            finally {
                directoryTreeLoader.close();
            }
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Unable to load program/algorithm: " + object, throwable);
        }
        if (object instanceof File) {
            this.setCurrentWorldLocation((File)object);
            if (((File)object).isDirectory()) {
                // empty if block
            }
        } else {
            this.setCurrentWorldLocation(null);
        }
        return this.populateWorldPanel(world);
    }

    public int loadAppletWorld(String string) {
        World world = null;
        try {
            world = (World)AppletWorldLoader.loadWorld(string);
        }
        catch (Exception exception) {
            System.err.println("Error: AuthoringTool.java: loadAppletWorld: " + exception.toString());
            exception.printStackTrace();
        }
        return this.populateWorldPanel(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int populateWorldPanel(World world) {
        if (world != null) {
            this.leaveWorld(false);
            this.world = world;
            this.worldClock.setWorld(this.world);
            this.world.setClock(this.worldClock);
            this.jAliceFrame.setWorld(this.world);
            Element[] elementArray = this.world.getDescendants(RenderTarget.class);
            if (elementArray.length > 0) {
                this.renderPanel.removeAll();
                this.renderPanel.revalidate();
                this.renderPanel.repaint();
            }
            this.setSelectedElement(this.world);
            this.loadTabs();
            if (!this.world.responses.isEmpty()) {
                this.editObject(this.world.responses.get(0), true);
            }
            this.undoRedoStack.setUnmodified();
            this.fireWorldLoaded(this.world);
            return 1;
        }
        return 2;
    }

    protected boolean shouldAllowOverwrite(File file) {
        return true;
    }

    public void saveTabs() {
        if (this.saveTabsEnabled && this.world != null) {
            Object[] objectArray = this.jAliceFrame.getTabbedEditorComponent().getObjectsBeingEdited();
            String string = "";
            for (Object object : objectArray) {
                if (!(object instanceof Element)) continue;
                string = string + ((Element)object).getKey() + ":";
            }
            this.world.data.put("edu.cmu.cs.stage3.alice.authoringtool.tabObjects", string);
        }
    }

    public void loadTabs() {
        String string;
        if (this.world != null && (string = (String)this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.tabObjects")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.getJAliceFrame().setCursor(Cursor.getPredefinedCursor(3));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Element element = this.world.getDescendantKeyed(string2 = string2.substring(this.world.getKey().length() + (string2.equals(this.world.getKey()) ? 0 : 1)));
                if (element == null) continue;
                this.editObject((Object)element, false);
            }
            this.getJAliceFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void performOneShot(Response response, Response response2, Property[] propertyArray) {
        OneShotSimpleBehavior oneShotSimpleBehavior = new OneShotSimpleBehavior();
        oneShotSimpleBehavior.setResponse(response);
        oneShotSimpleBehavior.setAffectedProperties(propertyArray);
        oneShotSimpleBehavior.start(this.oneShotScheduler);
        OneShotUndoableRedoable oneShotUndoableRedoable = new OneShotUndoableRedoable(response, response2, oneShotSimpleBehavior, this.oneShotScheduler);
        this.undoRedoStack.push(oneShotUndoableRedoable);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setElementScope(Element element) {
        if (element != null) {
            if (this.selectedElement != null) {
                if (!this.selectedElement.isDescendantOf(element)) {
                    this.setSelectedElement(element);
                }
            } else {
                this.setSelectedElement(element);
            }
        }
    }

    public void showAbout() {
        DialogManager.showDialog(this.aboutContentPane);
    }

    public void viewXml() {
        String string = AppletWorldStorer.getWorldXml(this.world);
        DialogManager.showTextDialog(string);
    }

    public void viewHtml() {
        String string = "<html><head><title>iVProg</title></head><applet codebase='.' archive='ivprog.jar' code='edu.cmu.cs.stage3.alice.authoringtool.JAlice.class' WIDTH=791 HEIGHT=530><param name='MA_PARAM_Proposition' value='";
        string = string + AppletWorldStorer.getWorldXml(this.world);
        string = string + "'></applet></html>";
        DialogManager.showTextDialog(string);
    }

    public void showSaveErrorDialog(String string, Throwable throwable) {
        AuthoringTool.getInstance().jAliceFrame.HACK_goToRedAlert();
        SaveErrorContentPane saveErrorContentPane = new SaveErrorContentPane();
        saveErrorContentPane.setMessage(string);
        saveErrorContentPane.setSubmitBugButtonEnabled(true);
        saveErrorContentPane.setThrowable(throwable);
        DialogManager.showDialog(saveErrorContentPane);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    public void showErrorDialog(String string, Throwable throwable) {
        this.showErrorDialog(string, throwable, true);
    }

    public void showErrorDialog(String string, Throwable throwable, boolean bl) {
        ErrorContentPane errorContentPane = new ErrorContentPane();
        errorContentPane.setMessage(string);
        errorContentPane.setSubmitBugButtonEnabled(bl);
        errorContentPane.setThrowable(throwable);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    public void showErrorDialogWithDetails(String string, String string2, boolean bl) {
        ErrorContentPane errorContentPane = new ErrorContentPane();
        errorContentPane.setMessage(string);
        errorContentPane.setSubmitBugButtonEnabled(bl);
        DialogManager.showDialog(errorContentPane);
    }

    private void stopWorldAndShowDialog(Throwable throwable) {
        this.stopWorld();
        if (throwable instanceof ExceptionWrapper) {
            throwable = ((ExceptionWrapper)throwable).getWrappedException();
        }
        final Throwable throwable2 = throwable;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (throwable2 instanceof SimulationException) {
                    AuthoringTool.this.showSimulationExceptionDialog((SimulationException)throwable2);
                } else {
                    AuthoringTool.this.showErrorDialog("Error during simulation.", throwable2);
                }
            }
        });
    }

    public void showSimulationExceptionDialog(SimulationException simulationException) {
        SimulationExceptionPanel simulationExceptionPanel = new SimulationExceptionPanel(this);
        simulationExceptionPanel.setSimulationException(simulationException);
        DialogManager.showMessageDialog(simulationExceptionPanel, "Problem Detected", 0, AuthoringToolResources.getAliceSystemIcon());
    }

    public World getWorld() {
        return this.world;
    }

    public void showOnScreenHelp() {
        this.showStencils();
    }

    public void showStdErrOutDialog() {
    }

    private void setCurrentWorldLocation(File file) {
        this.currentWorldLocation = file;
        this.updateTitle();
    }

    private void updateTitle() {
        String string = "";
        if (this.currentWorldLocation != null) {
            try {
                string = this.currentWorldLocation.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = this.currentWorldLocation.getAbsolutePath();
            }
        }
        String string2 = "";
        if (this.worldHasBeenModified) {
            string2 = " [Modified]";
        }
        this.jAliceFrame.setTitle("iVProg " + string + string2);
    }

    private void stencilInit() {
        this.classesToStopOn.add(JMenu.class);
        this.classesToStopOn.add(AbstractButton.class);
        this.classesToStopOn.add(JComboBox.class);
        this.classesToStopOn.add(JList.class);
        this.classesToStopOn.add(JMenu.class);
        this.classesToStopOn.add(JSlider.class);
        this.classesToStopOn.add(JTextComponent.class);
        this.classesToStopOn.add(JTabbedPane.class);
        this.classesToStopOn.add(JTree.class);
        this.classesToStopOn.add(JTable.class);
        this.classesToStopOn.add(DragFromComponent.class);
        this.classesToStopOn.add(DnDGroupingPanel.class);
        this.classesToStopOn.add(TrashComponent.class);
        this.classesToStopOn.add(PropertyViewController.class);
        this.componentMap.put("fileMenu", this.jAliceFrame.fileMenu);
        this.componentMap.put("helpMenu", this.jAliceFrame.helpMenu);
        this.componentMap.put("playButton", this.jAliceFrame.playButton);
        this.componentMap.put("undoButton", this.jAliceFrame.undoButton);
        this.componentMap.put("redoButton", this.jAliceFrame.redoButton);
        this.componentMap.put("trashComponent", this.jAliceFrame.trashComponent);
        this.componentMap.put("details", this.jAliceFrame.dragFromComponent);
        this.componentMap.put("editors", this.jAliceFrame.tabbedEditorComponent);
        this.updateTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.updateTimer.setRepeats(false);
    }

    public void hackStencilUpdate() {
        if (this.updateTimer != null) {
            this.updateTimer.restart();
        }
    }

    public void showStencils() {
        this.setLayout();
        this.jAliceFrame.requestFocus();
    }

    protected void restoreLayout() {
        this.jAliceFrame.doLayout();
        this.jAliceFrame.setResizable(true);
    }

    protected void setLayout() {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        Dimension dimension = this.getScreenSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (dimension.width > 1032) {
            n2 = 1032;
        } else if (dimension.width < 1024 && n >= 1024) {
            n2 = 1032;
        }
        if (dimension.height > 776) {
            n3 = 740;
        } else if (dimension.height < 740 && n >= 768) {
            n3 = 740;
        }
        boolean bl = true;
        this.renderContentPane.saveRenderBounds(new Rectangle(191, 199, 400, 300));
        if (bl) {
            this.jAliceFrame.leftRightSplitPane.setDividerLocation(230);
            this.jAliceFrame.setSize(n2, n3);
        }
        this.jAliceFrame.doLayout();
        this.jAliceFrame.setResizable(false);
    }

    public void setGlassPane(Component component) {
        this.jAliceFrame.setGlassPane(component);
    }

    public void setVisible(boolean bl) {
        if (JAlice.getInstance().isApplet()) {
            return;
        }
        if (bl) {
            this.setLayout();
            this.jAliceFrame.requestFocus();
        } else {
            this.restoreLayout();
            this.jAliceFrame.requestFocus();
        }
    }

    public Dimension getScreenSize() {
        return this.jAliceFrame.getSize();
    }

    public FileFilter getWorldFileFilter() {
        return this.worldFileFilter;
    }

    public Variable showNewVariableDialog(String string, Element element) {
        if (this.newVariableContentPane == null) {
            System.err.println("Error: AuthoringTool.java: showNewVariableDialog(): newVariableContentPane estava null");
            this.dialogInit();
        }
        this.newVariableContentPane.reset(element);
        this.newVariableContentPane.setTitle(string);
        this.newVariableContentPane.setListsOnly(false);
        this.newVariableContentPane.setShowValue(true);
        return this.showNewVariableDialog(this.newVariableContentPane, element);
    }

    public Variable showNewVariableDialog(String string, Element element, boolean bl, boolean bl2) {
        this.newVariableContentPane.reset(element);
        this.newVariableContentPane.setListsOnly(bl);
        this.newVariableContentPane.setShowValue(bl2);
        this.newVariableContentPane.setTitle(string);
        return this.showNewVariableDialog(this.newVariableContentPane, element);
    }

    protected Variable showNewVariableDialog(NewVariableContentPane newVariableContentPane, Element element) {
        int n = DialogManager.showDialog(newVariableContentPane);
        switch (n) {
            case 0: {
                return newVariableContentPane.getVariable();
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public File getCurrentWorldLocation() {
        return this.currentWorldLocation;
    }

    public String getCurrentRendererText() {
        return "";
    }

    private boolean worldRun() {
        this.undoRedoStack.setIsListening(false);
        this.fireStateChanging(1, 3);
        this.fireWorldStarting(1, 3, this.world);
        this.world.preserve();
        try {
            this.worldClock.start();
            this.scheduler.addEachFrameRunnable(this.worldScheduleRunnable);
            this.actions.pauseWorldAction.setEnabled(true);
            this.actions.resumeWorldAction.setEnabled(false);
            this.fireStateChanged(1, 3);
            this.fireWorldStarted(1, 3, this.world);
        }
        catch (SimulationException simulationException) {
            this.world.restore();
            this.showSimulationExceptionDialog(simulationException);
            return false;
        }
        catch (ExceptionWrapper exceptionWrapper) {
            this.world.restore();
            Exception exception = exceptionWrapper.getWrappedException();
            if (exception instanceof SimulationException) {
                this.showSimulationExceptionDialog((SimulationException)exception);
            } else {
                this.showErrorDialog("Error during world start.", exception);
            }
            return false;
        }
        catch (Throwable throwable) {
            this.world.restore();
            this.showErrorDialog("Error during world start.", throwable);
            return false;
        }
        return true;
    }

    public void worldStopRunning() {
        this.fireStateChanging(3, 1);
        this.fireWorldStopping(3, 1, this.world);
        this.scheduler.removeEachFrameRunnable(this.worldScheduleRunnable);
        try {
            this.worldClock.stop();
        }
        catch (Throwable throwable) {
            System.err.println("Error: AuthoringTool.java: worldStopRunning(): worldClock.stop(): " + throwable.toString());
            this.showErrorDialog("Error during world stop.", throwable);
        }
        this.world.restore();
        this.undoRedoStack.setIsListening(true);
        this.fireStateChanged(3, 1);
        this.fireWorldStopped(3, 1, this.world);
    }

    public double getAspectRatio() {
        double d = 0.0;
        return d;
    }

    private void checkForUnreferencedCurrentMethod() {
        Object object = this.getObjectBeingEdited();
        if (object instanceof UserDefinedResponse && !AuthoringToolResources.isMethodHookedUp((UserDefinedResponse)object, this.world)) {
            String string = AuthoringToolResources.getReprForValue(object, true);
            DialogManager.showMessageDialog("The current method (" + string + ") is not called by any events or by any other methods which might be called by any events.", "Warning: Current method will not be called.", 2);
        }
    }

    public void play() {
        this.jAliceFrame.playButton.setEnabled(false);
        this.checkForUnreferencedCurrentMethod();
        if (this.worldRun()) {
            double d = this.getAspectRatio();
            this.renderContentPane.setAspectRatio(d);
            this.renderContentPane.getRenderPanel().add((Component)this.renderPanel, "Center");
            DialogManager.showDialog(this.renderContentPane);
        }
        this.jAliceFrame.playButton.setEnabled(true);
    }

    public void pause() {
        this.worldClock.pause();
        this.actions.pauseWorldAction.setEnabled(false);
        this.actions.resumeWorldAction.setEnabled(true);
    }

    public void resume() {
        this.worldClock.resume();
        this.actions.pauseWorldAction.setEnabled(true);
        this.actions.resumeWorldAction.setEnabled(false);
    }

    public void restartWorld() {
        try {
            this.worldClock.stop();
            this.world.restore();
            this.actions.pauseWorldAction.setEnabled(true);
            this.actions.resumeWorldAction.setEnabled(false);
            this.worldClock.start();
        }
        catch (SimulationException simulationException) {
            this.showSimulationExceptionDialog(simulationException);
        }
        catch (ExceptionWrapper exceptionWrapper) {
            Exception exception = exceptionWrapper.getWrappedException();
            if (exception instanceof SimulationException) {
                this.showSimulationExceptionDialog((SimulationException)exception);
            } else {
                this.showErrorDialog("Error while restarting program.", exception);
            }
        }
        catch (Throwable throwable) {
            this.showErrorDialog("Error while restarting program.", throwable);
        }
    }

    public void stopWorld() {
        this.renderContentPane.stopWorld();
    }
}

