/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTreeStorer
implements DirectoryTreeStorer {
    protected ZipOutputStream zipOut = null;
    protected String currentDirectory = null;
    protected ZipEntry currentEntry = null;

    protected boolean isCompressed() {
        return true;
    }

    public void open(Object object) throws IllegalArgumentException, IOException {
        if (this.zipOut != null) {
            this.close();
        }
        OutputStream outputStream = null;
        if (object instanceof String) {
            outputStream = new FileOutputStream((String)object);
        } else if (object instanceof File) {
            outputStream = new FileOutputStream((File)object);
        } else if (object instanceof OutputStream) {
            outputStream = (OutputStream)object;
        } else {
            throw new IllegalArgumentException("pathname must be an instance of String, java.io.File, or java.io.OutputStream");
        }
        this.zipOut = new ZipOutputStream(new BufferedOutputStream(outputStream));
        if (!this.isCompressed()) {
            this.zipOut.setMethod(0);
        }
        this.currentDirectory = "";
    }

    public void close() throws IOException {
        if (this.zipOut != null) {
            this.closeCurrentFile();
            this.zipOut.flush();
            this.zipOut.finish();
            this.zipOut.close();
            this.zipOut = null;
        }
    }

    public void createDirectory(String string) throws IllegalArgumentException, IOException {
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            throw new IllegalArgumentException("pathname cannot contain path separators");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("pathname has no length");
        }
        ZipEntry zipEntry = new ZipEntry(this.currentDirectory + string + "/");
        if (this.zipOut == null) {
            throw new IOException("No zip file currently open");
        }
        this.zipOut.putNextEntry(zipEntry);
        this.zipOut.closeEntry();
    }

    public void setCurrentDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            int n;
            string = string.replace('\\', '/');
            while ((n = string.indexOf("//")) != -1) {
                string = string.substring(0, n + 1) + string.substring(n + 2);
            }
            if (!(string = string.charAt(0) == '/' ? string.substring(1) : this.currentDirectory + string).endsWith("/")) {
                string = string + "/";
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
        }
        this.currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public OutputStream createFile(String string, boolean bl) throws IllegalArgumentException, IOException {
        if (this.zipOut != null) {
            this.currentEntry = new ZipEntry(this.currentDirectory + string);
            if (!this.isCompressed()) {
                this.currentEntry.setMethod(0);
            }
        } else {
            throw new IOException("No zip file currently open");
        }
        this.zipOut.putNextEntry(this.currentEntry);
        return this.zipOut;
    }

    public void closeCurrentFile() throws IOException {
        if (this.currentEntry != null) {
            this.zipOut.flush();
            this.zipOut.closeEntry();
            this.currentEntry = null;
        }
    }

    public Object getKeepKey(String string) {
        return null;
    }

    public boolean isKeepFileSupported() {
        return false;
    }

    public void keepFile(String string) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        throw new KeepFileNotSupportedException();
    }
}

