/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.awt;

import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class AWTUtilities {
    private static boolean s_successfullyLoadedLibrary;
    private static Vector s_mouseListeners;
    private static Vector s_mouseMotionListeners;
    private static Component s_source;
    private static int s_prevModifiers;
    private static int s_clickCount;
    private static Point s_prevCursorPos;
    private static Point s_currCursorPos;

    private static native boolean isGetCursorLocationSupportedNative();

    public static boolean isGetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isSetCursorLocationSupportedNative();

    public static boolean isSetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isSetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isGetModifiersSupportedNative();

    public static boolean isGetModifiersSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetModifiersSupportedNative();
        }
        return false;
    }

    private static native void pumpMessageQueueNative();

    public static void pumpMessageQueue() {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.pumpMessageQueueNative();
        }
    }

    private static native void getCursorLocationNative(Point var0);

    public static Point getCursorLocation() {
        if (s_successfullyLoadedLibrary) {
            Point point = new Point();
            AWTUtilities.getCursorLocationNative(point);
            return point;
        }
        return null;
    }

    private static native void setCursorLocationNative(int var0, int var1);

    public static void setCursorLocation(int n, int n2) {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.setCursorLocationNative(n, n2);
        }
    }

    public static void setCursorLocation(Point point) {
        AWTUtilities.setCursorLocation(point.x, point.y);
    }

    private static native int getModifiersNative();

    public static int getModifiers() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.getModifiersNative();
        }
        return 0;
    }

    public static boolean mouseListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static boolean mouseMotionListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static void addMouseListener(MouseListener mouseListener) {
        s_mouseListeners.addElement(mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        s_mouseListeners.removeElement(mouseListener);
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.addElement(mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.removeElement(mouseMotionListener);
    }

    private static boolean isButton1Pressed(int n) {
        return (n & 0x10) == 16;
    }

    private static boolean isButton2Pressed(int n) {
        return (n & 8) == 8;
    }

    private static boolean isButton3Pressed(int n) {
        return (n & 4) == 4;
    }

    public static void fireMouseAndMouseMotionListenersIfNecessary() {
        if (AWTUtilities.mouseListenersAreSupported()) {
            int n = 0;
            int n2 = AWTUtilities.getModifiers();
            boolean bl = false;
            if (AWTUtilities.isButton1Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton1Pressed(n2)) {
                    bl = true;
                } else {
                    n = 502;
                }
            } else if (AWTUtilities.isButton1Pressed(n2)) {
                n = 501;
                bl = true;
            }
            if (AWTUtilities.isButton2Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton2Pressed(n2)) {
                    bl = true;
                } else {
                    n = 502;
                }
            } else if (AWTUtilities.isButton2Pressed(n2)) {
                n = 501;
                bl = true;
            }
            if (AWTUtilities.isButton3Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton3Pressed(n2)) {
                    bl = true;
                } else {
                    n = 502;
                }
            } else if (AWTUtilities.isButton3Pressed(n2)) {
                n = 501;
                bl = true;
            }
            long l = System.currentTimeMillis();
            boolean bl2 = false;
            AWTUtilities.getCursorLocationNative(s_currCursorPos);
            if (n != 0) {
                if (s_mouseListeners.size() > 0) {
                    MouseEvent mouseEvent = new MouseEvent(s_source, n, l, n2, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, bl2);
                    block11: for (int i = 0; i < s_mouseListeners.size(); ++i) {
                        MouseListener mouseListener = (MouseListener)s_mouseListeners.elementAt(i);
                        switch (n) {
                            case 500: {
                                mouseListener.mouseClicked(mouseEvent);
                                continue block11;
                            }
                            case 504: {
                                mouseListener.mouseEntered(mouseEvent);
                                continue block11;
                            }
                            case 505: {
                                mouseListener.mouseExited(mouseEvent);
                                continue block11;
                            }
                            case 501: {
                                mouseListener.mousePressed(mouseEvent);
                                continue block11;
                            }
                            case 502: {
                                mouseListener.mouseReleased(mouseEvent);
                            }
                        }
                    }
                }
            } else if ((AWTUtilities.s_currCursorPos.x != AWTUtilities.s_prevCursorPos.x || AWTUtilities.s_currCursorPos.y != AWTUtilities.s_prevCursorPos.y) && s_mouseMotionListeners.size() > 0) {
                n = bl ? 506 : 503;
                MouseEvent mouseEvent = new MouseEvent(s_source, n, l, n2, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, bl2);
                block12: for (int i = 0; i < s_mouseMotionListeners.size(); ++i) {
                    MouseMotionListener mouseMotionListener = (MouseMotionListener)s_mouseMotionListeners.elementAt(i);
                    switch (n) {
                        case 503: {
                            mouseMotionListener.mouseMoved(mouseEvent);
                            continue block12;
                        }
                        case 506: {
                            mouseMotionListener.mouseDragged(mouseEvent);
                        }
                    }
                }
            }
            AWTUtilities.s_prevCursorPos.x = AWTUtilities.s_currCursorPos.x;
            AWTUtilities.s_prevCursorPos.y = AWTUtilities.s_currCursorPos.y;
            s_prevModifiers = n2;
        }
    }

    static {
        try {
            System.loadLibrary("jni_awtutilities");
            s_successfullyLoadedLibrary = true;
        }
        catch (Throwable throwable) {
            s_successfullyLoadedLibrary = false;
        }
        s_mouseListeners = new Vector();
        s_mouseMotionListeners = new Vector();
        s_source = new Label("toolkit.Toolkit");
        s_prevModifiers = 0;
        s_clickCount = 0;
        s_prevCursorPos = new Point();
        s_currCursorPos = new Point();
    }
}

