/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;

public class WatcherPanel
extends JPanel {
    protected List variablesToWatch = new ArrayList();
    protected List propertiesToWatch = new ArrayList();
    protected Element root;

    public WatcherPanel() {
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
    }

    public boolean isThereSomethingToWatch() {
        return this.variablesToWatch.size() + this.propertiesToWatch.size() > 0;
    }

    public void clear() {
        this.removeAllVariablesBeingWatched();
        this.removeAllPropertiesBeingWatched();
    }

    public void addVariableToWatch(Variable variable) {
        this.variablesToWatch.add(variable);
        this.refreshGUI();
    }

    public void removeVariableBeingWatched(Variable variable) {
        this.variablesToWatch.remove(variable);
        this.refreshGUI();
    }

    public void removeAllVariablesBeingWatched() {
        this.variablesToWatch.clear();
        this.refreshGUI();
    }

    public boolean isVariableBeingWatched(Variable variable) {
        return this.variablesToWatch.contains(variable);
    }

    public void addPropertyToWatch(Property property) {
        this.propertiesToWatch.add(property);
        this.refreshGUI();
    }

    public void removePropertyBeingWatched(Property property) {
        this.propertiesToWatch.remove(property);
        this.refreshGUI();
    }

    public void removeAllPropertiesBeingWatched() {
        this.propertiesToWatch.clear();
        this.refreshGUI();
    }

    public boolean isPropertyBeingWatched(Property property) {
        return this.propertiesToWatch.contains(property);
    }

    protected void refreshGUI() {
        JPanel jPanel;
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory;
        Object object;
        this.removeAll();
        int n = 0;
        Object object2 = this.variablesToWatch.iterator();
        while (object2.hasNext()) {
            object = (Variable)object2.next();
            jPanel = GUIFactory.getVariableGUI((Variable)object, true, setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(((Variable)object).value));
            if (jPanel != null) {
                this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                continue;
            }
            AuthoringTool.getInstance().showErrorDialog(I18n.getString("msgUnableGuiVar") + ": " + object, null);
        }
        this.add(Box.createVerticalStrut(8), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        object2 = this.propertiesToWatch.iterator();
        while (object2.hasNext()) {
            object = (Property)object2.next();
            jPanel = GUIFactory.getPropertyGUI((Property)object, true, false, setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory((Property)object));
            if (jPanel != null) {
                this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                continue;
            }
            AuthoringTool.getInstance().showErrorDialog(I18n.getString("watchPunableProp") + ": " + object, null);
        }
        object2 = Box.createGlue();
        this.add((Component)object2, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.revalidate();
        this.repaint();
    }
}

