/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.core.Element;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class ElementTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected DnDGroupingPanel dndPanel = new DnDGroupingPanel();
    protected JPanel elementPanel = new JPanel();
    protected JLabel iconLabel = new JLabel();
    protected JLabel elementLabel = new JLabel();
    protected Color selectedColor = AuthoringToolResources.getColor("objectTreeSelected");
    protected Color bgColor = AuthoringToolResources.getColor("objectTreeBackground");
    protected Color disabledColor = AuthoringToolResources.getColor("objectTreeDisabled");
    protected Color textColor = AuthoringToolResources.getColor("objectTreeText");
    protected Color disabledTextColor = AuthoringToolResources.getColor("objectTreeDisabledText");
    protected Color selectedTextColor = AuthoringToolResources.getColor("objectTreeSelectedText");

    public ElementTreeCellRenderer() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dndPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 0, 0, 0), 0, 0));
        this.dndPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dndPanel.setBackground(this.bgColor);
        this.elementPanel.setLayout(new GridBagLayout());
        this.elementPanel.setOpaque(false);
        this.iconLabel.setOpaque(false);
        this.elementLabel.setBackground(this.selectedColor);
        this.elementLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.elementLabel.setOpaque(false);
        this.elementPanel.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.elementPanel.add((Component)this.elementLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.dndPanel.add((Component)this.elementPanel, "Center");
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof Element) {
            Element element = (Element)object;
            boolean bl5 = true;
            ImageIcon imageIcon = AuthoringToolResources.getIconForValue(element);
            if (bl5) {
                this.dndPanel.setBackground(this.bgColor);
                this.iconLabel.setIcon(imageIcon);
            } else {
                this.dndPanel.setBackground(this.disabledColor);
                this.iconLabel.setIcon(AuthoringToolResources.getDisabledIcon(imageIcon));
            }
            this.elementLabel.setText(element.name.getStringValue());
            if (bl) {
                this.elementLabel.setOpaque(true);
                if (bl5) {
                    this.elementLabel.setForeground(this.selectedTextColor);
                } else {
                    this.elementLabel.setForeground(this.disabledTextColor);
                }
            } else {
                this.elementLabel.setOpaque(false);
                if (bl5) {
                    this.elementLabel.setForeground(this.textColor);
                } else {
                    this.elementLabel.setForeground(this.disabledTextColor);
                }
            }
        } else {
            AuthoringTool.getInstance().showErrorDialog("Error: not an Element: " + object, null);
        }
        this.doLayout();
        return this;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        this.dndPanel.setBackground(color);
    }
}

