/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.variablegroupeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewVariableContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.VariableGUI;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VariableGroupEditor
extends JPanel
implements ObjectArrayPropertyListener,
DropTargetListener {
    protected ObjectArrayProperty variables;
    protected JButton newVariableButton = new JButton(I18n.getString("vgeGlobalVariable"));
    protected NewVariableContentPane newVariableDialog;
    protected AuthoringTool authoringTool;
    protected int lineLocation = -1;
    protected int variablePosition = 0;

    public VariableGroupEditor() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.newVariableButton.setBackground(new Color(240, 240, 255));
        this.newVariableButton.setMargin(new Insets(2, 4, 2, 4));
        this.newVariableButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Variable variable;
                if (VariableGroupEditor.this.authoringTool != null && (variable = VariableGroupEditor.this.authoringTool.showNewVariableDialog(I18n.getString("vgeNewVar"), VariableGroupEditor.this.variables.getOwner())) != null) {
                    VariableGroupEditor.this.authoringTool.getUndoRedoStack().startCompound();
                    try {
                        VariableGroupEditor.this.variables.getOwner().addChild(variable);
                        VariableGroupEditor.this.variables.add(variable);
                    }
                    finally {
                        VariableGroupEditor.this.authoringTool.getUndoRedoStack().stopCompound();
                    }
                }
            }
        });
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
        this.setDropTarget(new DropTarget(this, this));
        this.newVariableButton.setToolTipText(I18n.getString("vgeDialogVar"));
        this.refreshGUI();
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setVariableObjectArrayProperty(ObjectArrayProperty objectArrayProperty) {
        if (this.variables != null) {
            this.variables.removeObjectArrayPropertyListener(this);
        }
        this.variables = objectArrayProperty;
        if (this.variables != null) {
            this.variables.addObjectArrayPropertyListener(this);
        }
        this.refreshGUI();
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public JButton getNewVariableButton() {
        return this.newVariableButton;
    }

    public void refreshGUI() {
        this.removeAll();
        if (this.variables != null) {
            int n = 0;
            for (int i = 0; i < this.variables.size(); ++i) {
                SetPropertyImmediatelyFactory setPropertyImmediatelyFactory;
                if (!(this.variables.get(i) instanceof Variable)) continue;
                Variable variable = (Variable)this.variables.get(i);
                VariableGUI variableGUI = GUIFactory.getVariableGUI(variable, true, setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value));
                if (variableGUI != null) {
                    this.add((Component)variableGUI, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                    continue;
                }
                AuthoringTool.getInstance().showErrorDialog(I18n.getString("msgUnableGuiVar") + ": " + variable, null);
            }
            this.add((Component)this.newVariableButton, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 2), 0, 0));
            this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this));
            Component component = Box.createGlue();
            this.add(component, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            component.setDropTarget(new DropTarget(component, this));
        }
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.lineLocation > -1) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.black);
            graphics.fillRect(0, this.lineLocation, rectangle.width, 2);
        }
    }

    protected void calculateLineLocation(int n) {
        int n2;
        int n3 = this.variables.size() + 1;
        int[] nArray = new int[n3];
        nArray[0] = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            Component component = this.getComponent(n2 - 1);
            nArray[n2] = component.getBounds().y + component.getBounds().height + 1;
        }
        n2 = -1;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            int n5 = Math.abs(n - nArray[i]);
            if (n5 >= n4) continue;
            n4 = n5;
            n2 = i;
        }
        this.variablePosition = n2;
        this.lineLocation = nArray[n2];
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.variableReferenceFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
            int n = SwingUtilities.convertPoint((Component)dropTargetDragEvent.getDropTargetContext().getComponent(), (Point)dropTargetDragEvent.getLocation(), (Component)this).y;
            this.calculateLineLocation(n);
        } else {
            this.lineLocation = -1;
            dropTargetDragEvent.rejectDrag();
        }
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.variableReferenceFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
            int n = SwingUtilities.convertPoint((Component)dropTargetDragEvent.getDropTargetContext().getComponent(), (Point)dropTargetDragEvent.getLocation(), (Component)this).y;
            this.calculateLineLocation(n);
        } else {
            this.lineLocation = -1;
            dropTargetDragEvent.rejectDrag();
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.variableReferenceFlavor)) {
            dropTargetDropEvent.acceptDrop(2);
            try {
                Variable variable = (Variable)transferable.getTransferData(ElementReferenceTransferable.variableReferenceFlavor);
                if (this.variables.contains(variable)) {
                    if (this.variablePosition > this.variables.indexOf(variable)) {
                        --this.variablePosition;
                    }
                    this.variables.remove(variable);
                }
                this.variables.add(this.variablePosition, variable);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.err.println("Error: VariableGroupEditor.java: drop(java.awt.dnd.DropTargetDropEvent): " + unsupportedFlavorException.toString());
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                System.err.println("Error: VariableGroupEditor.java: drop(java.awt.dnd.DropTargetDropEvent): " + iOException.toString());
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Throwable throwable) {
                System.err.println("Error: VariableGroupEditor.java: drop(java.awt.dnd.DropTargetDropEvent): " + throwable.toString());
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work.", throwable);
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            System.err.println("Error: VariableGroupEditor.java: drop(java.awt.dnd.DropTargetDropEvent): rejected drop");
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
        this.lineLocation = -1;
        this.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.variableReferenceFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.lineLocation = -1;
        this.repaint();
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        this.refreshGUI();
    }

    public void stateChanging(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }
}

