/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.progress.ProgressPane;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;

public class StoreElementProgressPane
extends ProgressPane {
    private Element m_element;
    private File m_file;
    private Dictionary m_filnameToByteArrayMap;
    private boolean m_wasSuccessful = false;

    public StoreElementProgressPane(String string, String string2) {
        super(string, string2);
    }

    public boolean wasSuccessful() {
        return this.m_wasSuccessful;
    }

    public void construct() throws ProgressCancelException {
        this.m_wasSuccessful = false;
        try {
            this.m_element.store(this.m_file, (ProgressObserver)this, this.m_filnameToByteArrayMap);
            this.m_wasSuccessful = true;
        }
        catch (ProgressCancelException progressCancelException) {
            throw progressCancelException;
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(I18n.getString("bugErrorOccurred"));
            if (throwable instanceof IOException) {
                stringBuffer.append(I18n.getString("bugLackSpace"));
            }
            stringBuffer.append(I18n.getString("bugSorryNote") + "\n\n");
            AuthoringTool.getInstance().showSaveErrorDialog(stringBuffer.toString(), throwable);
        }
    }

    public void setElement(Element element) {
        this.m_element = element;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public void setFilnameToByteArrayMap(Dictionary dictionary) {
        this.m_filnameToByteArrayMap = dictionary;
    }
}

