/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorComponent
extends JPanel {
    protected AuthoringTool authoringTool;
    protected JPanel editorPanel = new JPanel();
    protected EditLabel editLabel = new EditLabel();
    protected AbstractAction backAction;
    protected AbstractAction forwardAction;
    protected AbstractAction editSceneAction;
    protected Editor activeEditor = null;
    protected Method activeEditorSetMethod = null;
    protected HashMap cachedEditors = new HashMap();
    protected EditStack editStack = new EditStack();
    protected final ChildrenListener deletionListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent childrenEvent) {
        }

        public void childrenChanged(ChildrenEvent childrenEvent) {
            if (childrenEvent.getChangeType() == 3 && childrenEvent.getChild() == EditorComponent.this.getElementBeingEdited()) {
                EditorComponent.this.editElement(null);
                childrenEvent.getParent().removeChildrenListener(this);
            }
        }
    };

    public Editor loadEditor(Class clazz) {
        Editor editor = null;
        if (clazz != null && (editor = (Editor)this.cachedEditors.get(clazz)) == null) {
            try {
                editor = EditorUtilities.getEditorFromClass(clazz);
                if (editor == null) {
                    AuthoringTool.getInstance().showErrorDialog("Can't create editor of type " + clazz.getName(), null);
                } else {
                    this.cachedEditors.put(clazz, editor);
                    this.authoringTool.addAuthoringToolStateListener(editor);
                    editor.setAuthoringTool(this.authoringTool);
                }
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error while creating editor of type " + clazz.getName(), throwable);
            }
        }
        return editor;
    }

    public void editElement(Element element) {
        this.editElement(element, true);
    }

    protected void editElement(Element element, boolean bl) {
        if (element == null) {
            this.editElement(null, null, bl);
        } else {
            Class clazz = EditorUtilities.getBestEditor(element.getClass());
            if (clazz == null) {
                AuthoringTool.getInstance().showErrorDialog("No editor found for " + element.getClass().getName(), null);
            }
            this.editElement(element, clazz, bl);
        }
    }

    protected void editElement(Element element, Class clazz, boolean bl) {
        Editor editor;
        if (this.getElementBeingEdited() != null && this.getElementBeingEdited().getParent() != null) {
            this.getElementBeingEdited().getParent().removeChildrenListener(this.deletionListener);
        }
        if (this.activeEditor != (editor = this.loadEditor(clazz))) {
            if (this.activeEditor != null) {
                try {
                    this.activeEditorSetMethod.invoke((Object)this.activeEditor, new Object[]{null});
                }
                catch (InvocationTargetException invocationTargetException) {
                    AuthoringTool.getInstance().showErrorDialog("Error while cleaning editor.", invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    AuthoringTool.getInstance().showErrorDialog("Error while cleaning editor.", illegalAccessException);
                }
            }
            this.editorPanel.removeAll();
            this.activeEditor = editor;
            if (this.activeEditor != null) {
                this.activeEditorSetMethod = EditorUtilities.getSetMethodFromClass(clazz);
                this.editorPanel.add("Center", this.activeEditor.getJComponent());
            } else {
                this.activeEditorSetMethod = null;
            }
            this.editorPanel.revalidate();
            this.editorPanel.repaint();
        }
        if (this.activeEditor != null && this.activeEditor.getObject() != element) {
            try {
                this.activeEditorSetMethod.invoke((Object)this.activeEditor, element);
                if (bl && element != null) {
                    this.editStack.push(new EditItem(element, clazz));
                    this.updateActions();
                }
                if (element != null) {
                    this.editLabel.setText(AuthoringToolResources.getReprForValue(element));
                    if (element.getParent() != null) {
                        element.getParent().addChildrenListener(this.deletionListener);
                    }
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                AuthoringTool.getInstance().showErrorDialog("Error while setting up editor.", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                AuthoringTool.getInstance().showErrorDialog("Error while setting up editor.", illegalAccessException);
            }
        }
    }

    public Element getElementBeingEdited() {
        if (this.activeEditor != null) {
            return (Element)this.activeEditor.getObject();
        }
        return null;
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public boolean canGoBack() {
        return this.editStack.getCurrentUndoableRedoableIndex() > 0;
    }

    public boolean canGoForward() {
        return this.editStack.getCurrentUndoableRedoableIndex() != this.editStack.size() - 1;
    }

    protected void updateActions() {
        this.backAction.setEnabled(this.canGoBack());
        this.forwardAction.setEnabled(this.canGoForward());
        this.editSceneAction.setEnabled(this.getElementBeingEdited() != this.authoringTool.getWorld());
    }

    class HighlightButton
    extends JButton {
        protected Border highlightBorder = new HighlightBorder(true);
        protected Border pressedBorder = new HighlightBorder(false);
        protected Insets insets = new Insets(4, 4, 4, 4);

        public HighlightButton() {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setBorder(null);
            this.getModel().addChangeListener(new ChangeListener(this, EditorComponent.this){
                private final /* synthetic */ EditorComponent val$this$0;
                private final /* synthetic */ HighlightButton this$1;
                {
                    this.this$1 = highlightButton;
                    this.val$this$0 = editorComponent;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.updateBorder();
                }
            });
        }

        public Insets getInsets() {
            return this.insets;
        }

        protected void updateBorder() {
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    if (this.getModel().isArmed()) {
                        this.setBorder(this.pressedBorder);
                    } else {
                        this.setBorder(this.highlightBorder);
                    }
                } else if (this.getModel().isRollover()) {
                    this.setBorder(this.highlightBorder);
                } else {
                    this.setBorder(null);
                }
            } else {
                this.setBorder(null);
            }
        }

        class HighlightBorder
        extends AbstractBorder {
            protected Color highlightColor = Color.white;
            protected Color shadowColor = Color.gray;
            protected boolean raised;

            public HighlightBorder(boolean bl) {
                this.raised = bl;
            }

            public void setRaised(boolean bl) {
                this.raised = bl;
            }

            public boolean isRaised() {
                return this.raised;
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Color color = graphics.getColor();
                if (this.raised) {
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.drawLine(n, n2, n, n2 + n4 - 1);
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                } else {
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(n, n2, n + n3 - 2, n2);
                    graphics.drawLine(n, n2, n, n2 + n4 - 2);
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                }
                graphics.setColor(color);
            }

            public Insets getBorderInsets(Component component) {
                return new Insets(1, 1, 1, 1);
            }

            public Insets getBorderInsets(Component component, Insets insets) {
                insets.bottom = 1;
                insets.right = 1;
                insets.top = 1;
                insets.left = 1;
                return insets;
            }

            public boolean isBorderOpaque() {
                return true;
            }
        }
    }

    public class EditLabel
    extends JLabel
    implements DropTargetListener {
        public EditLabel() {
            int n = 12;
            this.setFont(new Font("SansSerif", 1, n));
            this.setForeground(Color.black);
            this.setText("drop here");
            this.setOpaque(false);
            this.setDropTarget(new DropTarget(this, this));
        }

        protected void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.elementReferenceFlavor)) {
                dropTargetDragEvent.acceptDrag(2);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ResponsePrototypeReferenceTransferable.responsePrototypeReferenceFlavor)) {
                dropTargetDragEvent.acceptDrag(2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    Element element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                    EditorComponent.this.editElement(element);
                    dropTargetDropEvent.dropComplete(true);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                    EditorComponent.this.editElement(callToUserDefinedResponsePrototype.getActualResponse());
                    dropTargetDropEvent.dropComplete(true);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                    EditorComponent.this.editElement(callToUserDefinedQuestionPrototype.getActualQuestion());
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work.", throwable);
                dropTargetDropEvent.dropComplete(false);
            }
        }
    }

    class EditItem
    implements UndoableRedoable {
        protected Element element;
        protected Class editorClass;

        public EditItem(Element element, Class clazz) {
            this.element = element;
            this.editorClass = clazz;
        }

        public void undo() {
        }

        public void redo() {
        }

        public Object getAffectedObject() {
            return this.element;
        }

        public Object getContext() {
            return EditorComponent.this;
        }

        public Element getElement() {
            return this.element;
        }

        public Class getEditorClass() {
            return this.editorClass;
        }
    }

    class EditStack
    extends DefaultUndoRedoStack {
        EditStack() {
        }

        public UndoableRedoable undo() {
            UndoableRedoable undoableRedoable = super.undo();
            UndoableRedoable undoableRedoable2 = EditorComponent.this.editStack.getCurrentUndoableRedoable();
            if (undoableRedoable != null) {
                EditorComponent.this.editElement(((EditItem)undoableRedoable2).getElement(), ((EditItem)undoableRedoable2).getEditorClass(), false);
            }
            return undoableRedoable;
        }

        public UndoableRedoable redo() {
            UndoableRedoable undoableRedoable = super.redo();
            if (undoableRedoable != null) {
                EditorComponent.this.editElement(((EditItem)undoableRedoable).getElement(), ((EditItem)undoableRedoable).getEditorClass(), false);
            }
            return undoableRedoable;
        }
    }
}

