/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceGenerator;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StrUtilities {
    public static final String STR_FONT = "ISO-8859-1";
    public static final String submitError = "http://milanesa.ime.usp.br/ivprog/rb/submit.php";
    public static final String submitErrorTrace = "";

    public static String readFromURL(Applet applet, String string) {
        InputStream inputStream = null;
        URL uRL = null;
        Object var4_4 = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL(applet.getCodeBase().toString() + "/" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.err.println("Error: leitura URL: applet=" + applet + ", " + string + ": not an URL: " + malformedURLException2);
                return submitErrorTrace;
            }
        }
        try {
            inputStream = uRL.openStream();
            return StrUtilities.inputStream2String(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Error: reading from URL: " + string + ": " + iOException.toString());
            return submitErrorTrace;
        }
    }

    public static String outputStream2string(OutputStream outputStream) {
        String string = submitErrorTrace;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.writeTo(outputStream);
            string = new String(byteArrayOutputStream.toByteArray(), STR_FONT);
        }
        catch (Exception exception) {
            System.err.println("Error: StrUtilities.outputStream2string(): " + exception.getMessage());
        }
        return "<" + string + ">";
    }

    public static String file2String(File file) {
        try {
            if (!file.isFile()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            return StrUtilities.inputStream2String(fileInputStream);
        }
        catch (Exception exception) {
            System.err.println("Error: reading from: " + file + ": " + exception.toString());
            return null;
        }
    }

    public static String inputStream2String(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringWriter stringWriter = new StringWriter();
            int n = 8192;
            char[] cArray = new char[n];
            try {
                int n2;
                while ((n2 = inputStreamReader.read(cArray, 0, n)) != -1) {
                    stringWriter.write(cArray, 0, n2);
                }
                stringWriter.close();
                inputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Error: reading from: " + inputStream + ": " + exception);
                return null;
            }
            inputStream.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            System.err.println("Error: reading from: " + inputStream + ": " + exception.toString());
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Error: reading from inputStream=" + inputStream + ": " + iOException.toString());
            }
            return null;
        }
    }

    public static String getWorldXml() {
        try {
            World world = AuthoringTool.getInstance().getWorld();
            String string = AppletWorldStorer.internalStore(world, 1, new DefaultReferenceGenerator(world));
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return submitErrorTrace;
        }
    }

    public static int sendDataTo(String string) {
        try {
            String string2 = string;
            String string3 = submitError;
            URL uRL = new URL(string3);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            String string4 = StrUtilities.getWorldXml();
            string2 = string2 + "File with problem:\n" + string4;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream(), STR_FONT);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), STR_FONT);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string5 = submitErrorTrace;
                String string6 = submitErrorTrace;
                while ((string6 = bufferedReader.readLine()) != null) {
                    string5 = string5 + string6;
                }
                inputStreamReader.close();
                System.out.println("StrUtilities.java: sendDataTo(...): send data to URL_COM=" + string3);
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
                return -2;
            }
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
            return -1;
        }
        return 1;
    }

    public static String getDataFrom(String string) {
        String string2 = submitErrorTrace;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = submitErrorTrace;
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3;
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            System.err.println("Error: StrUtilities.java: getDataFrom(" + string + "): " + exception.getMessage());
        }
        return string2;
    }

    public static int submitPOST(String string) {
        String string2 = submitErrorTrace;
        try {
            string2 = "MA_POST_Value=0&MA_POST_Archive=" + string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StrUtilities.sendDataTo(string2);
    }

    public static String getItem(String string, String string2, int n) {
        String string3 = submitErrorTrace;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    public static String getItem(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
        int n = 0;
        int n2 = 0;
        if (string2 == null || string2 == submitErrorTrace) {
            return submitErrorTrace;
        }
        n = string2.length();
        if (stringTokenizer.countTokens() < 2) {
            return submitErrorTrace;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n3;
                String string3;
                String string4 = stringTokenizer.nextToken();
                n2 = string4.length();
                if (n2 < n || !(string3 = string4.substring(n2 - n, n2)).equals(string2) || !stringTokenizer.hasMoreTokens()) continue;
                string4 = stringTokenizer.nextToken();
                n2 = string4.length();
                for (n3 = 0; string4.charAt(n3) != ',' && n3 < n2; ++n3) {
                }
                return string4.substring(0, n3);
            }
            catch (Exception exception) {
                System.err.println("Error: StrUtilities.java: getItem(" + string + "," + string2 + "): len=" + n2 + " lenName=" + n + ": " + exception.toString());
            }
        }
        return submitErrorTrace;
    }

    public static String getComponentNameTitle(Object object) {
        Object var1_1 = null;
        if (!(object instanceof Component) || object == null) {
            System.err.println("Error: StrUtilities.java: getComponentNameTitle(Object obj): obj must be Component in order to get these informations");
            return submitErrorTrace + object;
        }
        String string = submitErrorTrace;
        String string2 = object.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string = string + " : " + StrUtilities.getItem(string3, ",", 1);
                string = string + " : " + StrUtilities.getItem(string3, "title");
            }
        }
        return string;
    }

    public static String getComponentName(Object object) {
        Object var1_1 = null;
        if (object == null) {
            System.err.println("Error: StrUtilities.java: getComponentName(Object obj): obj must be non empty");
            return "<>";
        }
        String string = submitErrorTrace;
        String string2 = object.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public static Container findMainContainer(Object object, boolean bl) {
        Component component = null;
        Container container = null;
        try {
            component = (Component)object;
            container = component.getParent();
            if (bl) {
                System.err.println("StrUtilities.findMainContainer(Component): trace the calling stack of " + StrUtilities.getComponentName(component));
            }
            while (!(container instanceof Applet) && !(container instanceof Frame)) {
                if (bl) {
                    System.err.println(" - " + StrUtilities.getComponentName(container));
                }
                container = container.getParent();
            }
        }
        catch (Exception exception) {
            System.err.println("StrUtilities.findMainContainer(Component): error during tracing the calling stack: " + exception.toString());
            return null;
        }
        if (bl) {
            System.err.println(" - " + StrUtilities.getComponentName(container));
        }
        return container;
    }

    public static String str2unicode(String string) {
        if (string == null) {
            return null;
        }
        if (string == submitErrorTrace) {
            return submitErrorTrace;
        }
        int n = string.length();
        String string2 = submitErrorTrace;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string3 = Character.toString(c);
            string2 = string2 + string3;
        }
        return string2;
    }

    public static void createDialog(String string, JFrame jFrame, String string2) {
        final JDialog jDialog = new JDialog((Frame)jFrame, string);
        final JOptionPane jOptionPane = new JOptionPane();
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextArea = new JTextArea(30, 150);
        jTextArea.setText(string2);
        jScrollPane.setViewportView(jTextArea);
        jScrollPane.setAutoscrolls(true);
        jOptionPane.setMessage(I18n.getString("iLM_debug"));
        jOptionPane.add(jScrollPane);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && string.equals("value")) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        jDialog.setDefaultCloseOperation(0);
        jDialog.setContentPane(jOptionPane);
        jDialog.setSize(398, 498);
        jTextArea.setEditable(true);
        jDialog.setSize(400, 500);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("StrUtilities.createDialog(): closing event " + windowEvent);
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }
}

