/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.event.MessageEvent;
import edu.cmu.cs.stage3.alice.core.event.MessageListener;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.alice.scripting.Interpreter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class World
extends ReferenceFrame {
    private static int staticCont = 0;
    public int cont = staticCont++;
    private static boolean HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
    private Vector m_capsulePropertyValuePairs = new Vector();
    private Hashtable m_capsuleElements = new Hashtable();
    private Interpreter m_interpreter;
    private Vector m_messageListeners = new Vector();
    private MessageListener[] m_messageListenerArray = null;
    private Sandbox m_currentSandbox = null;
    private Clock m_clock = null;
    private boolean m_isRunning = false;

    public World() {
        System.out.println("World.java: World(): #" + this.cont);
    }

    public Clock getClock() {
        return this.m_clock;
    }

    public void setClock(Clock clock) {
        this.m_clock = clock;
    }

    private Interpreter getInterpreter() {
        return this.m_interpreter;
    }

    public Code compile(Object object, CompileType compileType) {
        return this.getInterpreter().compile(object, compileType);
    }

    public Object eval(Code code) {
        return this.getInterpreter().eval(code);
    }

    public void exec(Code code) {
        this.getInterpreter().exec(code);
    }

    protected void internalRelease(int n) {
    }

    protected void nameValueChanged(String string) {
    }

    protected void propertyChanged(Property property, Object object) {
    }

    public void sendMessage(Element element, String string, Transformable transformable, Transformable transformable2, long l) {
        MessageEvent messageEvent = new MessageEvent(element, string, transformable, transformable2, l);
        for (int i = 0; i < this.m_messageListeners.size(); ++i) {
            MessageListener messageListener = (MessageListener)this.m_messageListeners.elementAt(i);
            messageListener.messageSent(messageEvent);
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.m_messageListeners.addElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.m_messageListeners.removeElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public MessageListener[] getMessageListeners() {
        if (this.m_messageListenerArray == null) {
            this.m_messageListenerArray = new MessageListener[this.m_messageListeners.size()];
            this.m_messageListeners.copyInto(this.m_messageListenerArray);
        }
        return this.m_messageListenerArray;
    }

    public void preserve() {
        this.m_capsulePropertyValuePairs.clear();
        this.m_capsuleElements.clear();
        Element[] elementArray = this.getDescendants();
        int n = elementArray != null ? elementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.m_capsuleElements.put(elementArray[i], Boolean.TRUE);
            Property[] propertyArray = elementArray[i].getProperties();
            int n2 = propertyArray != null ? propertyArray.length : 0;
            for (int j = 0; j < n2; ++j) {
                Object[] objectArray = new Object[]{propertyArray[j], propertyArray[j].get()};
                this.m_capsulePropertyValuePairs.addElement(objectArray);
            }
        }
    }

    public void restore() {
        Object[] objectArray;
        Enumeration enumeration = this.m_capsulePropertyValuePairs.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Property property = (Property)objectArray[0];
            Object object = objectArray[1];
            property.set(object);
        }
        objectArray = this.getDescendants();
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (this.m_capsuleElements.get(objectArray[i]) == null) {
                ((Element)objectArray[i]).removeFromParent();
            }
            if (this.m_capsuleElements.get(objectArray[i]) != null) continue;
            ((Element)objectArray[i]).release();
        }
    }

    public Sandbox getCurrentSandbox() {
        return this.m_currentSandbox;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void start() {
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_disableListening();
        }
        this.started(this, this.m_clock.getTime());
        this.m_isRunning = true;
    }

    public void stop() {
        this.m_isRunning = false;
        this.stopped(this, this.m_clock.getTime());
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_enableListening();
        }
    }

    public void schedule() {
        this.m_currentSandbox = this;
        this.scheduleBehaviors(this.m_clock.getTime());
        this.m_currentSandbox = null;
    }

    static {
        System.out.println("World.java: static: #" + staticCont);
        try {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = !JAlice.isApplet() ? Boolean.getBoolean("alice.isPropetryListeningDisabledWhileWorldIsRunning") : false;
        }
        catch (Throwable throwable) {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
            throwable.printStackTrace();
        }
    }
}

