/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.response.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResponsePrintViewController
extends DnDGroupingPanel
implements GUIElement {
    protected Print printStatement;
    protected JPanel subPanel = new GroupingPanel();
    protected JLabel printPrefixLabel = new JLabel("Print: ");
    protected JLabel printSuffixLabel = new JLabel("");
    protected HashMap guiMap = new HashMap();
    protected MouseListener mouseListener = new MouseListener();
    protected PropertyListener commentedListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            if (propertyEvent.getValue().equals(Boolean.TRUE)) {
                ResponsePrintViewController.this.setEnabled(false);
            } else {
                ResponsePrintViewController.this.setEnabled(true);
            }
            ResponsePrintViewController.this.revalidate();
            ResponsePrintViewController.this.repaint();
        }
    };
    protected PropertyListener updateListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            ResponsePrintViewController.this.refreshGUI();
        }
    };
    protected boolean sleeping = false;

    public ResponsePrintViewController() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 3, 2));
        this.subPanel.setLayout(new GridBagLayout());
        this.subPanel.setOpaque(false);
        this.subPanel.setBorder(null);
        this.addMouseListener(this.mouseListener);
        this.grip.addMouseListener(this.mouseListener);
        this.subPanel.addMouseListener(this.mouseListener);
    }

    public Print get() {
        return this.printStatement;
    }

    public void set(Print print) {
        super.reset();
        this.stopListening();
        this.printStatement = print;
        if (this.printStatement != null) {
            this.setTransferable(TransferableFactory.createTransferable(print));
            this.setBackground(AuthoringToolResources.getColor("Print"));
            this.add((Component)this.subPanel, "Center");
            this.addDragSourceComponent(this.subPanel);
            this.startListening();
        }
        this.refreshGUI();
    }

    protected void startListening() {
        if (this.printStatement != null) {
            this.printStatement.text.addPropertyListener(this.updateListener);
            this.printStatement.object.addPropertyListener(this.updateListener);
        }
    }

    protected void stopListening() {
        if (this.printStatement != null) {
            this.printStatement.text.removePropertyListener(this.updateListener);
            this.printStatement.object.removePropertyListener(this.updateListener);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.subPanel.getComponents();
        int n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    public void goToSleep() {
        this.stopListening();
        this.sleeping = true;
    }

    public void wakeUp() {
        this.startListening();
        this.sleeping = false;
    }

    public void clean() {
        this.stopListening();
        this.printStatement = null;
        this.setTransferable(null);
        this.removeAll();
    }

    public void die() {
        this.clean();
    }

    public void release() {
        super.release();
        GUIFactory.releaseGUI(this);
    }

    public void refreshGUI() {
        this.subPanel.removeAll();
        if (this.printStatement != null) {
            String string = AuthoringToolResources.getFormat(this.printStatement.getClass());
            FormatTokenizer formatTokenizer = new FormatTokenizer(string);
            if (formatTokenizer.hasMoreTokens()) {
                this.printPrefixLabel.setText(formatTokenizer.nextToken());
            } else {
                this.printPrefixLabel.setText("");
            }
            String string2 = null;
            while (formatTokenizer.hasMoreTokens()) {
                string2 = formatTokenizer.nextToken();
            }
            if (!(string2 == null || string2.startsWith("<") && string2.endsWith(">"))) {
                this.printSuffixLabel.setText(string2);
            } else {
                this.printSuffixLabel.setText("");
            }
            int n = 0;
            if (this.printStatement.text.get() == null) {
                boolean bl = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.object);
                JComponent jComponent = GUIFactory.getPropertyViewController(this.printStatement.object, true, true, bl, new SetPropertyImmediatelyFactory(this.printStatement.object));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)jComponent, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else if (this.printStatement.object.get() == null) {
                boolean bl = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent jComponent = GUIFactory.getPropertyViewController(this.printStatement.text, true, true, bl, new SetPropertyImmediatelyFactory(this.printStatement.text));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)jComponent, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                boolean bl = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent jComponent = GUIFactory.getPropertyViewController(this.printStatement.text, true, true, bl, new SetPropertyImmediatelyFactory(this.printStatement.text));
                bl = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent jComponent2 = GUIFactory.getPropertyViewController(this.printStatement.object, true, true, bl, new SetPropertyImmediatelyFactory(this.printStatement.object));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)jComponent, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
                this.subPanel.add((Component)jComponent2, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.subPanel.add(Box.createGlue(), new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    class MouseListener
    extends CustomMouseAdapter {
        MouseListener() {
        }

        public void popupResponse(MouseEvent mouseEvent) {
            Vector vector = ElementPopupUtilities.getDefaultStructure(ResponsePrintViewController.this.printStatement);
            if (vector != null && !vector.isEmpty()) {
                ElementPopupUtilities.createAndShowElementPopupMenu(ResponsePrintViewController.this.printStatement, vector, ResponsePrintViewController.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

