/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExpandablePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObjectArrayPropertyPanel
extends ExpandablePanel {
    protected ObjectArrayProperty objectArrayProperty;
    protected JPanel contentPanel = new JPanel();
    protected AuthoringTool authoringTool;
    protected RefreshListener refreshListener = new RefreshListener();

    public ObjectArrayPropertyPanel(String string, AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.guiInit(string);
    }

    private void guiInit(String string) {
        this.setTitle(string);
        this.contentPanel.setLayout(new GridBagLayout());
        this.setContent(this.contentPanel);
        this.setOpaque(false);
        this.contentPanel.setOpaque(false);
    }

    public void setObjectArrayProperty(ObjectArrayProperty objectArrayProperty) {
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.removeObjectArrayPropertyListener(this.refreshListener);
        }
        this.objectArrayProperty = objectArrayProperty;
        if (objectArrayProperty != null) {
            objectArrayProperty.addObjectArrayPropertyListener(this.refreshListener);
        }
        this.refreshGUI();
    }

    public void refreshGUI() {
        this.contentPanel.removeAll();
        if (this.objectArrayProperty != null) {
            int n = 0;
            for (int i = 0; i < this.objectArrayProperty.size(); ++i) {
                Object object = this.objectArrayProperty.get(i);
                JComponent jComponent = GUIFactory.getGUI(object);
                if (jComponent != null) {
                    this.contentPanel.add((Component)jComponent, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                    continue;
                }
                AuthoringTool.getInstance().showErrorDialog(I18n.getString("viewCOAPunableObj") + ": " + object, null);
            }
            Component component = Box.createGlue();
            this.contentPanel.add(component, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    protected class RefreshListener
    implements ObjectArrayPropertyListener {
        protected RefreshListener() {
        }

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            ObjectArrayPropertyPanel.this.refreshGUI();
        }
    }
}

