/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.util.StringTypePair;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TypeChooser
extends JPanel {
    private Class type;
    private ButtonGroup buttonGroup;
    private HashMap typeMap = new HashMap();
    private HashSet changeListeners = new HashSet();
    private JRadioButton numberButton = new JRadioButton(I18n.getString("constantNumber"));
    private JRadioButton booleanButton = new JRadioButton(I18n.getString("constantBoolean"));
    private JRadioButton objectButton = new JRadioButton(I18n.getString("constantObject"));
    private JRadioButton otherButton = new JRadioButton(I18n.getString("other") + "...");
    private JComboBox otherCombo = new JComboBox();
    private CheckForValidityCallback okButtonCallback;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$core$Model;
    static /* synthetic */ Class class$java$lang$String;

    public TypeChooser(CheckForValidityCallback checkForValidityCallback) {
        this.otherCombo.setEditable(true);
        this.okButtonCallback = checkForValidityCallback;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.numberButton, gridBagConstraints);
        this.add((Component)this.booleanButton, gridBagConstraints);
        this.add((Component)this.objectButton, gridBagConstraints);
        this.add((Component)this.otherButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.otherCombo, gridBagConstraints);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.numberButton);
        this.buttonGroup.add(this.booleanButton);
        this.buttonGroup.add(this.objectButton);
        this.buttonGroup.add(this.otherButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == TypeChooser.this.numberButton) {
                    TypeChooser.this.type = class$java$lang$Number == null ? (class$java$lang$Number = TypeChooser.class$("java.lang.Number")) : class$java$lang$Number;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.numberButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (actionEvent.getSource() == TypeChooser.this.booleanButton) {
                    TypeChooser.this.type = class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeChooser.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.booleanButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (actionEvent.getSource() == TypeChooser.this.objectButton) {
                    TypeChooser.this.type = class$edu$cmu$cs$stage3$alice$core$Model == null ? (class$edu$cmu$cs$stage3$alice$core$Model = TypeChooser.class$("edu.cmu.cs.stage3.alice.core.Model")) : class$edu$cmu$cs$stage3$alice$core$Model;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.objectButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (actionEvent.getSource() == TypeChooser.this.otherButton) {
                    TypeChooser.this.otherCombo.setEnabled(true);
                    TypeChooser.this.parseOtherType();
                }
            }
        };
        this.numberButton.addActionListener(actionListener);
        this.booleanButton.addActionListener(actionListener);
        this.objectButton.addActionListener(actionListener);
        this.otherButton.addActionListener(actionListener);
        StringTypePair[] stringTypePairArray = new StringTypePair[]{new StringTypePair("String", class$java$lang$String == null ? (class$java$lang$String = TypeChooser.class$("java.lang.String")) : class$java$lang$String)};
        int n = stringTypePairArray != null ? stringTypePairArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.typeMap.put(stringTypePairArray[i].getString().trim(), stringTypePairArray[i].getType());
            this.otherCombo.addItem(stringTypePairArray[i].getString());
        }
        ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                TypeChooser.this.parseOtherType();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                TypeChooser.this.parseOtherType();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TypeChooser.this.parseOtherType();
            }
        });
        this.numberButton.setSelected(true);
        this.type = class$java$lang$Number == null ? (class$java$lang$Number = TypeChooser.class$("java.lang.Number")) : class$java$lang$Number;
        this.otherCombo.setEnabled(false);
    }

    protected void parseOtherType() {
        String string = ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getText().trim();
        Class<?> clazz = (Class<?>)this.typeMap.get(string);
        if (clazz == null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        if (clazz == null) {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.red);
        } else {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.black);
        }
        if (this.type != clazz) {
            this.type = clazz;
            this.fireStateChanged(this.otherCombo);
        }
        this.checkTypeValidity();
    }

    private void checkTypeValidity() {
        this.okButtonCallback.setValidity(this, this.type != null);
    }

    public Class getType() {
        return this.type;
    }

    public void addCurrentTypeToList() {
        String string;
        if (this.otherButton.isSelected() && this.type != null && !this.typeMap.containsKey(string = ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getText().trim())) {
            this.otherCombo.addItem(string);
            this.typeMap.put(string, this.type);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged(Object object) {
        ChangeEvent changeEvent = new ChangeEvent(object);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

