/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ObjectArrayPropertyItemTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyItem;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyGUI;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ObjectArrayPropertyEditor
extends JPanel
implements PropertyListener,
DropTargetListener {
    protected ObjectArrayProperty objectArrayProperty;
    protected JButton newItemButton = new JButton(I18n.getString("newItem"));
    protected Class type = class$java$lang$Object == null ? (class$java$lang$Object = ObjectArrayPropertyEditor.class$("java.lang.Object")) : class$java$lang$Object;
    protected int lineLocation = -1;
    protected int position = 0;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectArrayPropertyEditor() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.newItemButton.setBackground(new Color(240, 240, 255));
        this.newItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPropertyEditor.this.objectArrayProperty.add(AuthoringToolResources.getDefaultValueForClass(ObjectArrayPropertyEditor.this.type));
                ObjectArrayPropertyEditor.this.newItemButton.scrollRectToVisible(ObjectArrayPropertyEditor.this.newItemButton.getBounds());
            }
        });
        this.setDropTarget(new DropTarget(this, this));
        this.refreshGUI();
    }

    public void setObjectArrayProperty(ObjectArrayProperty objectArrayProperty) {
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.removePropertyListener(this);
        }
        this.objectArrayProperty = objectArrayProperty;
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.addPropertyListener(this);
        }
        this.refreshGUI();
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }

    public void refreshGUI() {
        this.removeAll();
        if (this.objectArrayProperty != null) {
            Object[] objectArray = this.objectArrayProperty.getArrayValue();
            int n = 0;
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    SetPropertyImmediatelyFactory setPropertyImmediatelyFactory;
                    ObjectArrayPropertyItem objectArrayPropertyItem;
                    PropertyGUI propertyGUI;
                    Element element = this.objectArrayProperty.getOwner();
                    if (element == null || !(element.getRoot() instanceof World)) {
                        element = AuthoringTool.getInstance().getWorld();
                    }
                    if ((propertyGUI = GUIFactory.getPropertyGUI(objectArrayPropertyItem = new ObjectArrayPropertyItem(element, this.objectArrayProperty, i, this.type), true, false, setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(objectArrayPropertyItem))) != null) {
                        this.add((Component)propertyGUI, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                        continue;
                    }
                    AuthoringTool.getInstance().showErrorDialog("Unable to create gui for item: " + objectArrayPropertyItem, null);
                }
            }
            this.add((Component)this.newItemButton, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 2), 0, 0));
            this.newItemButton.setDropTarget(new DropTarget(this.newItemButton, this));
            Component component = Box.createGlue();
            this.add(component, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            component.setDropTarget(new DropTarget(component, this));
        }
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.lineLocation > -1) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.black);
            graphics.fillRect(0, this.lineLocation, rectangle.width, 2);
        }
    }

    protected void calculateLineLocation(int n) {
        int n2;
        int n3 = this.objectArrayProperty.size() + 1;
        int[] nArray = new int[n3];
        nArray[0] = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            Component component = this.getComponent(n2 - 1);
            nArray[n2] = component.getBounds().y + component.getBounds().height + 1;
        }
        n2 = -1;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            int n5 = Math.abs(n - nArray[i]);
            if (n5 >= n4) continue;
            n4 = n5;
            n2 = i;
        }
        this.position = n2;
        this.lineLocation = nArray[n2];
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
            int n = SwingUtilities.convertPoint((Component)dropTargetDragEvent.getDropTargetContext().getComponent(), (Point)dropTargetDragEvent.getLocation(), (Component)this).y;
            this.calculateLineLocation(n);
        } else {
            this.lineLocation = -1;
            dropTargetDragEvent.rejectDrag();
        }
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
            int n = SwingUtilities.convertPoint((Component)dropTargetDragEvent.getDropTargetContext().getComponent(), (Point)dropTargetDragEvent.getLocation(), (Component)this).y;
            this.calculateLineLocation(n);
        } else {
            this.lineLocation = -1;
            dropTargetDragEvent.rejectDrag();
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dropTargetDropEvent.acceptDrop(2);
            try {
                ObjectArrayPropertyItem objectArrayPropertyItem = (ObjectArrayPropertyItem)transferable.getTransferData(ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor);
                Object object = objectArrayPropertyItem.get();
                if (this.position > objectArrayPropertyItem.getIndex()) {
                    --this.position;
                }
                objectArrayPropertyItem.getObjectArrayProperty().remove(objectArrayPropertyItem.getIndex());
                objectArrayPropertyItem.getObjectArrayProperty().add(this.position, object);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error moving item.", throwable);
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
        this.lineLocation = -1;
        this.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.lineLocation = -1;
        this.repaint();
    }

    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        this.refreshGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

