/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.VariableProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class LoopNElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    private JLabel timesLabel;
    protected JComponent endInput;
    protected JComponent countInput;
    protected JComponent startInput;
    protected JComponent incrementInput;
    protected JComponent indexTile;
    protected NumberProperty m_start;
    protected NumberProperty m_increment;
    protected NumberProperty m_end;
    protected VariableProperty m_index;
    protected JLabel fromLabel;
    protected JLabel upToLabel;
    protected JLabel incrementLabel;
    protected JPanel complicatedPanel;
    protected JPanel simplePanel;
    protected JLabel complicatedEndBrace;
    protected JButton switchButton;
    protected String toComplicatedString = I18n.getString("commandT_showComplicated");
    protected String toSimpleString = I18n.getString("commandT_showSimple");
    protected boolean isComplicated = false;
    protected static String IS_COMPLICATED_LOOP_KEY = "edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor IS_COMPLICATED_LOOP_KEY";
    protected static BufferedImage countLoopBackgroundImage;
    protected static Dimension countLoopBackgroundImageSize;

    public LoopNElementPanel() {
        this.headerText = I18n.getString("commandT_For");
        this.backgroundColor = AuthoringToolResources.getColor("LoopNInOrder");
    }

    protected int countPreviousInstances(Component component, Object object) {
        if (component == null) {
            return 0;
        }
        if (component instanceof LoopNElementPanel) {
            return this.countPreviousInstances(component.getParent(), object) + 1;
        }
        return 0;
    }

    protected String getIndexName() {
        String string = I18n.getString("commandT_index");
        int n = this.countPreviousInstances(this.getParent(), this);
        if (n > 0) {
            string = string + String.valueOf(n);
        }
        return string;
    }

    protected void variableInit() {
        Object object;
        super.variableInit();
        if (this.m_element instanceof LoopNInOrder) {
            object = (LoopNInOrder)this.m_element;
            this.m_end = ((LoopNInOrder)object).end;
            this.m_start = ((LoopNInOrder)object).start;
            this.m_increment = ((LoopNInOrder)object).increment;
            this.m_index = ((LoopNInOrder)object).index;
            Variable variable = (Variable)this.m_index.getValue();
            variable.name.set(this.getIndexName());
        } else if (this.m_element instanceof LoopN) {
            object = (LoopN)this.m_element;
            this.m_end = ((LoopN)object).end;
            this.m_start = ((LoopN)object).start;
            this.m_increment = ((LoopN)object).increment;
            this.m_index = ((LoopN)object).index;
        }
        object = this.m_element.getDictionaryProperty(IS_COMPLICATED_LOOP_KEY);
        if (object instanceof Boolean) {
            this.isComplicated = (Boolean)object;
        }
        if (this.isComplicated) {
            this.switchButton.setText(this.toSimpleString);
        } else {
            this.switchButton.setText(this.toComplicatedString);
        }
    }

    protected void startListening() {
        super.startListening();
        if (this.m_end != null) {
            this.m_end.addPropertyListener(this);
        }
        this.listenToChildren(this.m_components);
    }

    protected void stopListening() {
        super.stopListening();
        if (this.m_end != null) {
            this.m_end.removePropertyListener(this);
        }
        this.stopListenToChildren(this.m_components);
    }

    protected void listenToChildren(ObjectArrayProperty objectArrayProperty) {
        if (objectArrayProperty != null) {
            objectArrayProperty.addObjectArrayPropertyListener(this);
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                Code code;
                if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                    code = (CompositeResponse)objectArrayProperty.get(i);
                    this.listenToChildren(code.componentResponses);
                    continue;
                }
                if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
                code = (Composite)objectArrayProperty.get(i);
                this.listenToChildren(((Composite)code).components);
            }
        }
    }

    protected void stopListenToChildren(ObjectArrayProperty objectArrayProperty) {
        if (objectArrayProperty != null) {
            objectArrayProperty.removeObjectArrayPropertyListener(this);
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                Code code;
                if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                    code = (CompositeResponse)objectArrayProperty.get(i);
                    this.stopListenToChildren(code.componentResponses);
                    continue;
                }
                if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
                code = (Composite)objectArrayProperty.get(i);
                this.stopListenToChildren(((Composite)code).components);
            }
        }
    }

    protected void removeAllListening() {
        super.removeAllListening();
        this.removeDragSourceComponent(this.timesLabel);
        this.removeDragSourceComponent(this.complicatedPanel);
        this.removeDragSourceComponent(this.simplePanel);
        this.removeDragSourceComponent(this.fromLabel);
        this.removeDragSourceComponent(this.upToLabel);
        this.removeDragSourceComponent(this.incrementLabel);
        this.removeDragSourceComponent(this.complicatedEndBrace);
    }

    protected void setDropTargets() {
        super.setDropTargets();
        this.timesLabel.setDropTarget(new DropTarget(this.timesLabel, this.componentElementPanel));
        this.complicatedPanel.setDropTarget(new DropTarget(this.complicatedPanel, this.componentElementPanel));
        this.simplePanel.setDropTarget(new DropTarget(this.simplePanel, this.componentElementPanel));
        this.fromLabel.setDropTarget(new DropTarget(this.fromLabel, this.componentElementPanel));
        this.upToLabel.setDropTarget(new DropTarget(this.upToLabel, this.componentElementPanel));
        this.complicatedEndBrace.setDropTarget(new DropTarget(this.complicatedEndBrace, this.componentElementPanel));
        this.incrementLabel.setDropTarget(new DropTarget(this.incrementLabel, this.componentElementPanel));
        this.indexTile.setDropTarget(new DropTarget(this.indexTile, this.componentElementPanel));
    }

    public void setHeaderLabel() {
        int n;
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
            if (CompositeElementEditor.IS_JAVA) {
                if (this.isComplicated) {
                    this.headerLabel.setText(I18n.getString("command_for"));
                } else {
                    n = 0;
                    if (this.m_start != null) {
                        n = this.m_start.intValue();
                    }
                    this.headerLabel.setText(I18n.getString("command_for") + this.getIndexName() + "=" + n + "; " + this.getIndexName() + "<");
                }
            }
        }
        if (this.timesLabel != null) {
            if (this.m_end.getNumberValue() != null && this.m_end.getNumberValue().intValue() == 1) {
                this.timesLabel.setText(I18n.getString("commandT_time"));
            } else {
                this.timesLabel.setText(I18n.getString("commandT_times"));
            }
            if (CompositeElementEditor.IS_JAVA) {
                n = 1;
                if (this.m_increment != null) {
                    n = this.m_increment.intValue();
                }
                if (!this.isExpanded) {
                    if (n == 1) {
                        this.timesLabel.setText("; " + this.getIndexName() + "++) { " + this.getDots() + " }");
                    } else {
                        this.timesLabel.setText("; " + this.getIndexName() + "+=" + n + ") { " + this.getDots() + " }");
                    }
                } else if (n == 1) {
                    this.timesLabel.setText("; " + this.getIndexName() + "++) {");
                } else {
                    this.timesLabel.setText("; " + this.getIndexName() + "+=" + n + ") {");
                }
            }
        }
        if (this.fromLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.fromLabel.setText("=");
            } else {
                this.fromLabel.setText(I18n.getString("commandT_from"));
            }
        }
        if (this.upToLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.upToLabel.setText("; " + this.getIndexName() + "<");
            } else {
                this.upToLabel.setText(I18n.getString("commandT_upTo"));
            }
        }
        if (this.incrementLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.incrementLabel.setText("; " + this.getIndexName() + " +=");
            } else {
                this.incrementLabel.setText(I18n.getString("commandT_inc"));
            }
        }
        if (this.complicatedEndBrace != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.complicatedEndBrace.setText(") {");
            } else {
                this.complicatedEndBrace.setText("");
            }
        }
    }

    protected void generateGUI() {
        super.generateGUI();
        this.timesLabel = new JLabel();
        this.fromLabel = new JLabel();
        this.upToLabel = new JLabel();
        this.incrementLabel = new JLabel();
        this.complicatedEndBrace = new JLabel();
        this.complicatedPanel = new JPanel();
        this.complicatedPanel.setOpaque(false);
        this.complicatedPanel.setBorder(null);
        this.complicatedPanel.setLayout(new GridBagLayout());
        this.simplePanel = new JPanel();
        this.simplePanel.setOpaque(false);
        this.simplePanel.setBorder(null);
        this.simplePanel.setLayout(new GridBagLayout());
        this.switchButton = new JButton();
        this.switchButton.setPreferredSize(new Dimension(180, 21));
        this.switchButton.setBackground(new Color(240, 240, 255));
        this.switchButton.setMargin(new Insets(2, 2, 2, 2));
        this.switchButton.setForeground(new Color(90, 110, 110));
        this.switchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LoopNElementPanel.this.isComplicated) {
                    LoopNElementPanel.this.isComplicated = false;
                    LoopNElementPanel.this.switchButton.setText(LoopNElementPanel.this.toComplicatedString);
                    LoopNElementPanel.this.m_element.putDictionaryProperty(IS_COMPLICATED_LOOP_KEY, Boolean.FALSE);
                } else {
                    LoopNElementPanel.this.isComplicated = true;
                    LoopNElementPanel.this.switchButton.setText(LoopNElementPanel.this.toSimpleString);
                    LoopNElementPanel.this.m_element.putDictionaryProperty(IS_COMPLICATED_LOOP_KEY, Boolean.TRUE);
                }
                LoopNElementPanel.this.updateGUI();
            }
        });
    }

    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.timesLabel);
        this.addDragSourceComponent(this.complicatedPanel);
        this.addDragSourceComponent(this.simplePanel);
        this.addDragSourceComponent(this.fromLabel);
        this.addDragSourceComponent(this.upToLabel);
        this.addDragSourceComponent(this.complicatedEndBrace);
        this.addDragSourceComponent(this.incrementLabel);
    }

    protected void updateName() {
        Variable variable = (Variable)this.m_index.getValue();
        variable.name.set(this.getIndexName());
        this.complicatedPanel.remove(this.indexTile);
        this.indexTile = GUIFactory.getVariableDnDPanel((Variable)this.m_index.get());
        this.complicatedPanel.add((Component)this.indexTile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
    }

    protected boolean isTopOccurrance(Element element) {
        if (element == null) {
            return true;
        }
        if (element instanceof LoopN) {
            return false;
        }
        if (element instanceof LoopNInOrder) {
            return false;
        }
        return this.isTopOccurrance(element.getParent());
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    protected void setAllNames(ObjectArrayProperty objectArrayProperty, int n) {
        String string = I18n.getString("commandT_index");
        for (int i = 0; i < objectArrayProperty.size(); ++i) {
            Element element = null;
            if (objectArrayProperty.get(i) instanceof LoopNInOrder) {
                element = (Element)((LoopNInOrder)objectArrayProperty.get((int)i)).index.get();
            } else if (objectArrayProperty.get(i) instanceof LoopN) {
                element = (Element)((LoopN)objectArrayProperty.get((int)i)).index.get();
            }
            if (element != null) {
                element.name.set(string + "_#" + n);
            }
            if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                this.setAllNames(((CompositeResponse)objectArrayProperty.get((int)i)).componentResponses, n + 1);
                continue;
            }
            if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
            this.setAllNames(((Composite)objectArrayProperty.get((int)i)).components, n + 1);
        }
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        this.stopListening();
        this.startListening();
        if (this.isTopOccurrance(this.m_element.getParent())) {
            Variable variable = (Variable)this.m_index.getValue();
            variable.name.set(I18n.getString("commandT_index"));
            this.setAllNames(this.m_components, 2);
        }
    }

    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(this.m_end);
        this.countInput = GUIFactory.getPropertyViewController(this.m_end, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_end), setPropertyImmediatelyFactory);
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory2 = new SetPropertyImmediatelyFactory(this.m_start);
        this.startInput = GUIFactory.getPropertyViewController(this.m_start, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_start), setPropertyImmediatelyFactory2);
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory3 = new SetPropertyImmediatelyFactory(this.m_increment);
        this.incrementInput = GUIFactory.getPropertyViewController(this.m_increment, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_increment), setPropertyImmediatelyFactory3);
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory4 = new SetPropertyImmediatelyFactory(this.m_end);
        this.endInput = GUIFactory.getPropertyViewController(this.m_end, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_end), setPropertyImmediatelyFactory4);
        this.indexTile = GUIFactory.getVariableDnDPanel((Variable)this.m_index.get());
        this.setHeaderLabel();
        this.complicatedPanel.removeAll();
        this.complicatedPanel.add((Component)this.indexTile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.fromLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.startInput, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.upToLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.endInput, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.incrementLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.incrementInput, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.complicatedEndBrace, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.simplePanel.removeAll();
        this.simplePanel.add((Component)this.countInput, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.simplePanel.add((Component)this.timesLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.remove(this.glue);
        if (this.isComplicated) {
            this.headerPanel.add((Component)this.complicatedPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        } else {
            this.headerPanel.add((Component)this.simplePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        }
        this.headerPanel.add((Component)this.switchButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBackgroundImage(int n, int n2) {
        countLoopBackgroundImageSize.setSize(n, n2);
        countLoopBackgroundImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)countLoopBackgroundImage.getGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
    }

    static {
        countLoopBackgroundImageSize = new Dimension(-1, -1);
    }
}

