/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewNamedElementContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.TypeChooser;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.ElementPropertyViewController;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class NewNamedTypedElementContentPane
extends NewNamedElementContentPane {
    private static final int INSET = 8;
    private TypeChooser m_typeChooser;
    private PopupItemFactory factory;
    private Element context;
    private JPanel valuePanel;
    private JComponent placeholder;
    private JComponent pad;
    private JComponent valueComponent;
    private JComponent valuesComponent;
    protected JLabel valueLabel;
    private JComponent valueViewController;
    public JCheckBox makeCollectionCheckBox;
    private JComboBox collectionTypeCombo;
    private ObjectArrayPropertyEditor objectArrayPropertyEditor;
    private JScrollPane objectArrayScrollPane;
    private Variable m_variable;
    protected boolean listsOnly;
    protected boolean showValue;
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$core$List;
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$core$Array;

    protected void initVariables() {
        this.listsOnly = false;
        this.showValue = true;
    }

    protected void initTopComponents(GridBagConstraints gridBagConstraints) {
        super.initTopComponents(gridBagConstraints);
        this.initVariables();
        this.m_typeChooser = new TypeChooser(this.getValidityChecker());
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        this.valueLabel = new JLabel();
        this.valuesComponent = new JPanel();
        this.valuesComponent.setBorder(null);
        this.valuesComponent.setOpaque(false);
        this.valuesComponent.setLayout(new BorderLayout());
        this.valueComponent = new JPanel();
        this.valueComponent.setBorder(null);
        this.valueComponent.setOpaque(false);
        this.valueComponent.setLayout(new BorderLayout());
        this.m_variable = new Variable();
        this.factory = new SetPropertyImmediatelyFactory(this.m_variable.value);
        this.objectArrayPropertyEditor = new ObjectArrayPropertyEditor();
        this.objectArrayScrollPane = new JScrollPane(this.objectArrayPropertyEditor);
        this.objectArrayScrollPane.setPreferredSize(new Dimension(1, 150));
        this.makeCollectionCheckBox = new JCheckBox(I18n.getString("msgMakeA"));
        this.makeCollectionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.m_typeChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.collectionTypeCombo = new JComboBox();
        this.collectionTypeCombo.addItem(class$edu$cmu$cs$stage3$alice$core$List == null ? (class$edu$cmu$cs$stage3$alice$core$List = NewNamedTypedElementContentPane.class$("edu.cmu.cs.stage3.alice.core.List")) : class$edu$cmu$cs$stage3$alice$core$List);
        this.collectionTypeCombo.addItem(class$edu$cmu$cs$stage3$alice$core$Array == null ? (class$edu$cmu$cs$stage3$alice$core$Array = NewNamedTypedElementContentPane.class$("edu.cmu.cs.stage3.alice.core.Array")) : class$edu$cmu$cs$stage3$alice$core$Array);
        this.collectionTypeCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Class) {
                    String string = ((Class)object).getName();
                    object = string.substring(string.lastIndexOf(".") + 1);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.collectionTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.pad = new JPanel();
        this.placeholder = new JPanel();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.right = 0;
        this.add((Component)new JLabel(I18n.getString("msgType") + ":"), gridBagConstraints);
        gridBagConstraints.insets.right = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.m_typeChooser, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.layoutValuePanel();
        this.add((Component)this.valuePanel, gridBagConstraints);
    }

    public void reset(Element element) {
        super.reset(element);
        this.context = element;
        this.m_variable = new Variable();
        this.factory = new SetPropertyImmediatelyFactory(this.m_variable.value);
        this.layoutValuePanel();
    }

    public void preDialogShow(JDialog jDialog) {
        super.preDialogShow(jDialog);
        if (!this.getListsOnly()) {
            this.makeCollectionCheckBox.setSelected(false);
        }
    }

    public void postDialogShow(JDialog jDialog) {
        super.postDialogShow(jDialog);
    }

    public boolean isReadyToDispose(int n) {
        if (n == 0) {
            this.m_typeChooser.addCurrentTypeToList();
        } else {
            this.m_variable = n == 2 ? null : null;
        }
        return true;
    }

    public boolean getShowValue() {
        return this.showValue;
    }

    public boolean getListsOnly() {
        return this.listsOnly;
    }

    private void updateCollection() {
        Class clazz = this.m_typeChooser.getType();
        Class clazz2 = (Class)this.collectionTypeCombo.getSelectedItem();
        Collection collection = null;
        if (this.m_variable.value.get() != null && clazz2.isAssignableFrom(this.m_variable.value.get().getClass())) {
            collection = (Collection)this.m_variable.value.get();
            if (collection.valueClass.getClassValue() != clazz) {
                collection.values.clear();
                collection.valueClass.set(clazz);
            }
        } else {
            try {
                collection = (Collection)clazz2.newInstance();
            }
            catch (Exception exception) {
                AuthoringTool.getInstance().showErrorDialog(I18n.getString("msgCouldNotCollType") + ": " + clazz2, exception);
                collection = new List();
            }
            collection.valueClass.set(clazz);
            if (this.valueViewController instanceof PropertyViewController) {
                ((PropertyViewController)this.valueViewController).release();
                this.valueViewController = null;
            }
            this.m_variable.value.set(null);
            this.m_variable.valueClass.set(clazz2);
            this.m_variable.value.set(collection);
        }
        this.objectArrayPropertyEditor.setType(clazz);
        this.objectArrayPropertyEditor.setObjectArrayProperty(collection.values);
    }

    private void updateVariableValue() {
        Class clazz = this.m_typeChooser.getType();
        Object object = this.m_variable.value.get();
        if (object == null || !clazz.isAssignableFrom(object.getClass())) {
            if (this.valueViewController instanceof PropertyViewController) {
                ((PropertyViewController)this.valueViewController).release();
                this.valueViewController = null;
            }
            this.m_variable.value.set(null);
            this.m_variable.valueClass.set(clazz);
            this.m_variable.value.set(AuthoringToolResources.getDefaultValueForClass(clazz));
            this.valueViewController = GUIFactory.getPropertyViewController(this.m_variable.value, true, false, true, this.factory);
            if (this.valueViewController instanceof ElementPropertyViewController) {
                ((ElementPropertyViewController)this.valueViewController).setRoot(this.context.getRoot());
            }
        }
    }

    private void layoutValuePanel() {
        this.valuePanel.removeAll();
        if (this.listsOnly) {
            this.makeCollectionCheckBox.setSelected(true);
            this.collectionTypeCombo.setSelectedItem(class$edu$cmu$cs$stage3$alice$core$List == null ? (class$edu$cmu$cs$stage3$alice$core$List = NewNamedTypedElementContentPane.class$("edu.cmu.cs.stage3.alice.core.List")) : class$edu$cmu$cs$stage3$alice$core$List);
            this.makeCollectionCheckBox.setEnabled(false);
            this.collectionTypeCombo.setEnabled(false);
        } else {
            this.makeCollectionCheckBox.setSelected(false);
            this.makeCollectionCheckBox.setEnabled(true);
            this.collectionTypeCombo.setEnabled(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 8;
        if (this.showValue) {
            gridBagConstraints.insets.left = 8;
            gridBagConstraints.insets.right = 8;
            this.valuePanel.add((Component)this.valueLabel, gridBagConstraints);
            this.valuePanel.add((Component)this.valueComponent, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            this.valuePanel.add((Component)this.pad, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.right = 0;
            this.valuePanel.add((Component)this.makeCollectionCheckBox, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 8;
            gridBagConstraints.insets.right = 8;
            this.valuePanel.add((Component)this.collectionTypeCombo, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            this.valuePanel.add((Component)this.valuesComponent, gridBagConstraints);
        } else {
            gridBagConstraints.insets.right = 8;
            gridBagConstraints.weightx = 1.0;
            this.valuePanel.add((Component)this.pad, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            this.valuePanel.add((Component)this.makeCollectionCheckBox, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.valuePanel.add((Component)this.collectionTypeCombo, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            this.valuePanel.add((Component)this.placeholder, gridBagConstraints);
        }
        this.refreshValuePanel();
    }

    private void refreshValuePanel() {
        if (this.m_typeChooser.getType() != null) {
            if (this.makeCollectionCheckBox.isSelected()) {
                this.updateCollection();
            } else {
                this.updateVariableValue();
            }
        }
        this.valuesComponent.removeAll();
        this.valueComponent.removeAll();
        if (this.makeCollectionCheckBox.isSelected()) {
            this.valueLabel.setText(I18n.getString("msgValues") + ":");
            this.valueComponent.add((Component)this.placeholder, "Center");
            this.valuesComponent.add((Component)this.objectArrayScrollPane, "Center");
        } else {
            this.valueLabel.setText(I18n.getString("msgValues") + ":");
            if (this.valueViewController != null) {
                this.valueComponent.add((Component)this.valueViewController, "Center");
            }
            this.valuesComponent.add((Component)this.placeholder, "Center");
        }
        this.packDialog();
    }

    public void setListsOnly(boolean bl) {
        if (this.listsOnly != bl) {
            this.listsOnly = bl;
            this.layoutValuePanel();
        }
    }

    public void setShowValue(boolean bl) {
        if (this.showValue != bl) {
            this.showValue = bl;
            this.layoutValuePanel();
        }
    }

    public Variable getVariable() {
        if (this.m_variable == null) {
            return null;
        }
        if ((this.makeCollectionCheckBox.isSelected() || this.listsOnly) && this.m_variable.value.get() instanceof Collection) {
            this.m_variable.addChild((Collection)this.m_variable.value.get());
        }
        this.m_variable.name.set(this.getNameValue());
        return this.m_variable;
    }

    public Class getTypeValue() {
        return this.m_typeChooser.getType();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

