/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class Actions {
    public AbstractAction newWorldAction;
    public AbstractAction openWorldAction;
    public AbstractAction saveWorldAction;
    public AbstractAction saveWorldAsAction;
    public AbstractAction quitAction;
    public AbstractAction cutAction;
    public AbstractAction copyAction;
    public AbstractAction pasteAction;
    public AbstractAction undoAction;
    public AbstractAction redoAction;
    public AbstractAction aboutAction;
    public AbstractAction viewXmlAction;
    public AbstractAction viewHtmlAction;
    public AbstractAction playAction;
    public AbstractAction trashAction;
    public AbstractAction helpAction;
    public AbstractAction pauseWorldAction;
    public AbstractAction resumeWorldAction;
    public AbstractAction restartWorldAction;
    public AbstractAction stopWorldAction;
    protected AuthoringTool authoringTool;
    protected JAliceFrame jAliceFrame;
    protected LinkedList applicationActions = new LinkedList();
    public LinkedList renderActions = new LinkedList();

    public Actions(AuthoringTool authoringTool, JAliceFrame jAliceFrame) {
        this.authoringTool = authoringTool;
        this.jAliceFrame = jAliceFrame;
        this.actionInit();
        this.keyInit();
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    private void actionInit() {
        this.newWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.newWorld();
            }
        };
        this.openWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.openWorld();
            }
        };
        this.saveWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.saveWorld();
            }
        };
        this.saveWorldAsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.saveWorldAs();
            }
        };
        this.quitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.quit();
            }
        };
        this.cutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.pasteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.undoAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.getUndoRedoStack().undo();
            }
        };
        this.redoAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.getUndoRedoStack().redo();
            }
        };
        this.aboutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.showAbout();
            }
        };
        this.viewXmlAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.viewXml();
            }
        };
        this.viewHtmlAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.viewHtml();
            }
        };
        this.playAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.play();
            }
        };
        this.trashAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.helpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.pauseWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.pause();
            }
        };
        this.resumeWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.resume();
            }
        };
        this.restartWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.restartWorld();
            }
        };
        this.stopWorldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Actions.this.authoringTool.stopWorld();
            }
        };
        this.newWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        this.newWorldAction.putValue("ActionCommandKey", "newWorld");
        this.newWorldAction.putValue("MnemonicKey", new Integer(78));
        this.newWorldAction.putValue("Name", I18n.getString("mainMenu_New"));
        this.newWorldAction.putValue("ShortDescription", I18n.getString("msgAction_newProgram"));
        this.newWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("new"));
        this.applicationActions.add(this.newWorldAction);
        this.openWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.openWorldAction.putValue("ActionCommandKey", "openWorld");
        this.openWorldAction.putValue("MnemonicKey", new Integer(79));
        this.openWorldAction.putValue("Name", I18n.getString("msgAction_Open"));
        this.openWorldAction.putValue("ShortDescription", I18n.getString("msgAction_OpenE"));
        this.openWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("open"));
        this.applicationActions.add(this.openWorldAction);
        this.saveWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.saveWorldAction.putValue("ActionCommandKey", "saveWorld");
        this.saveWorldAction.putValue("MnemonicKey", new Integer(83));
        this.saveWorldAction.putValue("Name", I18n.getString("msgAction_Save"));
        this.saveWorldAction.putValue("ShortDescription", I18n.getString("msgAction_SaveE"));
        this.saveWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("save"));
        this.applicationActions.add(this.saveWorldAction);
        this.saveWorldAsAction.putValue("ActionCommandKey", "saveWorldAs");
        this.saveWorldAsAction.putValue("MnemonicKey", new Integer(118));
        this.saveWorldAsAction.putValue("Name", I18n.getString("msgAction_SaveAs"));
        this.saveWorldAsAction.putValue("ShortDescription", I18n.getString("msgAction_SaveAsE"));
        this.applicationActions.add(this.saveWorldAsAction);
        this.quitAction.putValue("ActionCommandKey", "quit");
        this.quitAction.putValue("MnemonicKey", new Integer(120));
        this.quitAction.putValue("Name", I18n.getString("msgAction_Exit"));
        this.quitAction.putValue("ShortDescription", I18n.getString("msgAction_ExitE"));
        this.applicationActions.add(this.quitAction);
        this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        this.cutAction.putValue("ActionCommandKey", "cut");
        this.cutAction.putValue("MnemonicKey", new Integer(116));
        this.cutAction.putValue("Name", I18n.getString("msgAction_Cut"));
        this.cutAction.putValue("ShortDescription", I18n.getString("msgAction_CutE"));
        this.cutAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("cut"));
        this.applicationActions.add(this.cutAction);
        this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        this.copyAction.putValue("ActionCommandKey", "copy");
        this.copyAction.putValue("MnemonicKey", new Integer(67));
        this.copyAction.putValue("Name", I18n.getString("msgAction_Copy"));
        this.copyAction.putValue("ShortDescription", I18n.getString("msgAction_CopyE"));
        this.copyAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("copy"));
        this.applicationActions.add(this.copyAction);
        this.pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.pasteAction.putValue("ActionCommandKey", "paste");
        this.pasteAction.putValue("MnemonicKey", new Integer(80));
        this.pasteAction.putValue("Name", I18n.getString("msgAction_Paste"));
        this.pasteAction.putValue("ShortDescription", I18n.getString("msgAction_PasteE"));
        this.pasteAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("paste"));
        this.applicationActions.add(this.pasteAction);
        this.undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        this.undoAction.putValue("ActionCommandKey", "undo");
        this.undoAction.putValue("MnemonicKey", new Integer(85));
        this.undoAction.putValue("Name", I18n.getString("msgAction_Undo"));
        this.undoAction.putValue("ShortDescription", I18n.getString("msgAction_UndoE"));
        this.undoAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("undo"));
        this.applicationActions.add(this.undoAction);
        this.redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
        this.redoAction.putValue("ActionCommandKey", "redo");
        this.redoAction.putValue("MnemonicKey", new Integer(82));
        this.redoAction.putValue("Name", I18n.getString("msgAction_Redo"));
        this.redoAction.putValue("ShortDescription", I18n.getString("msgAction_RedoE"));
        this.redoAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("redo"));
        this.applicationActions.add(this.redoAction);
        this.aboutAction.putValue("ActionCommandKey", "about");
        this.aboutAction.putValue("MnemonicKey", new Integer(65));
        this.aboutAction.putValue("Name", I18n.getString("msgAction_About"));
        this.aboutAction.putValue("ShortDescription", I18n.getString("msgAction_AboutE"));
        this.aboutAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("about"));
        this.applicationActions.add(this.aboutAction);
        this.viewXmlAction.putValue("ActionCommandKey", "view");
        this.viewXmlAction.putValue("MnemonicKey", new Integer(73));
        this.viewXmlAction.putValue("Name", I18n.getString("msgAction_View"));
        this.viewXmlAction.putValue("ShortDescription", I18n.getString("msgAction_ViewE"));
        this.applicationActions.add(this.viewXmlAction);
        this.viewHtmlAction.putValue("ActionCommandKey", "html");
        this.viewHtmlAction.putValue("MnemonicKey", new Integer(72));
        this.viewHtmlAction.putValue("Name", I18n.getString("msgAction_Html"));
        this.viewHtmlAction.putValue("ShortDescription", I18n.getString("msgAction_HtmlE"));
        this.applicationActions.add(this.viewHtmlAction);
        this.playAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 2));
        this.playAction.putValue("ActionCommandKey", "play");
        this.playAction.putValue("Name", I18n.getString("msgAction_Play"));
        this.playAction.putValue("ShortDescription", I18n.getString("msgAction_PlayE"));
        this.playAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("play"));
        this.applicationActions.add(this.playAction);
        this.trashAction.putValue("ActionCommandKey", "trash");
        this.trashAction.putValue("ShortDescription", I18n.getString("msgAction_TrashE"));
        this.applicationActions.add(this.trashAction);
        this.helpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        this.helpAction.putValue("ActionCommandKey", "help");
        this.helpAction.putValue("MnemonicKey", new Integer(72));
        this.helpAction.putValue("Name", I18n.getString("msgAction_Help"));
        this.helpAction.putValue("ShortDescription", I18n.getString("msgAction_HelpE"));
        this.applicationActions.add(this.helpAction);
        this.pauseWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(19, 0));
        this.pauseWorldAction.putValue("ActionCommandKey", "pauseWorld");
        this.pauseWorldAction.putValue("Name", I18n.getString("msgAction_Pause"));
        this.pauseWorldAction.putValue("ShortDescription", I18n.getString("msgAction_PauseE"));
        this.renderActions.add(this.pauseWorldAction);
        this.resumeWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(33, 0));
        this.resumeWorldAction.putValue("ActionCommandKey", "resumeWorld");
        this.resumeWorldAction.putValue("Name", I18n.getString("msgAction_Resume"));
        this.resumeWorldAction.putValue("ShortDescription", I18n.getString("msgAction_ResumeE"));
        this.renderActions.add(this.resumeWorldAction);
        this.restartWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
        this.restartWorldAction.putValue("ActionCommandKey", "restartWorld");
        this.restartWorldAction.putValue("Name", I18n.getString("msgAction_Restart"));
        this.restartWorldAction.putValue("ShortDescription", I18n.getString("msgAction_RestartE"));
        this.renderActions.add(this.restartWorldAction);
        this.stopWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        this.stopWorldAction.putValue("ActionCommandKey", "stopWorld");
        this.stopWorldAction.putValue("Name", I18n.getString("msgAction_Stop"));
        this.stopWorldAction.putValue("ShortDescription", I18n.getString("msgAction_StopE"));
        this.renderActions.add(this.stopWorldAction);
    }

    private void keyInit() {
        Iterator iterator = this.applicationActions.iterator();
        while (iterator.hasNext()) {
            String string;
            KeyStroke keyStroke;
            Action action = (Action)iterator.next();
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                string = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (keyStroke == null || string == null) continue;
            this.jAliceFrame.registerKeyboardAction(action, string, keyStroke, 2);
        }
    }
}

