/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Constant;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.editinplace.EditBoolean;
import usp.ime.line.ivprog.view.domaingui.editinplace.EditInPlace;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionHolderUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;

public class ConstantUI
extends JPanel
implements IDomainObjectUI,
IValueListener {
    private String currentModelID;
    private String parentModelID;
    private String scopeModelID;
    private String context;
    private short expressionType;
    private EditBoolean editBool;
    private EditInPlace editInPlace;
    private boolean isEditing = false;
    private JLabel valueLabel;

    public ConstantUI(String string) {
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setVgap(2);
        flowLayout.setHgap(2);
        this.currentModelID = string;
        this.initBool();
        this.initEditInPlace();
        this.valueLabel = new JLabel();
        this.valueLabel.setForeground(Color.BLUE);
        this.add(this.valueLabel);
        this.add(this.editBool);
        this.add(this.editInPlace);
        this.setOpaque(false);
    }

    private void initEditInPlace() {
        this.editInPlace = new EditInPlace(FlatUIColors.CODE_BG);
        this.editInPlace.setValueListener(new IValueListener(){

            @Override
            public void valueChanged(String string) {
                Services.getController().changeValue(ConstantUI.this.currentModelID, string);
            }
        });
    }

    private void initBool() {
        this.editBool = new EditBoolean(FlatUIColors.CODE_BG);
        this.editBool.setValueListener(new IValueListener(){

            @Override
            public void valueChanged(String string) {
                Services.getController().changeValue(ConstantUI.this.currentModelID, string);
            }
        });
    }

    private void changeVariableType(short s) {
        Constant constant = (Constant)Services.getModelMapping().get(this.currentModelID);
        if (s == 13) {
            this.editInPlace.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_INTEGER);
            this.editInPlace.setValue(constant.getConstantValue());
        } else if (s == 14) {
            this.editInPlace.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_DOUBLE);
            this.editInPlace.setValue(constant.getConstantValue());
        } else if (s == 15) {
            this.editInPlace.setValue(constant.getConstantValue());
        } else if (s == 16) {
            this.editBool.setValue(constant.getConstantValue());
        }
    }

    @Override
    public String getModelID() {
        return this.currentModelID;
    }

    @Override
    public String getModelParent() {
        return this.parentModelID;
    }

    @Override
    public String getModelScope() {
        return this.scopeModelID;
    }

    @Override
    public void setModelID(String string) {
        this.currentModelID = string;
    }

    @Override
    public void setModelParent(String string) {
        this.parentModelID = string;
    }

    @Override
    public void setModelScope(String string) {
        this.scopeModelID = string;
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public short getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(short s) {
        this.expressionType = s;
        this.changeVariableType(s);
    }

    private void warningStateOn() {
    }

    private void warningStateOff() {
    }

    public void editStateOn() {
        this.isEditing = true;
        this.valueLabel.setVisible(false);
        if (this.expressionType != 16) {
            this.editInPlace.setVisible(true);
            this.editBool.setVisible(false);
        } else {
            this.editBool.setVisible(true);
            this.editInPlace.setVisible(false);
        }
        if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).editStateOn();
        }
    }

    public void editStateOff(String string) {
        this.isEditing = false;
        this.valueLabel.setVisible(true);
        this.valueLabel.setText(((Constant)Services.getModelMapping().get(this.currentModelID)).getConstantValue());
        this.editInPlace.setVisible(false);
        this.editBool.setVisible(false);
        if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).editStateOff();
        }
    }

    public boolean isEditState() {
        return this.isEditing;
    }

    @Override
    public void valueChanged(String string) {
        if (this.expressionType == 16) {
            this.editBool.setValue(string);
            if (string.equals("true")) {
                this.valueLabel.setText("Verdadeiro");
            } else {
                this.valueLabel.setText("Falso");
            }
        } else {
            this.editInPlace.setValue(string);
            this.valueLabel.setText(string);
        }
    }

    @Override
    public boolean isContentSet() {
        return true;
    }

    @Override
    public void lockDownCode() {
        this.editStateOff("");
    }
}

