/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.editinplace;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;

public class ReadTextField
extends JPanel
implements KeyListener {
    private JTextField textField;
    public static int PATTERN_VARIABLE_NAME = 0;
    public static int PATTERN_VARIABLE_VALUE_DOUBLE = 1;
    public static int PATTERN_VARIABLE_VALUE_INTEGER = 2;
    public static int PATTERN_VARIABLE_VALUE_STRING = 3;
    private IValueListener valueListener;
    private int currentPattern = 0;
    private String[] patternsTyping = new String[]{"^[a-zA-Z_][a-zA-Z0-9_]*$", "^[-]?[0-9]*.[0-9]*$", "^[-]?[0-9]*$", ".*"};
    private String[] patterns = new String[]{"^[a-zA-Z_][a-zA-Z0-9_]*$", "^[-]?[0-9]*.[0-9]*$", "^[-]?[0-9]*$", ".*"};
    private Color bgColor = FlatUIColors.MAIN_BG;

    public ReadTextField() {
        this.textField = new JTextField();
        this.textField.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.add(this.textField);
        this.textField.setColumns(25);
        this.initTextFieldConfig();
        this.initInputMap();
        this.setBackground(this.bgColor);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c;
        if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            this.valueListener.valueChanged(this.textField.getText());
            return;
        }
        String string = this.textField.getText();
        string = this.textField.getSelectionStart() == 0 ? keyEvent.getKeyChar() + string : (this.textField.getSelectionStart() == string.length() ? string + keyEvent.getKeyChar() : string.substring(0, this.textField.getSelectionStart()) + keyEvent.getKeyChar() + string.substring(this.textField.getSelectionEnd()));
        if (!string.matches(this.patternsTyping[this.currentPattern]) && (c = keyEvent.getKeyChar()) != '\b' && c != '\u007f') {
            this.getToolkit().beep();
            keyEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void initInputMap() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=FOCUSLOST;where=EDIT_DONE_READ_PANEL;");
                ReadTextField.this.textField.setFocusable(false);
                ReadTextField.this.textField.setFocusable(true);
            }
        };
        this.textField.getInputMap().put(KeyStroke.getKeyStroke('\n'), abstractAction);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke('\u001b'), abstractAction);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke('\t'), abstractAction);
    }

    private void initTextFieldConfig() {
        this.textField.addKeyListener(this);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ReadTextField.this.textField.getText();
                if (!string.matches(ReadTextField.this.patterns[ReadTextField.this.currentPattern])) {
                    ReadTextField.this.textField.setBorder(BorderFactory.createLineBorder(Color.red));
                } else {
                    ReadTextField.this.valueListener.valueChanged(ReadTextField.this.textField.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.initInputMap();
    }

    public void setValue(String string) {
        this.textField.setText(string);
    }

    public int getCurrentPattern() {
        return this.currentPattern;
    }

    public void setCurrentPattern(int n) {
        this.currentPattern = n;
    }

    public void resetTextField() {
        this.textField.setText("");
    }

    public void setValueListener(IValueListener iValueListener) {
        this.valueListener = iValueListener;
    }
}

