/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.model;

import bsh.EvalError;
import bsh.Interpreter;
import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.assignment.model.DomainObject;
import ilm.framework.domain.DomainModel;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import usp.ime.line.ivprog.listeners.ICodeListener;
import usp.ime.line.ivprog.listeners.IExpressionListener;
import usp.ime.line.ivprog.listeners.IFunctionListener;
import usp.ime.line.ivprog.listeners.IOperationListener;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.listeners.IVariableListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.AttributionLine;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.CodeComponent;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.CodeComposite;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Constant;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.DataObject;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Expression;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.For;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Function;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.IfElse;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Operation;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Print;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.ReadData;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Reference;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.VariableReference;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.While;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.domaingui.IVPConsole;
import usp.ime.line.ivprog.view.domaingui.frames.AskUserFrameBoolean;
import usp.ime.line.ivprog.view.domaingui.frames.AskUserFrameDouble;
import usp.ime.line.ivprog.view.domaingui.frames.AskUserFrameInteger;
import usp.ime.line.ivprog.view.domaingui.frames.AskUserFrameString;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.AttributionLineUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.VariableSelectorUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IVPProgram
extends DomainModel {
    private Interpreter interpreter = new Interpreter();
    private String currentScope = "0";
    private AskUserFrameInteger readInteger = new AskUserFrameInteger();
    private AskUserFrameDouble readDouble = new AskUserFrameDouble();
    private AskUserFrameString readString = new AskUserFrameString();
    private AskUserFrameBoolean readBoolean = new AskUserFrameBoolean();
    private IVPConsole console;
    boolean error = false;

    public IVPProgram() {
        try {
            this.interpreter.set("readInteger", this.readInteger);
            this.interpreter.set("readDouble", this.readDouble);
            this.interpreter.set("readString", this.readString);
            this.interpreter.set("readBoolean", this.readBoolean);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }

    public void initializeModel() {
        this.createFunction(ResourceBundleIVP.getString("mainFunctionName"), "void", Services.getCurrentState());
    }

    public void createFunction(String string, String string2, AssignmentState assignmentState) {
        Function function = (Function)assignmentState.getData().getDataFactory().createFunction();
        function.setFunctionName(string);
        function.setReturnType(string2);
        assignmentState.getData().getFunctionMap().put(string, function);
        Services.getModelMapping().put(function.getUniqueID(), function);
        for (int i = 0; i < assignmentState.getData().getFunctionListeners().size(); ++i) {
            IFunctionListener iFunctionListener = (IFunctionListener)assignmentState.getData().getFunctionListeners().get(i);
            iFunctionListener.functionCreated(function.getUniqueID());
        }
        if (assignmentState != null) {
            assignmentState.add(function);
        }
    }

    public void removeFunction(String string, AssignmentState assignmentState) {
        assignmentState.remove((DomainObject)assignmentState.getData().getFunctionMap().get(string));
        assignmentState.getData().getFunctionMap().remove(string);
    }

    public String newChild(String string, short s, String string2, AssignmentState assignmentState) {
        DataObject dataObject = null;
        if (s == 21) {
            dataObject = (CodeComposite)assignmentState.getData().getDataFactory().createWhile();
            this.initCodeBlock(string, dataObject);
            this.createExpression("", dataObject.getUniqueID(), (short)9, (short)-1, "while", assignmentState);
        } else if (s == 23) {
            dataObject = assignmentState.getData().getDataFactory().createPrint();
            this.initCodeBlock(string, dataObject);
            this.createExpression("", dataObject.getUniqueID(), (short)0, (short)-1, "printable", assignmentState);
        } else if (s == 22) {
            dataObject = assignmentState.getData().getDataFactory().createIfElse();
            this.initCodeBlock(string, dataObject);
            this.createExpression("", dataObject.getUniqueID(), (short)9, (short)-1, "ifElse", assignmentState);
        } else if (s == 25) {
            dataObject = assignmentState.getData().getDataFactory().createAttributionLine();
            this.initCodeBlock(string, dataObject);
            this.createExpression("", dataObject.getUniqueID(), (short)0, (short)-1, "leftVar", assignmentState);
        } else if (s == 24) {
            dataObject = assignmentState.getData().getDataFactory().createRead();
            this.initCodeBlock(string, dataObject);
            this.createExpression("", dataObject.getUniqueID(), (short)0, (short)-1, "writable", assignmentState);
        } else if (s == 20) {
            dataObject = assignmentState.getData().getDataFactory().createFor();
            this.initCodeBlock(string, dataObject);
            this.createForExpressions((For)dataObject, assignmentState);
        }
        CodeComposite codeComposite = (CodeComposite)Services.getModelMapping().get(string);
        if (codeComposite instanceof IfElse) {
            if (string2.equals("if")) {
                codeComposite.addChild(dataObject.getUniqueID());
            } else if (string2.equals("else")) {
                ((IfElse)codeComposite).addElseChildT(dataObject.getUniqueID());
            }
        } else {
            codeComposite.addChild(dataObject.getUniqueID());
        }
        ICodeListener iCodeListener = (ICodeListener)assignmentState.getData().getCodeListeners().get(string);
        iCodeListener.addChild(dataObject.getUniqueID(), string2);
        assignmentState.add(dataObject);
        return dataObject.getUniqueID();
    }

    private void createForExpressions(For for_, AssignmentState assignmentState) {
        Expression expression = this.createExpression("", for_.getUniqueID(), (short)0, (short)13, assignmentState);
        this.updateExpressionListeners(for_.getUniqueID(), (short)13, "forIndex", assignmentState, expression);
        this.putExpressionOnRightPlace(for_.getUniqueID(), "forIndex", expression);
    }

    private void initCodeBlock(String string, DataObject dataObject) {
        dataObject.setParentID(string);
        dataObject.setScopeID(this.currentScope);
        Services.getModelMapping().put(dataObject.getUniqueID(), dataObject);
    }

    public int moveChild(String string, String string2, String string3, String string4, String string5, int n, AssignmentState assignmentState) {
        CodeComposite codeComposite = (CodeComposite)Services.getModelMapping().get(string3);
        CodeComposite codeComposite2 = (CodeComposite)Services.getModelMapping().get(string2);
        CodeComponent codeComponent = (CodeComponent)Services.getModelMapping().get(string);
        int n2 = -1;
        ICodeListener iCodeListener = (ICodeListener)Services.getViewMapping().get(string3);
        ICodeListener iCodeListener2 = (ICodeListener)Services.getViewMapping().get(string2);
        if (string2 != string3) {
            if (codeComposite2 instanceof IfElse) {
                if (string4.equals("if")) {
                    n2 = codeComposite2.removeChild(string);
                } else if (string4.equals("else")) {
                    n2 = ((IfElse)codeComposite2).removeElseChild(string);
                }
            } else {
                n2 = codeComposite2.removeChild(string);
            }
            if (codeComposite instanceof IfElse) {
                if (string5.equals("if")) {
                    codeComposite.addChildToIndex(string, n);
                } else if (string5.equals("else")) {
                    ((IfElse)codeComposite).addElseChildToIndex(string, n);
                }
            } else {
                codeComposite.addChildToIndex(string, n);
            }
            iCodeListener2.childRemoved(string, string4);
            iCodeListener.restoreChild(string, n, string5);
        } else {
            if (codeComposite2 instanceof IfElse) {
                if (string4.equals("if")) {
                    n2 = codeComposite2.moveChild(string, n);
                } else if (string4.equals("else")) {
                    n2 = ((IfElse)codeComposite2).moveElseChild(string, n);
                }
            } else {
                n2 = codeComposite2.moveChild(string, n);
            }
            iCodeListener2.moveChild(string, string4, n);
        }
        codeComponent.setParentID(string3);
        return n2;
    }

    public int removeChild(String string, String string2, String string3, AssignmentState assignmentState) {
        CodeComposite codeComposite = (CodeComposite)Services.getModelMapping().get(string);
        int n = 0;
        if (codeComposite instanceof IfElse) {
            if (string3.equals("if")) {
                n = codeComposite.removeChild(string2);
            } else if (string3.equals("else")) {
                n = ((IfElse)codeComposite).removeElseChild(string2);
            }
        } else {
            n = codeComposite.removeChild(string2);
        }
        ICodeListener iCodeListener = (ICodeListener)assignmentState.getData().getCodeListeners().get(string);
        iCodeListener.childRemoved(string2, string3);
        CodeComponent codeComponent = (CodeComponent)Services.getModelMapping().get(string2);
        if (codeComponent instanceof AttributionLine) {
            assignmentState.remove((DomainObject)Services.getModelMapping().get(((AttributionLine)codeComponent).getLeftVariableID()));
        } else if (codeComponent instanceof CodeComposite) {
            // empty if block
        }
        assignmentState.remove((DomainObject)Services.getModelMapping().get(string2));
        return n;
    }

    public void restoreChild(String string, String string2, int n, String string3, AssignmentState assignmentState) {
        CodeComposite codeComposite = (CodeComposite)Services.getModelMapping().get(string);
        if (codeComposite instanceof IfElse) {
            if (string3.equals("if")) {
                codeComposite.addChildToIndex(string2, n);
            } else if (string3.equals("else")) {
                ((IfElse)codeComposite).addElseChildToIndex(string2, n);
            }
        } else {
            codeComposite.addChildToIndex(string2, n);
        }
        ICodeListener iCodeListener = (ICodeListener)assignmentState.getData().getCodeListeners().get(string);
        iCodeListener.restoreChild(string2, n, string3);
    }

    public void createParameter(String string) {
    }

    public void removeParameter(String string, String string2) {
    }

    public String createVariable(String string, String string2, AssignmentState assignmentState) {
        Function function = (Function)Services.getModelMapping().get(string);
        Variable variable = (Variable)assignmentState.getData().getDataFactory().createVariable();
        variable.setVariableName("variavel" + function.getVariableCount());
        variable.setVariableType((short)13);
        variable.setVariableValue(string2);
        variable.setScopeID(this.currentScope);
        Services.getModelMapping().put(variable.getUniqueID(), variable);
        function.addLocalVariable(variable.getUniqueID());
        for (int i = 0; i < assignmentState.getData().getVariableListeners().size(); ++i) {
            IVariableListener iVariableListener = (IVariableListener)assignmentState.getData().getVariableListeners().get(i);
            iVariableListener.addedVariable(variable.getUniqueID());
        }
        assignmentState.add(variable);
        return variable.getUniqueID();
    }

    public void removeVariable(String string, String string2, AssignmentState assignmentState) {
        Function function = (Function)Services.getModelMapping().get(string);
        function.removeLocalVariable(string2);
        for (int i = 0; i < assignmentState.getData().getVariableListeners().size(); ++i) {
            IVariableListener iVariableListener = (IVariableListener)assignmentState.getData().getVariableListeners().get(i);
            iVariableListener.removedVariable(string2);
        }
        assignmentState.remove((DomainObject)Services.getModelMapping().get(string2));
    }

    public void restoreVariable(String string, String string2, AssignmentState assignmentState) {
        Function function = (Function)Services.getModelMapping().get(string);
        function.addLocalVariable(string2);
        for (int i = 0; i < assignmentState.getData().getVariableListeners().size(); ++i) {
            IVariableListener iVariableListener = (IVariableListener)assignmentState.getData().getVariableListeners().get(i);
            iVariableListener.variableRestored(string2);
        }
        assignmentState.add((DomainObject)Services.getModelMapping().get(string2));
    }

    public String updateReferencedVariable(String string, String string2, AssignmentState assignmentState) {
        Variable variable;
        String string3 = "";
        VariableReference variableReference = (VariableReference)Services.getModelMapping().get(string);
        string3 = variableReference.getReferencedVariable();
        variableReference.setReferencedVariable(string2);
        for (int i = 0; i < assignmentState.getData().getVariableListeners().size(); ++i) {
            IVariableListener iVariableListener = (IVariableListener)assignmentState.getData().getVariableListeners().get(i);
            iVariableListener.updateReference(string);
        }
        if (string2 != null && !"".equals(string2)) {
            Variable variable2 = (Variable)Services.getModelMapping().get(string2);
            variable2.addVariableReference(string);
        }
        if ((variable = (Variable)Services.getModelMapping().get(string3)) != null) {
            variable.removeVariableReference(string);
        }
        return string3;
    }

    public String createExpression(String string, String string2, short s, short s2, String string3, AssignmentState assignmentState) {
        Expression expression = this.createExpression(string, string2, s, s2, assignmentState);
        this.updateExpressionListeners(string2, s, string3, assignmentState, expression);
        this.putExpressionOnRightPlace(string2, string3, expression);
        assignmentState.add(expression);
        return expression.getUniqueID();
    }

    private void updateExpressionListeners(String string, short s, String string2, AssignmentState assignmentState, Expression expression) {
        for (int i = 0; i < assignmentState.getData().getExpressionListeners().size(); ++i) {
            ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(i)).expressionCreated(string, expression.getUniqueID(), string2);
        }
        if (s == 5 || s == 6) {
            Expression expression2 = (Expression)assignmentState.getData().getDataFactory().createExpression();
            expression2.setExpressionType((short)9);
            expression2.setParentID(expression.getUniqueID());
            expression2.setScopeID(this.currentScope);
            ((Operation)expression).setExpressionB(expression2.getUniqueID());
            Services.getModelMapping().put(expression2.getUniqueID(), expression2);
            for (int i = 0; i < assignmentState.getData().getExpressionListeners().size(); ++i) {
                ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(i)).expressionCreated(expression.getUniqueID(), expression2.getUniqueID(), "right");
            }
            assignmentState.add(expression2);
        }
    }

    private void putExpressionOnRightPlace(String string, String string2, Expression expression) {
        if (string2.equals("right")) {
            ((Operation)Services.getModelMapping().get(string)).setExpressionB(expression.getUniqueID());
        } else if (string2.equals("left")) {
            ((Operation)Services.getModelMapping().get(string)).setExpressionA(expression.getUniqueID());
        } else if (string2.equals("leftVar")) {
            ((AttributionLine)Services.getModelMapping().get(string)).setLeftVariableID(expression.getUniqueID());
        } else if (string2.equals("printable")) {
            ((Print)Services.getModelMapping().get(string)).setPrintableObject(expression.getUniqueID());
        } else if (string2.equals("writable")) {
            ((ReadData)Services.getModelMapping().get(string)).setWritableObject(expression.getUniqueID());
        } else if (string2.equals("while")) {
            ((While)Services.getModelMapping().get(string)).setCondition(expression.getUniqueID());
        } else if (string2.equals("ifElse")) {
            ((IfElse)Services.getModelMapping().get(string)).setComparison(expression.getUniqueID());
        } else if (string2.equals("forIndex")) {
            ((For)Services.getModelMapping().get(string)).setIndexExpression(expression.getUniqueID());
        } else if (string2.equals("forLowerBound")) {
            ((For)Services.getModelMapping().get(string)).setLowerBoundExpression(expression.getUniqueID());
        } else if (string2.equals("forUpperBound")) {
            ((For)Services.getModelMapping().get(string)).setUpperBoundExpression(expression.getUniqueID());
        } else if (string2.equals("forIncrement")) {
            ((For)Services.getModelMapping().get(string)).setIncrementExpression(expression.getUniqueID());
        }
    }

    private Expression createExpression(String string, String string2, short s, short s2, AssignmentState assignmentState) {
        Expression expression = null;
        if (s == 0) {
            expression = (Expression)assignmentState.getData().getDataFactory().createVarReference();
            expression.setExpressionType((short)0);
            ((VariableReference)expression).setReferencedType(s2);
        } else if (s >= 13 && s <= 16) {
            expression = (Expression)assignmentState.getData().getDataFactory().createConstant();
            expression.setExpressionType(s);
            ((Constant)expression).setConstantValue(this.getInitvalue(s));
        } else {
            expression = (Expression)assignmentState.getData().getDataFactory().createExpression();
            expression.setExpressionType(s);
            if (string != "") {
                ((Expression)Services.getModelMapping().get(string)).setParentID(expression.getUniqueID());
                ((Operation)expression).setExpressionA(string);
            }
        }
        expression.setParentID(string2);
        expression.setScopeID(this.currentScope);
        Services.getModelMapping().put(expression.getUniqueID(), expression);
        return expression;
    }

    public String deleteExpression(String string, String string2, String string3, boolean bl, boolean bl2, AssignmentState assignmentState) {
        String string4;
        Expression expression = (Expression)Services.getModelMapping().get(string);
        DataObject dataObject = (DataObject)Services.getModelMapping().get(string2);
        if (dataObject instanceof AttributionLine) {
            ((AttributionLine)dataObject).setRightExpression("");
            string4 = "";
        } else if (dataObject instanceof Print) {
            string4 = "";
        } else if (dataObject instanceof Operation) {
            ((Operation)dataObject).removeExpression(string);
            string4 = ((Operation)dataObject).getExpressionA();
        } else if (dataObject instanceof For) {
            ((For)dataObject).removeExpression(string, string3);
        }
        for (int i = 0; i < assignmentState.getData().getExpressionListeners().size(); ++i) {
            ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(i)).expressionDeleted(string, string3, bl);
        }
        if (bl) {
            int n;
            Expression expression2;
            if (!bl2) {
                expression2 = (Expression)assignmentState.getData().getDataFactory().createVarReference();
                expression2.setExpressionType((short)0);
                if (dataObject instanceof For) {
                    ((VariableReference)expression2).setReferencedType((short)13);
                } else if (dataObject instanceof AttributionLine) {
                    ((VariableReference)expression2).setReferencedType(((AttributionLine)dataObject).getLeftVariableType());
                } else if (dataObject instanceof Operation) {
                    n = ((Operation)dataObject).getExpressionType();
                    ((VariableReference)expression2).setReferencedType((short)n);
                }
            } else {
                expression2 = (Expression)assignmentState.getData().getDataFactory().createExpression();
                expression2.setExpressionType((short)9);
            }
            expression2.setParentID(string2);
            expression2.setScopeID(this.currentScope);
            Services.getModelMapping().put(expression2.getUniqueID(), expression2);
            for (n = 0; n < assignmentState.getData().getExpressionListeners().size(); ++n) {
                ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(n)).expressionCreated(string2, expression2.getUniqueID(), string3);
            }
            if (assignmentState != null) {
                assignmentState.add(expression2);
            }
        }
        if (assignmentState != null) {
            assignmentState.remove(expression);
        }
        return string;
    }

    public void restoreExpression(String string, String string2, String string3, boolean bl, AssignmentState assignmentState) {
        Expression expression = (Expression)Services.getModelMapping().get(string);
        for (int i = 0; i < assignmentState.getData().getExpressionListeners().size(); ++i) {
            if (bl) {
                ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(i)).expressionRestoredFromCleaning(string2, string, string3);
                continue;
            }
            ((IExpressionListener)assignmentState.getData().getExpressionListeners().get(i)).expressionRestored(string2, string, string3);
        }
        assignmentState.add(expression);
    }

    public short changeOperationSign(String string, String string2, short s, AssignmentState assignmentState) {
        Expression expression = (Expression)Services.getModelMapping().get(string);
        short s2 = expression.getExpressionType();
        expression.setExpressionType(s);
        for (int i = 0; i < assignmentState.getData().getOperationListeners().size(); ++i) {
            ((IOperationListener)assignmentState.getData().getOperationListeners().get(i)).operationTypeChanged(string, string2);
        }
        return s2;
    }

    public String changeValue(String string, String string2, AssignmentState assignmentState) {
        Constant constant = (Constant)Services.getModelMapping().get(string);
        String string3 = constant.getConstantValue();
        constant.setConstantValue(string2);
        IValueListener iValueListener = (IValueListener)Services.getViewMapping().get(string);
        iValueListener.valueChanged(string2);
        return string3;
    }

    public String changeVariableName(String string, String string2, AssignmentState assignmentState) {
        Object object;
        int n;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        String string3 = variable.getVariableName();
        variable.setVariableName(string2);
        for (n = 0; n < assignmentState.getData().getVariableListeners().size(); ++n) {
            object = (IVariableListener)assignmentState.getData().getVariableListeners().get(n);
            object.changeVariableName(string, string2, string3);
        }
        for (n = 0; n < variable.getVariableReferenceList().size(); ++n) {
            object = (Reference)Services.getModelMapping().get(variable.getVariableReferenceList().get(n));
            ((Reference)object).setReferencedName(variable.getVariableName());
        }
        assignmentState.updateState((DomainObject)Services.getModelMapping().get(string));
        return string3;
    }

    public Vector changeVariableType(String string, short s, AssignmentState assignmentState) {
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        for (n2 = 0; n2 < variable.getVariableReferenceList().size(); ++n2) {
            object3 = (Reference)Services.getModelMapping().get(variable.getVariableReferenceList().get(n2));
            ((Reference)object3).setReferencedType(s);
        }
        n2 = variable.getVariableType();
        object3 = new Vector();
        ((Vector)object3).add((short)n2);
        variable.setVariableType(s);
        variable.setVariableValue(this.getInitvalue(s));
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < assignmentState.getData().getVariableListeners().size(); ++n) {
            object2 = (IVariableListener)assignmentState.getData().getVariableListeners().get(n);
            object2.changeVariableType(string, s);
            if (!(object2 instanceof VariableSelectorUI) || !((VariableSelectorUI)object2).isIsolated()) continue;
            object = ((VariableSelectorUI)object2).getModelParent();
            if (!(Services.getModelMapping().get(object) instanceof AttributionLine)) continue;
            vector.add(object);
        }
        for (n = 0; n < vector.size(); ++n) {
            object2 = (AttributionLine)Services.getModelMapping().get(vector.get(n));
            object = (VariableReference)Services.getModelMapping().get(((AttributionLine)object2).getLeftVariableID());
            if (((AttributionLine)object2).getLeftVariableType() == s || !string.equals(((VariableReference)object).getReferencedVariable())) continue;
            assignmentState.remove((DomainObject)Services.getModelMapping().get(((AttributionLine)object2).getRightExpressionID()));
            ((AttributionLine)object2).setLeftVariableType(s);
            AttributionLineUI attributionLineUI = (AttributionLineUI)Services.getViewMapping().get(vector.get(n));
            attributionLineUI.updateHoldingType(s);
            ((Vector)object3).add(this.deleteExpression(((AttributionLine)object2).getRightExpressionID(), ((DataObject)object2).getUniqueID(), "", true, false, assignmentState));
        }
        assignmentState.updateState(variable);
        return object3;
    }

    public void restoreVariableType(String string, Vector vector, AssignmentState assignmentState) {
        Object object;
        Object object2;
        int n;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        variable.setVariableType((Short)vector.get(0));
        variable.setVariableValue(this.getInitvalue((Short)vector.get(0)));
        Vector<Object> vector2 = new Vector<Object>();
        for (n = 0; n < assignmentState.getData().getVariableListeners().size(); ++n) {
            object2 = (IVariableListener)assignmentState.getData().getVariableListeners().get(n);
            object2.changeVariableType(string, (Short)vector.get(0));
            if (!(object2 instanceof VariableSelectorUI) || !((VariableSelectorUI)object2).isIsolated()) continue;
            object = ((VariableSelectorUI)object2).getModelParent();
            if (!(Services.getModelMapping().get(object) instanceof AttributionLine)) continue;
            vector2.add(object);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (AttributionLine)Services.getModelMapping().get(vector2.get(n));
            object = (VariableReference)Services.getModelMapping().get(((AttributionLine)object2).getLeftVariableID());
            if (((AttributionLine)object2).getLeftVariableType() == ((Short)vector.get(0)).shortValue() || !string.equals(((VariableReference)object).getReferencedVariable())) continue;
            ((AttributionLine)object2).setLeftVariableType((Short)vector.get(0));
            AttributionLineUI attributionLineUI = (AttributionLineUI)Services.getViewMapping().get(vector2.get(n));
            attributionLineUI.updateHoldingType((Short)vector.get(0));
        }
        for (n = 1; n < vector.size(); ++n) {
            object2 = (String)vector.get(n);
            object = ((Expression)Services.getModelMapping().get(vector.get(n))).getParentID();
            this.restoreExpression((String)object2, (String)object, "", true, assignmentState);
            assignmentState.add((DomainObject)Services.getModelMapping().get((String)vector.get(n)));
        }
        assignmentState.updateState(variable);
    }

    public String changeVariableInitialValue(String string, String string2, AssignmentState assignmentState) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        String string3 = variable.getVariableValue();
        variable.setVariableValue(string2);
        for (int i = 0; i < assignmentState.getData().getVariableListeners().size(); ++i) {
            IVariableListener iVariableListener = (IVariableListener)assignmentState.getData().getVariableListeners().get(i);
            iVariableListener.changeVariableValue(string, string2);
        }
        assignmentState.updateState((DomainObject)Services.getModelMapping().get(string));
        return string3;
    }

    public int changeForMode(int n, String string, AssignmentState assignmentState) {
        For for_ = (For)Services.getModelMapping().get(string);
        int n2 = for_.getCurrentForMode();
        for_.setCurrentForMode(n);
        return n2;
    }

    @Override
    public AssignmentState getNewAssignmentState() {
        return new AssignmentState();
    }

    public void setConsoleListener(IVPConsole iVPConsole) {
        try {
            this.interpreter.set("ivpConsole", iVPConsole);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
        this.console = iVPConsole;
    }

    public void updateParent(String string, String string2, String string3, String string4) {
        DataObject dataObject = (DataObject)Services.getModelMapping().get(string);
        if (dataObject instanceof CodeComponent) {
            ((CodeComponent)dataObject).updateParent(string2, string3, string4);
        } else if (dataObject instanceof Operation) {
            ((Operation)dataObject).updateParent(string2, string3, string4);
        }
    }

    public short updateAttLineType(String string, short s) {
        AttributionLine attributionLine = (AttributionLine)Services.getModelMapping().get(string);
        short s2 = attributionLine.getLeftVariableType();
        attributionLine.setLeftVariableType(s);
        this.deleteExpression(attributionLine.getRightExpressionID(), string, "", true, false, null);
        ((AttributionLineUI)Services.getViewMapping().get(string)).updateHoldingType(s);
        return s2;
    }

    public String getInitvalue(short s) {
        if (s == 16) {
            return "true";
        }
        if (s == 14) {
            return "1.0";
        }
        if (s == 13) {
            return "1";
        }
        if (s == 15) {
            return ResourceBundleIVP.getString("helloWorld.text");
        }
        return "";
    }

    public void addComponentListener(ICodeListener iCodeListener, String string) {
        Services.getCurrentState().getData().getCodeListeners().put(string, iCodeListener);
    }

    public HashMap getCodeListener() {
        return Services.getCurrentState().getData().getCodeListeners();
    }

    public HashMap getFunctionMap() {
        return Services.getCurrentState().getData().getFunctionMap();
    }

    public void setFunctionMap(HashMap hashMap) {
        Services.getCurrentState().getData().setFunctionMap(hashMap);
    }

    public void addExpressionListener(IExpressionListener iExpressionListener) {
        if (!Services.getCurrentState().getData().getExpressionListeners().contains(iExpressionListener)) {
            Services.getCurrentState().getData().getExpressionListeners().add(iExpressionListener);
        }
    }

    public void addOperationListener(IOperationListener iOperationListener) {
        if (!Services.getCurrentState().getData().getOperationListeners().contains(iOperationListener)) {
            Services.getCurrentState().getData().getOperationListeners().add(iOperationListener);
        }
    }

    public void addVariableListener(IVariableListener iVariableListener) {
        Services.getCurrentState().getData().getVariableListeners().add(iVariableListener);
    }

    public void addFunctionListener(IFunctionListener iFunctionListener) {
        Services.getCurrentState().getData().getFunctionListeners().add(iFunctionListener);
    }

    public void playCode() {
        if (Services.getController().isContentSet()) {
            Services.getController().lockCodeDown();
            String string = "";
            Object[] objectArray = Services.getCurrentState().getData().getFunctionMap().values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                string = string + " " + ((Function)objectArray[i]).toJavaString() + " ";
            }
            string = string + " Principal(); ";
            if (this.error) {
                this.console.clean();
                this.error = false;
            }
            try {
                this.interpreter.set("isEvaluating", false);
                this.interpreter.eval(string);
            }
            catch (EvalError evalError) {
                if (evalError.getCause() != null && evalError.getCause().equals("/ by zero")) {
                    this.console.printError(ResourceBundleIVP.getString("IVPProgram.DivByZeroMessage"));
                }
                evalError.printStackTrace();
            }
        } else {
            this.error = true;
            this.printError(ResourceBundleIVP.getString("Error.fieldsNotSet"));
        }
    }

    public void printError(String string) {
        this.console.printError(string);
    }

    public boolean validateVariableName(String string, String string2) {
        Function function = (Function)Services.getModelMapping().get(string);
        Vector vector = function.getLocalVariableMap().toVector();
        for (int i = 0; i < vector.size(); ++i) {
            Variable variable = (Variable)Services.getModelMapping().get(vector.get(i));
            if (!variable.getVariableName().equals(string2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float AutomaticChecking(AssignmentState assignmentState, AssignmentState assignmentState2) {
        return 0.0f;
    }

    public float getEvaluation(String string) {
        if (Services.getController().isContentSet()) {
            String string2;
            int n;
            Services.getController().lockCodeDown();
            Stack stack = new Stack();
            Stack stack2 = new Stack();
            Stack stack3 = new Stack();
            int n2 = 0;
            n2 = this.prepareInputAndOutput(string, stack, stack2);
            Stack stack4 = new Stack();
            int n3 = stack.size();
            for (n = 0; n < n3; ++n) {
                stack4.push(stack.pop());
            }
            stack = stack4;
            for (n = 0; n < n2; ++n) {
                if (Services.getController().isContentSet()) {
                    Services.getController().lockCodeDown();
                    String string3 = "";
                    Object[] objectArray = Services.getCurrentState().getData().getFunctionMap().values().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        string3 = string3 + " " + ((Function)objectArray[i]).toJavaString() + " ";
                    }
                    string3 = string3 + " Principal(); ";
                    if (this.error) {
                        this.console.clean();
                        this.error = false;
                    }
                    try {
                        this.interpreter.set("isEvaluating", true);
                        this.interpreter.set("interpreterOutput", stack3);
                        this.interpreter.set("interpreterInput", stack);
                        this.interpreter.eval(string3);
                    }
                    catch (EvalError evalError) {
                        if (evalError.getCause() != null && evalError.getCause().equals("/ by zero")) {
                            this.console.printError(ResourceBundleIVP.getString("IVPProgram.DivByZeroMessage"));
                        }
                        evalError.printStackTrace();
                    }
                    continue;
                }
                this.error = true;
                this.printError(ResourceBundleIVP.getString("Error.fieldsNotSet"));
            }
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                Object var11_16 = null;
                string2 = null;
                if (!stack3.isEmpty()) {
                    var11_16 = stack3.pop();
                }
                if (!stack2.isEmpty()) {
                    string2 = (String)stack2.pop();
                }
                if (var11_16 == null || string2 == null) continue;
                String string4 = "";
                String string5 = "";
                string4 = var11_16 instanceof Double ? String.format("%.4f", var11_16) : new String(var11_16 + "");
                if (!string4.equals(string5 = var11_16 instanceof Double ? String.format("%.4f", string2) : new String(string2 + ""))) continue;
                ++n4;
            }
            float f = 0.0f;
            if (n4 != 0) {
                f = (float)((double)n4 * 1.0 / (double)n2);
                float f2 = f * 100.0f;
                string2 = String.format("%.2f", Float.valueOf(f2));
                this.console.clean();
                this.console.println("-------------------------------------------------");
                this.console.println("Total de testes: " + n2);
                this.console.println("Passou em " + n4 + " testes.");
                this.console.println("Aproveitamento: " + string2 + "%.");
                this.console.println("-------------------------------------------------");
                return f;
            }
            f = (float)((double)n4 * 1.0 / (double)n2);
            float f3 = f * 100.0f;
            string2 = String.format("%.2f", Float.valueOf(f3));
            this.console.clean();
            this.console.println("-------------------------------------------------");
            this.console.println("Total de testes: " + n2);
            this.console.println("Passou em " + n4 + " testes.");
            this.console.println("Aproveitamento: 0%.");
            this.console.println("-------------------------------------------------");
            return 0.0f;
        }
        return 0.0f;
    }

    private int prepareInputAndOutput(String string, Stack stack, Stack stack2) {
        Document document = null;
        int n = 0;
        try {
            document = IVPProgram.loadXMLFromString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ("testcase".equals(node.getNodeName())) {
                ++n;
            }
            String string2 = node.getNodeName().trim();
            NodeList nodeList2 = node.getChildNodes();
            HashMap hashMap = new HashMap();
            if (string2.equals("#text")) continue;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeName().equals("#text")) continue;
                if (node2.getNodeName().equals("input")) {
                    if (!node2.hasAttributes()) continue;
                    stack.push(this.parseValue(node2.getAttributes().getNamedItem("type").getTextContent(), node2.getTextContent()));
                    continue;
                }
                if (!node2.getNodeName().equals("output") || !node2.hasAttributes()) continue;
                stack2.push(this.parseValue(node2.getAttributes().getNamedItem("type").getTextContent(), node2.getTextContent()));
            }
        }
        return n;
    }

    private Object parseValue(String string, String string2) {
        if (string.equals("int")) {
            return (int)new Integer(string2);
        }
        if (string.equals("double")) {
            return (double)new Double(string2);
        }
        if (string.equals("String")) {
            return new String(string2);
        }
        if (string.equals("boolean")) {
            return (boolean)new Boolean(string2);
        }
        if (string.equals("float")) {
            return Float.valueOf(new Float(string2).floatValue());
        }
        return null;
    }

    public static Document loadXMLFromString(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
    }
}

