/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.variables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import usp.ime.line.ivprog.listeners.IVariableListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.variables.IVPVariableBasic;
import usp.ime.line.ivprog.view.utils.DynamicFlowLayout;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.RoundedJPanel;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IVPVariablePanel
extends JPanel
implements IVariableListener {
    private static final long serialVersionUID = -2214975678822644250L;
    private JPanel container;
    private JButton addVarBtn;
    private RoundedJPanel varPanel;
    private JButton addParamBtn;
    private RoundedJPanel paramPanel;
    private String scopeID;
    private Vector variableList;
    private Vector paramList;
    private TreeMap varMap;
    private TreeMap paramMap;

    public IVPVariablePanel(String string, boolean bl) {
        this.setBorder(new MatteBorder(0, 0, 2, 0, Color.LIGHT_GRAY));
        this.scopeID = string;
        this.initialization(bl);
        Services.getController().getProgram().addVariableListener(this);
    }

    private void initialization(boolean bl) {
        this.initVectors();
        this.initLayout();
        this.initContainer();
        if (!bl) {
            this.initParamBtn();
            this.initParamPanel();
        }
        this.initAddVarBtn();
        this.initVarPanel();
    }

    private void initVectors() {
        this.variableList = new Vector();
        this.paramList = new Vector();
        this.varMap = new TreeMap();
        this.paramMap = new TreeMap();
    }

    private void initLayout() {
        this.setBackground(FlatUIColors.MAIN_BG);
        this.setLayout(new BorderLayout(0, 0));
    }

    private void initParamPanel() {
        this.paramPanel = new RoundedJPanel();
        this.paramPanel.setLayout(new DynamicFlowLayout(0, this.paramPanel, this.paramPanel.getClass(), 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.container.add((Component)this.paramPanel, gridBagConstraints);
    }

    private void initParamBtn() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Services.getController().addParameter(IVPVariablePanel.this.scopeID);
                Tracking.track("event=CLICK;where=BTN_NEWPARAMETER;");
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(IVPVariablePanel.class.getResource("/usp/ime/line/resources/icons/plus_param.png")));
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("IVPVariablePanel.action.addParam") + "Principal");
        this.addParamBtn = new JButton(abstractAction);
        this.addParamBtn.setHorizontalAlignment(2);
        this.addParamBtn.setUI(new IconButtonUI());
        this.addParamBtn.setPreferredSize(new Dimension(95, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.container.add((Component)this.addParamBtn, gridBagConstraints);
    }

    private void initVarPanel() {
        this.varPanel = new RoundedJPanel();
        this.varPanel.setLayout(new DynamicFlowLayout(0, this.varPanel, this.varPanel.getClass(), 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.container.add((Component)this.varPanel, gridBagConstraints);
    }

    private void initAddVarBtn() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Services.getController().addVariable(IVPVariablePanel.this.scopeID, "1");
                Tracking.track("event=CLICK;where=BTN_NEWVARIABLE;");
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(IVPVariablePanel.class.getResource("/usp/ime/line/resources/icons/plus_var.png")));
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("IVPVariablePanel.action.addVar") + "Principal");
        this.addVarBtn = new JButton(abstractAction);
        this.addVarBtn.setUI(new IconButtonUI());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridy = 0;
        this.container.add((Component)this.addVarBtn, gridBagConstraints);
    }

    private void initContainer() {
        this.container = new JPanel();
        this.container.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.container.setOpaque(false);
        this.add((Component)this.container, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        this.container.setLayout(gridBagLayout);
    }

    public void repaintVarPanel() {
        this.varPanel.removeAll();
        Object[] objectArray = this.varMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Component component = (Component)this.varMap.get(objectArray[i]);
            if (component == null) continue;
            this.varPanel.add(component);
        }
        this.varPanel.revalidate();
        this.varPanel.repaint();
    }

    public void repaintParamPanel() {
        this.paramPanel.removeAll();
        String[] stringArray = (String[])this.paramMap.keySet().toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            Component component = (Component)this.paramMap.get(stringArray[i]);
            if (component == null) continue;
            this.paramPanel.add(component);
        }
        this.paramPanel.revalidate();
        this.paramPanel.repaint();
    }

    @Override
    public void addedVariable(String string) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (!variable.getVariableName().contains("#@ivprog@#!")) {
            IVPVariableBasic iVPVariableBasic = (IVPVariableBasic)Services.getRenderer().paint(string);
            this.varMap.put(string, iVPVariableBasic);
            this.repaintVarPanel();
        }
    }

    @Override
    public void changeVariable(String string) {
    }

    @Override
    public void removedVariable(String string) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (variable != null && !variable.getVariableName().contains("#@ivprog@#!")) {
            this.varMap.put(string, null);
            this.repaintVarPanel();
        }
    }

    @Override
    public void changeVariableName(String string, String string2, String string3) {
        IVPVariableBasic iVPVariableBasic;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (!variable.getVariableName().contains("#@ivprog@#!") && (iVPVariableBasic = (IVPVariableBasic)Services.getViewMapping().get(string)) != null) {
            iVPVariableBasic.setVariableName(string2);
        }
    }

    @Override
    public void changeVariableValue(String string, String string2) {
        IVPVariableBasic iVPVariableBasic;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (!variable.getVariableName().contains("#@ivprog@#!") && (iVPVariableBasic = (IVPVariableBasic)Services.getViewMapping().get(string)) != null) {
            iVPVariableBasic.setVariableValue(string2);
        }
    }

    @Override
    public void changeVariableType(String string, short s) {
        IVPVariableBasic iVPVariableBasic;
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (!variable.getVariableName().contains("#@ivprog@#!") && (iVPVariableBasic = (IVPVariableBasic)Services.getViewMapping().get(string)) != null) {
            iVPVariableBasic.setVariableType(s);
        }
    }

    @Override
    public void variableRestored(String string) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (!variable.getVariableName().contains("#@ivprog@#!")) {
            IVPVariableBasic iVPVariableBasic = (IVPVariableBasic)Services.getViewMapping().get(string);
            this.varMap.put(string, iVPVariableBasic);
            this.repaintVarPanel();
        }
    }

    @Override
    public void updateReference(String string) {
    }
}

