/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.gui;

import ilm.framework.assignment.Assignment;
import ilm.framework.assignment.AssignmentControl;
import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.domain.DomainGUI;
import ilm.framework.gui.AuthoringGUI;
import ilm.framework.gui.BaseGUI;
import ilm.framework.modules.AssignmentModule;
import ilm.framework.modules.IlmModule;
import ilm.framework.modules.assignment.HistoryModule;
import ilm.framework.modules.assignment.UndoRedoModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import usp.ime.line.ivprog.IlmAuthoringGUI;
import usp.ime.line.ivprog.listeners.IFunctionListener;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.IVPDomainGUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IlmBaseGUI
extends BaseGUI {
    private static final long serialVersionUID = 1L;
    private JPanel buttonsMenu;
    private JPanel panel;
    private JTabbedPane tabbedPane;
    private JButton authoringBtn;
    private JButton newAssBtn;
    private JButton closeAssBtn;
    private JButton openAssBtn;
    private JButton saveAssBtn;
    private int tabCount;
    private boolean isOpening = false;
    private String lastFilePath = null;
    private boolean isApplet = false;
    private JFileChooser jfilechooser = null;

    public IlmBaseGUI() {
        System.out.println("./ilm/framework/gui/IlmBaseGUI.java: IlmBaseGUI()");
        this.setLayout(new BorderLayout(0, 0));
        this.buttonsMenu = new JPanel();
        this.buttonsMenu.setBackground(FlatUIColors.MAIN_BG);
        FlowLayout flowLayout = (FlowLayout)this.buttonsMenu.getLayout();
        flowLayout.setAlignment(0);
        this.add((Component)this.buttonsMenu, "North");
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IlmBaseGUI.this.setActiveAssignment();
            }
        });
        this.tabCount = 0;
    }

    @Override
    protected void initAssignments() {
        System.out.println("./ilm/framework/gui/IlmBaseGUI.java: initAssignments()");
        String string = this._config.getParameter("file");
        if (string != null) {
            this.lastFilePath = string;
        }
        if (this._assignments.getNumberOfAssignments() == 1) {
            this.tabbedPane.setVisible(false);
            this._domainGUIList.add(this._factory.createDomainGUI(this._config, this._factory.getDomainModel(this._config)));
            int n = this._domainGUIList.size() - 1;
            ((DomainGUI)this._domainGUIList.get(n)).setAssignment(this._assignments.getProposition(0), this._assignments.getCurrentState(0), this._assignments.getIlmModuleList().values());
            this.panel.add((Component)this._domainGUIList.get(n));
            this._authoringGUIList.add(this._factory.createAuthoringGUI((DomainGUI)this._domainGUIList.get(n), this._assignments.getProposition(0), this._assignments.getInitialState(0), this._assignments.getCurrentState(0), this._assignments.getExpectedAnswer(0), this._assignments.getConfig(0), this._assignments.getMetadata(0)));
            this.setActiveAssignment();
            this.initModelAndUI(n);
        } else {
            this.panel.add(this.tabbedPane);
            for (int i = 0; i < this._assignments.getNumberOfAssignments(); ++i) {
                this.tabbedPane.setVisible(true);
                this.initAssignment(this._assignments.getCurrentState(i));
            }
        }
    }

    private void initModelAndUI(int n) {
        Services.getController().getProgram().addFunctionListener((IFunctionListener)this._domainGUIList.get(n));
        Services.getController().initializeModel();
        this.recuperandoEstado(this._assignments.getIlmModuleList().values());
    }

    private void initAssignment(AssignmentState assignmentState) {
        this._domainGUIList.add(this._factory.createDomainGUI(this._config, this._factory.getDomainModel(this._config)));
        int n = this._domainGUIList.size() - 1;
        ((DomainGUI)this._domainGUIList.get(n)).setAssignment(this._assignments.getProposition(n), assignmentState, this._assignments.getIlmModuleList().values());
        this.tabbedPane.addTab("assign" + this.tabCount++, (Component)this._domainGUIList.get(n));
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        this.setActiveAssignment();
        this.initModelAndUI(n);
        this._authoringGUIList.add(this._factory.createAuthoringGUI((DomainGUI)this._domainGUIList.get(n), this._assignments.getProposition(n), this._assignments.getInitialState(n), this._assignments.getCurrentState(n), this._assignments.getExpectedAnswer(n), this._assignments.getConfig(n), this._assignments.getMetadata(n)));
    }

    @Override
    public void initToolbar(Collection collection, boolean bl) {
        this.addToolBarButtons(bl);
        Iterator iterator = collection.iterator();
        this.isApplet = bl;
        while (iterator.hasNext()) {
            IlmModule ilmModule = (IlmModule)iterator.next();
            this.buttonsMenu.add(ilmModule.getGUI());
            this.buttonsMenu.add(Box.createHorizontalStrut(50));
        }
    }

    private void addToolBarButtons(boolean bl) {
        if (!bl) {
            this.setAuthoringButton();
            this.setNewAssignmentButton();
            this.setCloseAssignmentButton();
            this.setOpenAssignmentButton();
            this.setSaveAssignmentButton();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    protected void setActiveAssignment() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            this.updateAssignmentIndex(0);
            Services.getController().setGui((IVPDomainGUI)this._domainGUIList.get(0));
        } else {
            this.updateAssignmentIndex(n);
            Services.getController().setGui((IVPDomainGUI)this._domainGUIList.get(n));
        }
    }

    @Override
    protected void setAuthoringButton() {
        this.authoringBtn = this.makeButton("authoring", "ASSIGNMENT AUTHORING", ResourceBundleIVP.getString("authoringBtn.Tip"), ResourceBundleIVP.getString("authoringBtn.AltText"));
        this.buttonsMenu.add(this.authoringBtn);
        this.authoringBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlmBaseGUI.this.startAuthoring();
                Tracking.track("event=CLICK;where=BTN_AUTHORING;");
            }
        });
    }

    @Override
    protected void startAuthoring() {
        ((JFrame)this._authoringGUIList.get(this._activeAssignment)).setVisible(true);
    }

    @Override
    protected void setNewAssignmentButton() {
        this.newAssBtn = this.makeButton("newassignment", "NEW ASSIGNMENT", ResourceBundleIVP.getString("newAssBtn.Tip"), ResourceBundleIVP.getString("newAssBtn.AltText"));
        this.buttonsMenu.add(this.newAssBtn);
        this.newAssBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlmBaseGUI.this.addNewAssignment();
                Tracking.track("event=CLICK;where=BTN_NEW_ASSIGNMENT;");
            }
        });
    }

    @Override
    protected void addNewAssignment() {
        if (this._assignments.getNumberOfAssignments() == 1) {
            this.panel.removeAll();
            this.panel.add(this.tabbedPane);
            this.tabbedPane.setVisible(true);
            this.tabbedPane.addTab("atividade " + this.tabCount++, (Component)this._domainGUIList.get(0));
            AssignmentState assignmentState = this._assignments.newAssignment();
            this.initAssignment(assignmentState);
        } else {
            this.initAssignment(this._assignments.newAssignment());
        }
        this.updateCloseButton();
    }

    @Override
    protected void setCloseAssignmentButton() {
        this.closeAssBtn = this.makeButton("closeassignment", "CLOSE ASSIGNMENT", ResourceBundleIVP.getString("closeAssBtn.Tip"), ResourceBundleIVP.getString("closeAssBtn.Tip"));
        this.buttonsMenu.add(this.closeAssBtn);
        this.closeAssBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlmBaseGUI.this.closeAssignment(IlmBaseGUI.this.tabbedPane.getSelectedIndex());
                Tracking.track("event=CLICK;where=BTN_CLOSE_ASSIGNMENT;");
            }
        });
        this.updateCloseButton();
    }

    @Override
    protected void closeAssignment(int n) {
        if (this._assignments.getNumberOfAssignments() != 1) {
            if (this._assignments.getNumberOfAssignments() == 2) {
                this.closeActiveAssignment();
                this.panel.removeAll();
                this.panel.add((Component)this._domainGUIList.get(0));
                ((JComponent)this._domainGUIList.get(0)).setVisible(true);
                this.updateCloseButton();
            } else {
                this.closeActiveAssignment();
            }
        }
    }

    private void updateCloseButton() {
        if (this._assignments.getNumberOfAssignments() == 1) {
            this.closeAssBtn.setEnabled(false);
        } else {
            this.closeAssBtn.setEnabled(true);
        }
    }

    private void closeActiveAssignment() {
        int n = this._activeAssignment;
        this._assignments.closeAssignment(n);
        this.tabbedPane.remove(n);
        this._domainGUIList.remove(n);
        this._authoringGUIList.remove(n);
        this.setActiveAssignment();
    }

    @Override
    protected void setOpenAssignmentButton() {
        String string = ResourceBundleIVP.getString("openAssBtn.AltText");
        this.openAssBtn = this.makeButton("openassignment", "OPEN ASSIGNMENT FILE", ResourceBundleIVP.getString("openAssBtn.Tip"), string);
        this.buttonsMenu.add(this.openAssBtn);
        if (!this.isApplet) {
            this.jfilechooser = new JFileChooser();
        }
        this.openAssBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlmBaseGUI.this.jfilechooser.setCurrentDirectory(new File("."));
                IlmBaseGUI.this.openAssignmentFile(IlmBaseGUI.this.getFileNameFromWindow("Choose file"));
                Tracking.track("event=CLICK;where=BTN_OPEN_ASSIGNMENT;");
            }
        });
    }

    public void openAssignmentFileCommandLine(String string) {
        this.openAssignmentFile(string);
    }

    @Override
    protected void openAssignmentFile(String string) {
        int n;
        int n2;
        this.panel.removeAll();
        this.panel.add((Component)this._domainGUIList.get(0));
        ((JComponent)this._domainGUIList.get(0)).setVisible(true);
        if (string == null) {
            return;
        }
        for (n2 = n = this._assignments.openAssignmentPackage(string); n2 < this._assignments.getNumberOfAssignments(); ++n2) {
            if (this._domainGUIList.size() == 1) {
                this.panel.removeAll();
                this.panel.add(this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.tabbedPane.addTab("atividade " + this.tabCount++, (Component)this._domainGUIList.get(0));
            }
            this.isOpening = true;
            this.initAssignment(this._assignments.getCurrentState(n2));
            this.isOpening = false;
        }
        this.updateCloseButton();
        n2 = 0;
        this._assignments.closeAssignment(n2);
        this.tabbedPane.remove(n2);
        this._domainGUIList.remove(n2);
        this._authoringGUIList.remove(n2);
        this.setActiveAssignment();
        this.panel.removeAll();
        this.panel.add((Component)this._domainGUIList.get(0));
        ((JComponent)this._domainGUIList.get(0)).setVisible(true);
    }

    public void openAssignmentFromURL(String string) {
        int n;
        int n2;
        this.panel.removeAll();
        this.panel.add((Component)this._domainGUIList.get(0));
        ((JComponent)this._domainGUIList.get(0)).setVisible(true);
        if (string == null) {
            return;
        }
        for (n2 = n = ((AssignmentControl)this._assignments).openAssignmentPackageFromURL(string); n2 < this._assignments.getNumberOfAssignments(); ++n2) {
            if (this._domainGUIList.size() == 1) {
                this.panel.removeAll();
                this.panel.add(this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.tabbedPane.addTab("atividade " + this.tabCount++, (Component)this._domainGUIList.get(0));
            }
            this.isOpening = true;
            this.initAssignment(this._assignments.getCurrentState(n2));
            this.isOpening = false;
        }
        n2 = 0;
        this._assignments.closeAssignment(n2);
        this.tabbedPane.remove(n2);
        this._domainGUIList.remove(n2);
        this._authoringGUIList.remove(n2);
        this.setActiveAssignment();
        this.panel.removeAll();
        this.panel.add((Component)this._domainGUIList.get(0));
        ((JComponent)this._domainGUIList.get(0)).setVisible(true);
    }

    private String getFileNameFromWindow(String string) {
        int n = this.jfilechooser.showDialog(this, string);
        if (n == 0) {
            String string2 = this.jfilechooser.getSelectedFile().toString();
            System.out.println("------------------------------\n./ilm/framework/gui/IlmBaseGUI.java: getFileNameFromWindow(...): " + string2);
            return string2;
        }
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Error while choosing file.", "Error file", 0);
        }
        return null;
    }

    @Override
    protected void setSaveAssignmentButton() {
        this.saveAssBtn = this.makeButton("save", "SAVE ASSIGNMENT FILE", ResourceBundleIVP.getString("saveAssBtn.Tip"), ResourceBundleIVP.getString("saveAssBtn.AltText"));
        this.buttonsMenu.add(this.saveAssBtn);
        this.saveAssBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlmBaseGUI.this.jfilechooser.setCurrentDirectory(new File("."));
                IlmBaseGUI.this.saveAssignmentFile(IlmBaseGUI.this.getFileNameFromWindow("Choose filename"));
                Tracking.track("event=CLICK;where=BTN_SAVE_ASSIGNMENT;");
            }
        });
    }

    @Override
    protected void saveAssignmentFile(String string) {
        if (string == null) {
            return;
        }
        Vector<Assignment> vector = new Vector<Assignment>();
        for (int i = 0; i < this._assignments.getNumberOfAssignments(); ++i) {
            if (((AuthoringGUI)this._authoringGUIList.get(i)).getProposition().length() > 1) {
                vector.add(((AuthoringGUI)this._authoringGUIList.get(i)).getAssignment());
                continue;
            }
            Assignment assignment = new Assignment(this._assignments.getProposition(i), this._assignments.getInitialState(i), this._assignments.getCurrentState(i), this._assignments.getExpectedAnswer(i));
            if (this.tabbedPane.getTabCount() == 0) {
                assignment.setName("atividade" + this.tabCount);
            } else {
                assignment.setName(this.tabbedPane.getTitleAt(i));
            }
            assignment.setTestCase(((IlmAuthoringGUI)this._authoringGUIList.get(i)).getTestCases());
            assignment.setConfig(this._assignments.getConfig(i));
            assignment.setMetadata(this._assignments.getMetadata(i));
            vector.add(assignment);
        }
        this._assignments.saveAssignmentPackage(vector, string);
    }

    public void recuperandoEstado(Collection collection) {
        if (!this.isOpening) {
            return;
        }
        Iterator iterator = collection.iterator();
        HistoryModule historyModule = null;
        UndoRedoModule undoRedoModule = null;
        while (iterator.hasNext()) {
            IlmModule ilmModule = (IlmModule)iterator.next();
            if (!(ilmModule instanceof AssignmentModule)) continue;
            if (ilmModule.getName().equals("history")) {
                historyModule = (HistoryModule)ilmModule;
                continue;
            }
            if (!ilmModule.getName().equals("undo_redo")) continue;
            undoRedoModule = (UndoRedoModule)ilmModule;
        }
        if (historyModule != null) {
            historyModule.executeActions();
        }
        if (undoRedoModule != null) {
            undoRedoModule.restoreFromFile();
        }
    }
}

