/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;

public final class SystemConfig
extends Observable
implements Serializable {
    private static final String CUSTOM_PROPERTIES_KEY = "config";
    private Properties _parameters;
    private boolean _isApplet;
    private Locale _currentLocale;

    public SystemConfig(boolean bl, Map map) {
        this(bl, map, null);
    }

    public SystemConfig(boolean bl, Map map, Properties properties) {
        if (properties != null) {
            this._parameters = properties;
        } else {
            try {
                if (!bl) {
                    if (map.containsKey(CUSTOM_PROPERTIES_KEY)) {
                        this._parameters = new Properties();
                        this._parameters.load(this.getClass().getResourceAsStream((String)map.get(CUSTOM_PROPERTIES_KEY)));
                    } else {
                        this._parameters = this.getDefaultProperties();
                    }
                } else {
                    this._parameters = new Properties();
                    this._parameters.putAll((Map<?, ?>)map);
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                invalidParameterException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this._isApplet = bl;
        this.setProperties(map);
    }

    public Properties getParameters() {
        return this._parameters;
    }

    public String getParameter(String string) {
        return (String)this._parameters.get(string);
    }

    private Properties getDefaultProperties() throws InvalidParameterException, FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(this.getClass().getResourceAsStream("defaultConfig.properties"));
        return properties;
    }

    private void setProperties(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this._parameters.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setParameter(String string, String string2) {
        this._parameters.setProperty(string, string2);
        this.setChanged();
        this.notifyObservers();
    }

    public void setLanguage(String string) {
        this._currentLocale = new Locale(string);
        this.setChanged();
        this.notifyObservers();
    }

    public String getValue(String string) {
        return this._parameters.getProperty(string);
    }

    public Locale getLanguage() {
        return this._currentLocale;
    }

    public boolean isApplet() {
        return this._isApplet;
    }

    public String toString() {
        String string = "";
        Enumeration<?> enumeration = this._parameters.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + "<" + string2 + ">" + this._parameters.getProperty(string2) + "</" + string2 + ">";
        }
        return string;
    }
}

