/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.modules.assignment;

import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.assignment.model.DomainAction;
import ilm.framework.domain.DomainConverter;
import ilm.framework.domain.DomainModel;
import ilm.framework.modules.AssignmentModule;
import ilm.framework.modules.IlmModule;
import ilm.framework.modules.assignment.HistoryModuleToolbar;
import java.io.Serializable;
import java.util.Collection;
import java.util.Observable;
import java.util.Vector;

public class HistoryModule
extends AssignmentModule
implements Serializable {
    private Vector _history = new Vector();

    public HistoryModule() {
        this._name = "history";
        this._gui = new HistoryModuleToolbar();
        this._observerType = 1;
    }

    Vector getHistory() {
        return (Vector)this._history.get(this._assignmentIndex);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof DomainAction) {
            DomainAction domainAction = (DomainAction)observable;
            if (!domainAction.isUndo()) {
                ((Vector)this._history.get(this._assignmentIndex)).add((DomainAction)domainAction.clone());
                this.setChanged();
                this.notifyObservers();
            } else {
                ((Vector)this._history.get(this._assignmentIndex)).remove(((Vector)this._history.get(this._assignmentIndex)).size() - 1);
                this.setChanged();
                this.notifyObservers();
            }
        }
    }

    @Override
    public void setContentFromString(DomainConverter domainConverter, int n, String string) {
        if (this._history.size() == n) {
            this.addAssignment();
        }
        Vector vector = domainConverter.convertStringToAction(string);
        for (int i = 0; i < vector.size(); ++i) {
            ((DomainAction)vector.get(i)).addObserver(this);
            ((Vector)this._history.get(n)).add(vector.get(i));
        }
    }

    @Override
    public void addAssignment() {
        this._history.add(new Vector());
    }

    @Override
    public void print() {
        for (int i = 0; i < this._history.size(); ++i) {
            for (int j = 0; j < ((Vector)this._history.get(i)).size(); ++j) {
                DomainAction domainAction = (DomainAction)((Vector)this._history.get(i)).get(j);
            }
        }
    }

    @Override
    public String getStringContent(DomainConverter domainConverter, int n) {
        if (((Vector)this._history.get(this._assignmentIndex)).size() == 0) {
            return "<" + this._name + "/>";
        }
        String string = "<" + this._name + ">";
        string = string + domainConverter.convertActionToString((Vector)this._history.get(n));
        string = string + "</" + this._name + ">";
        return string;
    }

    @Override
    public void removeAssignment(int n) {
        this._history.remove(n);
    }

    @Override
    public void setDomainModel(DomainModel domainModel) {
        for (int i = 0; i < this._history.size(); ++i) {
            Vector vector = (Vector)this._history.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                DomainAction domainAction = (DomainAction)vector.get(j);
                domainAction.setDomainModel(domainModel);
            }
        }
    }

    @Override
    public void setState(AssignmentState assignmentState) {
        for (int i = 0; i < ((Vector)this._history.get(this._history.size() - 1)).size(); ++i) {
            DomainAction domainAction = (DomainAction)((Vector)this._history.get(this._history.size() - 1)).get(i);
            domainAction.setState(assignmentState);
        }
    }

    @Override
    public void setActionObservers(Collection collection) {
        for (IlmModule ilmModule : collection) {
            if (!(ilmModule instanceof AssignmentModule)) continue;
            for (int i = 0; i < this._history.size(); ++i) {
                Vector vector = (Vector)this._history.get(i);
                for (int j = 0; j < vector.size(); ++j) {
                    DomainAction domainAction = (DomainAction)vector.get(j);
                    domainAction.addObserver((AssignmentModule)ilmModule);
                }
            }
        }
    }

    public void executeActions() {
        System.out.println("\n----------\n./ilm/framework/modules/assignment/HistoryModule.java: executeActions(): start silence!");
        DomainAction.setExecutingInSilence(true);
        for (int i = 0; i < this._history.size(); ++i) {
            Vector vector = (Vector)this._history.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                DomainAction domainAction = (DomainAction)vector.get(j);
                domainAction.executeInSilence();
            }
        }
        DomainAction.setExecutingInSilence(false);
        System.out.println("./ilm/framework/modules/assignment/HistoryModule.java: executeActions(): end silence!\n----------\n");
    }
}

