/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.swing;

import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.ReturnValueTracker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DialogManager {
    private static Stack s_stack = new Stack();

    private static JDialog createModalDialog(String title) {
        Component parent;
        try {
            parent = (Component)s_stack.peek();
        }
        catch (EmptyStackException ese) {
            parent = new Frame("empty stack");
            parent.show();
        }
        JDialog dialog = parent instanceof Dialog ? new JDialog((Dialog)parent, title, true) : new JDialog((Frame)parent, title, true);
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    private static void showModalDialog(JDialog dialog, boolean requiresSetLocationRelativeToOwner) {
        if (dialog.isModal()) {
            if (requiresSetLocationRelativeToOwner) {
                dialog.setLocationRelativeTo(dialog.getOwner());
            }
            s_stack.push(dialog);
            try {
                dialog.show();
            }
            finally {
                s_stack.pop();
            }
        } else {
            throw new RuntimeException("DialogManager only handles *modal* dialogs");
        }
    }

    private static void showModalDialog(JDialog dialog) {
        DialogManager.showModalDialog(dialog, true);
    }

    public static void initialize(Window root) {
        s_stack.clear();
        s_stack.push(root);
    }

    public static int showDialog(ContentPane contentPane) {
        JDialog dialog = DialogManager.createModalDialog(contentPane.getTitle());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)contentPane, "Center");
        dialog.pack();
        class ContentPaneReturnValueTracker
        extends ReturnValueTracker {
            private ContentPane m_contentPane;
            private ActionListener m_okListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (m_contentPane.isReadyToDispose(0)) {
                        this.setReturnValue(0);
                        this.getDialog().dispose();
                    }
                }
            };
            private ActionListener m_cancelListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (m_contentPane.isReadyToDispose(2)) {
                        this.setReturnValue(2);
                        this.getDialog().dispose();
                    }
                }
            };

            public ContentPaneReturnValueTracker(JDialog dialog, ContentPane contentPane) {
                super(dialog, 2);
                this.m_contentPane = contentPane;
                this.m_contentPane.addOKActionListener(this.m_okListener);
                this.m_contentPane.addCancelActionListener(this.m_cancelListener);
            }

            protected void onWindowClosing(WindowEvent e) {
                if (this.m_contentPane.isReadyToDispose(2)) {
                    this.setReturnValue(2);
                    this.m_contentPane.handleDispose();
                }
            }

            public void removeListeners() {
                super.removeListeners();
                this.m_contentPane.removeOKActionListener(this.m_okListener);
                this.m_contentPane.removeCancelActionListener(this.m_cancelListener);
            }
        }
        ContentPaneReturnValueTracker returnValueTracker = new ContentPaneReturnValueTracker(dialog, contentPane);
        contentPane.preDialogShow(dialog);
        DialogManager.showModalDialog(dialog, false);
        contentPane.postDialogShow(dialog);
        returnValueTracker.removeListeners();
        return returnValueTracker.getReturnValue();
    }

    public static Color showDialog(JColorChooser colorChooser, String title, Color initialColor) {
        class ColorTracker
        implements ActionListener {
            Color m_color = null;
            private final /* synthetic */ JColorChooser val$colorChooser;

            ColorTracker(JColorChooser jColorChooser) {
                this.val$colorChooser = jColorChooser;
            }

            public void actionPerformed(ActionEvent e) {
                this.m_color = this.val$colorChooser.getColor();
            }

            public Color getColor() {
                return this.m_color;
            }
        }
        ColorTracker colorTracker = new ColorTracker(colorChooser);
        Component parent = (Component)s_stack.peek();
        JDialog dialog = JColorChooser.createDialog(parent, title, true, colorChooser, colorTracker, null);
        DialogManager.showModalDialog(dialog);
        return colorTracker.getColor();
    }

    public static int showDialog(JFileChooser fileChooser, String approveButtonText) {
        if (approveButtonText != null) {
            fileChooser.setApproveButtonText(approveButtonText);
            fileChooser.setDialogType(2);
        }
        String title = fileChooser.getUI().getDialogTitle(fileChooser);
        fileChooser.getAccessibleContext().setAccessibleDescription(title);
        JDialog dialog = DialogManager.createModalDialog(title);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)fileChooser, "Center");
        dialog.pack();
        class FileChooserReturnValueTracker
        extends ReturnValueTracker {
            private JFileChooser m_fileChooser;
            private ActionListener m_actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    if (command.equals("ApproveSelection")) {
                        this.setReturnValue(0);
                    } else if (command.equals("CancelSelection")) {
                        this.setReturnValue(1);
                    }
                    this.getDialog().dispose();
                }
            };

            public FileChooserReturnValueTracker(JDialog dialog, JFileChooser fileChooser) {
                super(dialog, 1);
                this.m_fileChooser = fileChooser;
                this.m_fileChooser.addActionListener(this.m_actionListener);
            }

            protected void onWindowClosing(WindowEvent e) {
                this.setReturnValue(1);
                this.getDialog().dispose();
            }

            public void removeListeners() {
                super.removeListeners();
                this.m_fileChooser.removeActionListener(this.m_actionListener);
            }
        }
        FileChooserReturnValueTracker returnValueTracker = new FileChooserReturnValueTracker(dialog, fileChooser);
        fileChooser.rescanCurrentDirectory();
        DialogManager.showModalDialog(dialog);
        returnValueTracker.removeListeners();
        return returnValueTracker.getReturnValue();
    }

    public static int showOpenDialog(JFileChooser fileChooser) {
        fileChooser.setDialogType(0);
        return DialogManager.showDialog(fileChooser, null);
    }

    public static int showSaveDialog(JFileChooser fileChooser) {
        fileChooser.setDialogType(1);
        return DialogManager.showDialog(fileChooser, null);
    }

    private static String getUIManagerString(Object key) {
        if (key.equals("OptionPane.inputDialogTitle")) {
            return "Input";
        }
        if (key.equals("OptionPane.messageDialogTitle")) {
            return "Message";
        }
        if (key.equals("OptionPane.titleText")) {
            return "Select an Option";
        }
        return "";
    }

    public static String showInputDialog(Object message, String title, int messageType) {
        return (String)DialogManager.showInputDialog(message, title, messageType, null, null, null, false);
    }

    public static String showNumericDialog(Object message, String title, int messageType) {
        return (String)DialogManager.showInputDialog(message, title, messageType, null, null, null, true);
    }

    public static Object showInputDialog(Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue, boolean isNumber) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        if (isNumber) {
            DialogManager.addTextFieldListener(pane.getComponents());
        }
        Component parent = (Component)s_stack.peek();
        pane.setComponentOrientation(parent.getComponentOrientation());
        JDialog dialog = pane.createDialog(parent, title);
        pane.selectInitialValue();
        DialogManager.showModalDialog(dialog);
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    private static void addTextFieldListener(Component[] components) {
        if (components == null || components.length < 1) {
            return;
        }
        Component[] componentArray = components;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component = componentArray[n];
            if (component instanceof JPanel) {
                JPanel panel = (JPanel)component;
                DialogManager.addTextFieldListener(panel.getComponents());
            } else if (component instanceof JTextField) {
                component.addKeyListener(new KeyAdapter(){

                    public void keyTyped(KeyEvent e) {
                        char c = e.getKeyChar();
                        if (!Character.isDigit(c) && c != '-' && c != '.' && c != '\b' && c != '\u007f') {
                            e.consume();
                        }
                    }
                });
            }
            ++n;
        }
    }

    public static void showMessageDialog(Object message) {
        DialogManager.showMessageDialog(message, DialogManager.getUIManagerString("OptionPane.messageDialogTitle"), 1);
    }

    public static void showMessageDialog(Object message, String title, int messageType) {
        DialogManager.showMessageDialog(message, title, messageType, null);
    }

    public static void showMessageDialog(Object message, String title, int messageType, Icon icon) {
        DialogManager.showOptionDialog(message, title, -1, messageType, icon, null, null);
    }

    public static int showConfirmDialog(Object message) {
        return DialogManager.showConfirmDialog(message, DialogManager.getUIManagerString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Object message, String title, int optionType) {
        return DialogManager.showConfirmDialog(message, title, optionType, 3);
    }

    public static int showConfirmDialog(Object message, String title, int optionType, int messageType) {
        return DialogManager.showConfirmDialog(message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Object message, String title, int optionType, int messageType, Icon icon) {
        return DialogManager.showOptionDialog(message, title, optionType, messageType, icon, null, null);
    }

    public static int showOptionDialog(Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        Component parent = (Component)s_stack.peek();
        pane.setComponentOrientation(parent.getComponentOrientation());
        JDialog dialog = pane.createDialog(parent, title);
        pane.selectInitialValue();
        DialogManager.showModalDialog(dialog);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int counter = 0;
        int maxCounter = options.length;
        while (counter < maxCounter) {
            if (options[counter].equals(selectedValue)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }
}

