/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.progress;

import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class ProgressPane
extends ContentPane
implements ProgressObserver {
    private JLabel m_descriptionLabel;
    private JProgressBar m_progressBar;
    private JButton m_cancelButton;
    private String m_title;
    private String m_preDescription;
    private Vector m_okActionListeners = new Vector();
    private Vector m_cancelActionListeners = new Vector();
    private final int UNKNOWN_TOTAL_MAX = 100;
    private int m_total;
    private boolean m_isCanceled = false;
    private boolean m_isFinished = false;

    public ProgressPane(String title, String preDescription) {
        this.m_title = title;
        this.m_preDescription = preDescription;
        this.m_descriptionLabel = new JLabel();
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setPreferredSize(new Dimension(240, 16));
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressPane.this.onCancel();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets.top = 10;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        this.add((Component)this.m_descriptionLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 10;
        this.add((Component)this.m_progressBar, gbc);
        gbc.weighty = 1.0;
        this.add((Component)new JLabel(), gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this.add((Component)this.m_cancelButton, gbc);
    }

    public void handleDispose() {
        this.onCancel();
    }

    protected abstract void construct() throws ProgressCancelException;

    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        new Thread(new Runnable(){

            public void run() {
                try {
                    ProgressPane.this.construct();
                    ProgressPane.this.fireOKActionListeners();
                }
                catch (ProgressCancelException pce) {
                    ProgressPane.this.fireCancelActionListeners();
                }
            }
        }).start();
    }

    public boolean isCancelEnabled() {
        return this.m_cancelButton.isEnabled();
    }

    public void setIsCancelEnabled(boolean isCancelEnabled) {
        this.m_cancelButton.setEnabled(isCancelEnabled);
    }

    public boolean isReadyToDispose(int option) {
        if (this.m_isFinished) {
            return true;
        }
        if (this.isCancelEnabled()) {
            return true;
        }
        return option != 2;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void addOKActionListener(ActionListener l) {
        this.m_okActionListeners.addElement(l);
    }

    public void removeOKActionListener(ActionListener l) {
        this.m_okActionListeners.removeElement(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.m_cancelActionListeners.addElement(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this.m_cancelActionListeners.removeElement(l);
    }

    public void progressBegin(int total) {
        this.m_descriptionLabel.setText(this.m_preDescription);
        this.progressUpdateTotal(total);
        this.m_isCanceled = false;
        this.m_isFinished = false;
    }

    public void progressUpdateTotal(int total) {
        this.m_total = total;
        if (this.m_total == -1) {
            this.m_progressBar.setMaximum(100);
        } else {
            this.m_progressBar.setMaximum(this.m_total);
        }
    }

    public void progressUpdate(final int current, final String description) throws ProgressCancelException {
        if (this.m_isCanceled) {
            this.m_isCanceled = false;
            throw new ProgressCancelException();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ProgressPane.this.m_preDescription != null) {
                    if (description != null) {
                        ProgressPane.this.m_descriptionLabel.setText(String.valueOf(ProgressPane.this.m_preDescription) + description);
                    } else {
                        ProgressPane.this.m_descriptionLabel.setText(ProgressPane.this.m_preDescription);
                    }
                }
                if (ProgressPane.this.m_total == -1) {
                    ProgressPane.this.m_progressBar.setValue(current % 100);
                } else {
                    ProgressPane.this.m_progressBar.setValue(current);
                }
            }
        });
    }

    public void progressEnd() {
    }

    private void onCancel() {
        this.m_isCanceled = true;
    }

    private void fireActionListeners(final Vector actionListeners, final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i = 0;
                while (i < actionListeners.size()) {
                    ActionListener l = (ActionListener)actionListeners.elementAt(i);
                    l.actionPerformed(e);
                    ++i;
                }
            }
        });
    }

    protected void fireOKActionListeners() {
        this.fireActionListeners(this.m_okActionListeners, new ActionEvent(this, 1001, "OK"));
    }

    protected void fireCancelActionListeners() {
        this.fireActionListeners(this.m_cancelActionListeners, new ActionEvent(this, 1001, "Cancel"));
    }
}

