/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import java.io.File;

public class FileUtilities {
    private static boolean s_successfullyLoadedLibrary;
    public static final int DIRECTORY_DOES_NOT_EXIST = -1;
    public static final int DIRECTORY_IS_NOT_WRITABLE = -2;
    public static final int DIRECTORY_IS_WRITABLE = 1;
    public static final int BAD_DIRECTORY_INPUT = -3;

    static {
        try {
            System.loadLibrary("jni_fileutilities");
            s_successfullyLoadedLibrary = true;
        }
        catch (Throwable t) {
            s_successfullyLoadedLibrary = false;
        }
    }

    public static boolean isFileCopySupported() {
        return s_successfullyLoadedLibrary;
    }

    private static native boolean copy(String var0, String var1, boolean var2, ProgressObserver var3) throws ProgressCancelException;

    public static boolean copy(File src, File dst, boolean overwriteIfNecessary, ProgressObserver progressObserver) throws ProgressCancelException {
        if (FileUtilities.isFileCopySupported()) {
            dst.getParentFile().mkdirs();
            if (progressObserver != null) {
                progressObserver.progressBegin(-1);
            }
            try {
                boolean bl = FileUtilities.copy(src.getAbsolutePath(), dst.getAbsolutePath(), overwriteIfNecessary, progressObserver);
                return bl;
            }
            finally {
                if (progressObserver != null) {
                    progressObserver.progressEnd();
                }
            }
        }
        return false;
    }

    public static void copy(File src, File dst, boolean overwriteIfNecessary) {
        try {
            FileUtilities.copy(src, dst, overwriteIfNecessary, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error("caught ProgressCancelException without ProgressObserver");
        }
    }

    public static String getExtension(String filename) {
        int index;
        String extension = null;
        if (filename != null && (index = filename.lastIndexOf(46)) != -1) {
            extension = filename.substring(index + 1);
        }
        return extension;
    }

    public static String getExtension(File file) {
        if (file != null) {
            return FileUtilities.getExtension(file.getName());
        }
        return null;
    }

    public static String getBaseName(String filename) {
        String basename = null;
        if (filename != null) {
            int index = filename.lastIndexOf(46);
            basename = index != -1 ? filename.substring(0, index) : filename;
        }
        return basename;
    }

    public static String getBaseName(File file) {
        if (file != null) {
            return FileUtilities.getBaseName(file.getName());
        }
        return null;
    }

    public static int isWritableDirectory(File directory) {
        boolean writable;
        if (directory == null || !directory.isDirectory()) {
            return -3;
        }
        File testFile = new File(directory, "test.test");
        if (testFile.exists()) {
            writable = testFile.canWrite();
        } else {
            try {
                try {
                    boolean success;
                    writable = success = testFile.createNewFile();
                }
                catch (Throwable t) {
                    writable = false;
                }
            }
            finally {
                testFile.delete();
            }
        }
        if (!writable) {
            return -2;
        }
        if (!directory.exists() || !directory.canRead()) {
            return -1;
        }
        return 1;
    }
}

