/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class DynamicFlowLayout
extends FlowLayout {
    private Dimension lastPreferredSize;
    private Component anchorComponent;
    private int anchorConstant = 0;
    private Class anchorClass;

    public DynamicFlowLayout(int align, Component anchor, Class anchorClass, int anchorConstant) {
        super(align);
        this.anchorComponent = anchor;
        this.anchorClass = anchorClass;
        this.anchorConstant = anchorConstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            if (this.lastPreferredSize == null) {
                this.lastPreferredSize = this.preferredLayoutSize(target);
            }
            int maxwidth = this.lastPreferredSize.width;
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    m.setSize(d.width, d.height);
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowh = Math.max(rowh, d.height);
                    } else {
                        this.moveComponents(target, insets.left + hgap, y, maxwidth - x, rowh, start, i, ltr);
                        x = d.width;
                        y += vgap + rowh;
                        rowh = d.height;
                        start = i;
                    }
                }
                ++i;
            }
            this.moveComponents(target, insets.left + hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            int i = rowStart;
            while (i < rowEnd) {
                Component m = target.getComponent(i);
                if (target.isVisible()) {
                    if (ltr) {
                        m.setLocation(x, y + (height - m.getHeight()) / 2);
                    } else {
                        m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                    }
                    x += m.getWidth() + this.getHgap();
                }
                ++i;
            }
        }
    }

    public Dimension preferredLayoutSize(Container target) {
        Insets insets = target.getInsets();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        if (this.anchorComponent == null) {
            this.anchorComponent = this.getAnchor(target);
        }
        int maxwidth = 0;
        maxwidth = this.anchorComponent == null ? target.getWidth() - (insets.left + insets.right + hgap * 2) : this.anchorComponent.getWidth() - (insets.left + insets.right + hgap * 2) - this.anchorConstant;
        int nmembers = target.getComponentCount();
        int x = 0;
        int y = insets.top + vgap;
        int rowh = 0;
        if (maxwidth < 0) {
            maxwidth = 0;
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    y = Math.max(y, d.height);
                    if (d.width > 0 && d.height > 0) {
                        if (maxwidth > 0) {
                            maxwidth += hgap;
                        }
                        maxwidth += d.width;
                    }
                }
                ++i;
            }
        } else {
            target.getComponentOrientation().isLeftToRight();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowh = Math.max(rowh, d.height);
                    } else {
                        x = d.width;
                        y += vgap + rowh;
                        rowh = d.height;
                    }
                }
                ++i;
            }
        }
        this.lastPreferredSize = new Dimension(maxwidth, y + rowh + vgap);
        return this.lastPreferredSize;
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    private Component getAnchor(Component current) {
        if (current == null || this.anchorClass.isAssignableFrom(current.getClass())) {
            return current;
        }
        return this.getAnchor(current.getParent());
    }
}

