/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class ImageProperty
extends ObjectProperty {
    public ImageProperty(Element owner, String name, Image defaultValue) {
        super(owner, name, defaultValue, Image.class);
    }

    public Image getImageValue() {
        return (Image)this.getValue();
    }

    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        loader.readFile(filename);
        loader.closeCurrentFile();
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object associatedFileKey;
        this.getImageValue();
        String extension = "png";
        String filename = String.valueOf(this.getName()) + "." + extension;
        try {
            associatedFileKey = storer.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            associatedFileKey = null;
        }
        if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileKey)) {
            this.m_associatedFileKey = null;
            OutputStream os = storer.createFile(filename, false);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.flush();
            storer.closeCurrentFile();
            this.m_associatedFileKey = associatedFileKey;
        } else if (storer.isKeepFileSupported()) {
            try {
                storer.keepFile(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                throw new Error(storer + " returns true for isKeepFileSupported(), but then throws " + kfnse);
            }
            catch (KeepFileDoesNotExistException kfdne) {
                throw new ExceptionWrapper(kfdne, filename);
            }
        }
        node.appendChild(this.createNodeForString(document, "java.io.File[" + filename + "]"));
    }

    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        Image imageValue = this.getImageValue();
        if (imageValue instanceof RenderedImage) {
            String extension = "png";
            String filename = String.valueOf(this.getName()) + "." + extension;
            storer.keepFile(filename);
        }
    }
}

